/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.entity.config;

import java.util.Map;
import java.util.Properties;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.loghealth.entity.config.KafkaConfig;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;
import kd.bos.util.StringUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaConfigFactory {
    public static KafkaConfig createKafkaConfig(Map<String, String> kafkaConfigInLog) {
        KafkaConfig kafkaConfig = new KafkaConfig();
        Properties kafkaConfigProps = new Properties();
        String kafkaServerUrl = KafkaConfigFactory.getKafkaServerUrlInLog(kafkaConfigInLog);
        String topic = KafkaConfigFactory.getLogTopic(kafkaConfigInLog);
        kafkaConfig.setServerUrl(kafkaServerUrl);
        kafkaConfig.setTopic(topic);
        kafkaConfig.setKafkaProperties(kafkaConfigProps);
        kafkaConfigProps.setProperty("bootstrap.servers", kafkaServerUrl);
        kafkaConfigProps.setProperty("request.timeout.ms", "10000");
        kafkaConfigProps.setProperty("default.api.timeout.ms", "10000");
        String securityProtocol = kafkaConfigInLog.get("securityProtocol");
        if (StringUtils.isEmpty((String)securityProtocol)) {
            return kafkaConfig;
        }
        kafkaConfigProps.setProperty("security.protocol", securityProtocol);
        if (SecurityProtocol.SASL_PLAINTEXT.name.equals(securityProtocol)) {
            KafkaConfigFactory.setSASLConfig(kafkaConfigProps, kafkaConfigInLog);
        } else if (SecurityProtocol.SSL.name.equals(securityProtocol)) {
            KafkaConfigFactory.setSSLConfig(kafkaConfigProps, kafkaConfigInLog);
        } else if (SecurityProtocol.SASL_SSL.name.equals(securityProtocol)) {
            KafkaConfigFactory.setSASLConfig(kafkaConfigProps, kafkaConfigInLog);
            KafkaConfigFactory.setSSLConfig(kafkaConfigProps, kafkaConfigInLog);
        }
        return kafkaConfig;
    }

    private static String getKafkaServerUrlInLog(Map<String, String> kafkaConfigInLog) {
        String brokerList = kafkaConfigInLog.get("brokerList");
        LogHealthUtils.checkConfigValue("brokerList", brokerList);
        return brokerList;
    }

    private static String getLogTopic(Map<String, String> kafkaConfigInLog) {
        String topic = kafkaConfigInLog.get("topic");
        LogHealthUtils.checkConfigValue("topic", topic);
        return topic;
    }

    private static void setSASLConfig(Properties kafkaConfigProps, Map<String, String> kafkaConfigInLog) {
        String saslMechanism = kafkaConfigInLog.get("saslMechanism");
        LogHealthUtils.checkConfigValue("saslMechanism", saslMechanism);
        kafkaConfigProps.setProperty("sasl.mechanism", saslMechanism);
        String jaasConfig = KafkaConfigFactory.getKafkaAuthConfig(kafkaConfigInLog.get("userName"), kafkaConfigInLog.get("password"));
        kafkaConfigProps.setProperty("sasl.jaas.config", jaasConfig);
    }

    private static void setSSLConfig(Properties kafkaConfigProps, Map<String, String> kafkaConfigInLog) {
        String trustStoreLocation = kafkaConfigInLog.get("sslTruststoreLocation");
        LogHealthUtils.checkConfigValue("sslTruststoreLocation", trustStoreLocation);
        String trustStorePassword = kafkaConfigInLog.get("sslTruststorePassword");
        LogHealthUtils.checkConfigValue("sslTruststorePassword", trustStorePassword);
        String keyStoreLocation = kafkaConfigInLog.get("sslKeystoreLocation");
        LogHealthUtils.checkConfigValue("sslKeystoreLocation", keyStoreLocation);
        String keyStorePassword = kafkaConfigInLog.get("sslKeystorePassword");
        LogHealthUtils.checkConfigValue("sslKeystorePassword", keyStorePassword);
        String keyPassword = kafkaConfigInLog.get("sslKeyPassword");
        LogHealthUtils.checkConfigValue("sslKeyPassword", keyPassword);
        kafkaConfigProps.setProperty("ssl.truststore.location", trustStoreLocation);
        kafkaConfigProps.setProperty("ssl.truststore.password", trustStorePassword);
        kafkaConfigProps.setProperty("ssl.keystore.location", keyStoreLocation);
        kafkaConfigProps.setProperty("ssl.keystore.password", keyStorePassword);
        kafkaConfigProps.setProperty("ssl.key.password", keyPassword);
    }

    private static String getKafkaAuthConfig(String userName, String password) {
        LogHealthUtils.checkConfigValue("username", userName);
        LogHealthUtils.checkConfigValue("password", password);
        password = Encrypters.decode((String)password);
        return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + userName + "\" password=\"" + password + "\";";
    }
}

