/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.entity.config;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.eye.api.loghealth.entity.config.ESConfigFactory;
import kd.bos.eye.api.loghealth.entity.config.KafkaConfig;
import kd.bos.eye.api.loghealth.entity.config.KafkaConfigFactory;
import kd.bos.eye.api.loghealth.entity.config.LogConfig;
import kd.bos.eye.api.loghealth.entity.config.LogESConfig;
import kd.bos.eye.api.loghealth.entity.config.LogstashConfig;
import kd.bos.eye.api.loghealth.entity.config.LogstashConfigFactory;
import kd.bos.eye.api.loghealth.exception.IllegalConfigException;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class LogConfigFactory {
    public static LogConfig getLogConfig() {
        return LogConfigFactory.createLogConfig();
    }

    private static LogConfig createLogConfig() {
        String logConfigXml = System.getProperty("log.config");
        try {
            LogHealthUtils.checkConfigValue("log.config", logConfigXml);
            Document document = SAXReaderUtil.parseText((String)logConfigXml);
            Element root = document.getRootElement();
            Element rootConfig = root.element("root");
            String logLevel = rootConfig.attributeValue("level");
            List appenderRefs = rootConfig.elements("appender-ref");
            List<String> appenders = appenderRefs.stream().map(appenderRef -> appenderRef.attribute("ref").getValue()).collect(Collectors.toList());
            List configedAppenders = root.elements("appender");
            HashMap<String, String> kafkaProps = new HashMap<String, String>();
            for (Element configedAppender : configedAppenders) {
                if (!"kafka".equals(configedAppender.attribute("name").getData().toString())) continue;
                List props = configedAppender.elements();
                for (Element prop : props) {
                    kafkaProps.put(prop.getName(), prop.getStringValue());
                }
            }
            KafkaConfig kafkaConfig = KafkaConfigFactory.createKafkaConfig(kafkaProps);
            LogESConfig logESConfig = ESConfigFactory.createESConfig();
            LogstashConfig logstashConfig = LogstashConfigFactory.createLogstashConfig();
            return new LogConfig(kafkaConfig, logESConfig, logstashConfig, logLevel, appenders);
        }
        catch (DocumentException e) {
            throw new IllegalConfigException("log.config", logConfigXml, "log.config\u53c2\u6570\u503c\u4e0d\u662f\u6b63\u786e\u7684XML\u683c\u5f0f");
        }
    }
}

