/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.helper.es;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.elasticsearch.client.ESRestClient;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.factory.ESClientFactory;
import kd.bos.eye.api.loghealth.common.LogHealthConstants;
import kd.bos.eye.api.loghealth.entity.config.LogESConfig;
import kd.bos.eye.api.loghealth.helper.es.ESClusterHealthInfo;
import kd.bos.eye.api.loghealth.helper.es.ESHealthInfo;
import kd.bos.eye.api.loghealth.helper.es.SampleESHealthInfo;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;

public class ESHealthHelper {
    private static final Log logger = LogFactory.getLog(ESHealthHelper.class);
    private final LogESConfig logESConfig;

    public ESHealthHelper(LogESConfig logESConfig) {
        this.logESConfig = logESConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isShutdown() {
        try (ESRestClient client = this.getRestClient(this.logESConfig);){
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("get es client failed. ERROR_INFO: ", (Throwable)e);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ESClusterHealthInfo getESHealthInfo() {
        ESClusterHealthInfo esClusterHealthInfo = new ESClusterHealthInfo();
        esClusterHealthInfo.setUrl(this.logESConfig.getUrl());
        try (ESRestClient client = this.getRestClient(this.logESConfig);){
            JsonNode next;
            String ip;
            Response response = client.execute(new Request("get", "/_cat/allocation?format=json&bytes=kb"));
            String json = LogHealthUtils.asJson(response.getEntity());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(json);
            ArrayList<ESHealthInfo> esHealthInfos = new ArrayList<ESHealthInfo>(jsonNode.size());
            Iterator it = jsonNode.elements();
            while (it.hasNext() && !StringUtils.isEmpty((String)(ip = (next = (JsonNode)it.next()).get("ip").asText())) && !"null".equals(ip)) {
                ESHealthInfo esHealthInfo = new ESHealthInfo();
                esHealthInfo.setIp(ip);
                esHealthInfo.setDiskIndices(next.get("disk.indices").asText());
                esHealthInfo.setDiskAvail(next.get("disk.avail").asText());
                esHealthInfo.setDiskTotal(next.get("disk.total").asText());
                esHealthInfos.add(esHealthInfo);
            }
            esClusterHealthInfo.setEsHealthInfoList(esHealthInfos);
            ESClusterHealthInfo eSClusterHealthInfo = esClusterHealthInfo;
            return eSClusterHealthInfo;
        }
        catch (Exception e) {
            logger.error("get es health info failed. ERROR_INFO: ", (Throwable)e);
            return esClusterHealthInfo;
        }
    }

    public SampleESHealthInfo getSampleESHealthInfo() {
        ESClusterHealthInfo esClusterHealthInfo = this.getESHealthInfo();
        SampleESHealthInfo sampleESHealthInfo = new SampleESHealthInfo();
        sampleESHealthInfo.setSampleTime(LogHealthConstants.DATE_TIME_FOMATTER.format(LocalDateTime.now()));
        long diskIndices = 0L;
        long diskAvail = 0L;
        long diskTotal = 0L;
        for (ESHealthInfo esHealthInfo : esClusterHealthInfo.getEsHealthInfoList()) {
            diskIndices += Long.parseLong(esHealthInfo.getDiskIndices());
            diskAvail += Long.parseLong(esHealthInfo.getDiskAvail());
            diskTotal += Long.parseLong(esHealthInfo.getDiskTotal());
        }
        sampleESHealthInfo.setDiskIndices(diskIndices);
        sampleESHealthInfo.setDiskAvail(diskAvail);
        sampleESHealthInfo.setDiskTotal(diskTotal);
        return sampleESHealthInfo;
    }

    private ESRestClient getRestClient(LogESConfig logESConfig) {
        ESConfig esConfig = this.getESConfig(logESConfig);
        return ESClientFactory.getClient((ESConfig)esConfig);
    }

    private ESConfig getESConfig(LogESConfig logESConfig) {
        String url = logESConfig.getUrl();
        String schema = logESConfig.getSchema();
        String user = logESConfig.getUser();
        String password = logESConfig.getPassword();
        String host = "https".equals(schema) ? url.substring(8).split("/")[0] : url.substring(7).split("/")[0];
        String certPath = logESConfig.getCertPath();
        String certPassword = logESConfig.getCertPassword();
        return new ESConfig(host, user, password, schema, certPath, certPassword);
    }
}

