/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.helper.kafka;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kd.bos.eye.api.loghealth.common.LogHealthConstants;
import kd.bos.eye.api.loghealth.helper.kafka.ConsumerInfo;
import kd.bos.eye.api.loghealth.helper.kafka.PartitionInfo;
import kd.bos.eye.api.loghealth.helper.kafka.SampleTopicConsumptionInfo;
import kd.bos.eye.api.loghealth.helper.kafka.TopicConsumptionInfo;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;

public class KafkaAdminHelper {
    private final Properties props;

    public KafkaAdminHelper(Properties props) {
        this.props = props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isShutdown() {
        try (AdminClient adminClient = KafkaAdminClient.create((Properties)this.props);){
            adminClient.describeCluster().clusterId().get();
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException | ExecutionException e) {
            return true;
        }
    }

    public TopicConsumptionInfo getTopicConsumptionInfo(String topic) {
        TopicConsumptionInfo topicConsumptionInfo = new TopicConsumptionInfo();
        topicConsumptionInfo.setTopic(topic);
        try (AdminClient adminClient = KafkaAdminClient.create((Properties)this.props);){
            Collection consumerGroups = (Collection)adminClient.listConsumerGroups().all().get();
            List allConsumerGroupIds = consumerGroups.stream().map(ConsumerGroupListing::groupId).collect(Collectors.toList());
            Map consumerGroupDescriptionMap = (Map)adminClient.describeConsumerGroups(allConsumerGroupIds).all().get();
            ArrayList<ConsumerInfo> consumerInfos = new ArrayList<ConsumerInfo>();
            for (ConsumerGroupDescription description : consumerGroupDescriptionMap.values()) {
                Collection members = description.members();
                for (MemberDescription member : members) {
                    if (!member.assignment().topicPartitions().stream().anyMatch(topicPartition -> topicPartition.topic().equals(topic))) continue;
                    ConsumerInfo consumerInfo = new ConsumerInfo();
                    consumerInfo.setGroupId(description.groupId());
                    consumerInfo.setHost(member.host());
                    consumerInfo.setClientId(member.clientId());
                    consumerInfos.add(consumerInfo);
                }
            }
            for (ConsumerInfo consumerInfo : consumerInfos) {
                String groupId = consumerInfo.getGroupId();
                Map partitionOffsetMap = (Map)((Map)adminClient.listConsumerGroupOffsets(groupId).all().get()).get(groupId);
                HashMap topicPartitionOffsets = new HashMap(partitionOffsetMap.size());
                HashMap<String, PartitionInfo> partitionInfoMap = new HashMap<String, PartitionInfo>(partitionOffsetMap.size());
                for (Map.Entry entry : partitionOffsetMap.entrySet()) {
                    PartitionInfo partitionInfo = new PartitionInfo();
                    partitionInfo.setPartition(((TopicPartition)entry.getKey()).toString());
                    partitionInfo.setCurrentOffset(((OffsetAndMetadata)entry.getValue()).offset());
                    topicPartitionOffsets.put(entry.getKey(), OffsetSpec.latest());
                    partitionInfoMap.put(partitionInfo.getPartition(), partitionInfo);
                }
                Map listOffsetMap = (Map)adminClient.listOffsets(topicPartitionOffsets).all().get();
                for (Map.Entry entry : listOffsetMap.entrySet()) {
                    ((PartitionInfo)partitionInfoMap.get(((TopicPartition)entry.getKey()).toString())).setEndOffset(((ListOffsetsResult.ListOffsetsResultInfo)entry.getValue()).offset());
                }
                consumerInfo.setPartitionInfos(new ArrayList<PartitionInfo>(partitionInfoMap.values()));
            }
            topicConsumptionInfo.setConsumerInfos(consumerInfos);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return topicConsumptionInfo;
    }

    public SampleTopicConsumptionInfo getSampleTopicConsumptionInfo(String topic) {
        TopicConsumptionInfo sample = this.getTopicConsumptionInfo(topic);
        return this.translateConsumptionInfo(sample);
    }

    private SampleTopicConsumptionInfo translateConsumptionInfo(TopicConsumptionInfo info) {
        long currentOffset = 0L;
        long endOffset = 0L;
        for (ConsumerInfo consumerInfo : info.getConsumerInfos()) {
            for (PartitionInfo partitionInfo : consumerInfo.getPartitionInfos()) {
                currentOffset += partitionInfo.getCurrentOffset();
                endOffset += partitionInfo.getEndOffset();
            }
        }
        long lag = endOffset - currentOffset;
        return new SampleTopicConsumptionInfo(LogHealthConstants.DATE_TIME_FOMATTER.format(LocalDateTime.now()), currentOffset, endOffset, lag);
    }

    public Map<String, String> getMetricsInfo() {
        HashMap<String, String> metricsMap = new HashMap<String, String>();
        try (AdminClient adminClient = KafkaAdminClient.create((Properties)this.props);){
            Map metrics = adminClient.metrics();
            for (Map.Entry metricEntry : metrics.entrySet()) {
                MetricName metricName = (MetricName)metricEntry.getKey();
                Metric metric = (Metric)metricEntry.getValue();
                metricsMap.put(metricName.name(), metric.metricValue().toString());
            }
        }
        return metricsMap;
    }
}

