/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kd.bos.eye.api.loghealth.exception.IllegalConfigException;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.util.EntityUtils;

public class LogHealthUtils {
    public static void checkConfigValue(String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalConfigException(name, value);
        }
    }

    public static void waitForSomething(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String asJson(HttpEntity resEntity) throws IOException {
        Header respHeader = resEntity.getContentEncoding();
        if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
            StringBuilder sb = new StringBuilder();
            try (InputStream in = gzipEntity.getContent();
                 InputStreamReader its = new InputStreamReader(in);
                 BufferedReader br = new BufferedReader(its);){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            return sb.toString();
        }
        return EntityUtils.toString((HttpEntity)resEntity);
    }
}

