/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.login;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Random;
import javax.imageio.ImageIO;

public class MonitorVerifyCode {
    private int w = 140;
    private int h = 45;
    private String[] fontNames = new String[]{"Monospaced"};
    private Random r = new SecureRandom();
    private String codes = "23456789abcdefghjkmnpqrstuvwxyzABCEFGHIJKLMNPQRSTUVWXYZ";
    private Color bgColor = new Color(255, 255, 255);
    private String text;

    private Color randomColor() {
        int red = this.r.nextInt(200);
        int green = this.r.nextInt(200);
        int blue = this.r.nextInt(200);
        return new Color(red, green, blue);
    }

    private void drawLine(BufferedImage image) {
        int num = 6;
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        for (int i = 0; i < num; ++i) {
            int x1 = this.r.nextInt(this.w);
            int y1 = this.r.nextInt(this.h);
            int x2 = this.r.nextInt(this.w);
            int y2 = this.r.nextInt(this.h);
            g2.setStroke(new BasicStroke(1.5f));
            g2.setColor(Color.BLUE);
            g2.drawLine(x1, y1, x2, y2);
        }
        g2.dispose();
    }

    private char randomChar() {
        int index = this.r.nextInt(this.codes.length());
        return this.codes.charAt(index);
    }

    private Font randomFont() {
        int index = this.r.nextInt(this.fontNames.length);
        String fontName = this.fontNames[index];
        int style = this.r.nextInt(4);
        int size = this.r.nextInt(6) + 25;
        return new Font(fontName, style, size);
    }

    private BufferedImage createImage() {
        BufferedImage image = new BufferedImage(this.w, this.h, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.w, this.h);
        g2.dispose();
        return image;
    }

    public BufferedImage getImage() {
        BufferedImage image = this.createImage();
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String s = this.randomChar() + "";
            sb.append(s);
            float x = (float)i * 1.0f * (float)this.w / 4.0f;
            g2.setColor(this.randomColor());
            g2.setFont(this.randomFont());
            g2.drawString(s, x, (float)(this.h - 5));
        }
        this.text = sb.toString();
        String complexity = System.getProperty("monitor.verifyCode.complexity", "hard");
        if ("hard".equalsIgnoreCase(complexity)) {
            this.drawLine(image);
        }
        g2.dispose();
        return image;
    }

    public String getText() {
        return this.text;
    }

    public static void output(BufferedImage image, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)image, "JPEG", out);
    }
}

