/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.login;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class PublicKeyHandler
implements HttpHandler {
    public static final PublicKeyHandler instance = new PublicKeyHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            ThreadTruck.put((Object)"monitor-requestContext-login", (Object)true);
            Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
            HashMap<String, String> data = new HashMap<String, String>(1);
            String userName = params.get("userName");
            if (StringUtils.isEmpty((String)userName)) {
                throw new IllegalArgumentException("userName is null");
            }
            data.put("publicKey", MonitorLoginUtils.getBase64PublicKeyByUserName(userName));
            response.setCode(0);
            response.setMsg("success");
            response.setData(data);
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg("get public key is failed, message: " + e.getMessage());
        }
        finally {
            ThreadTruck.current().close();
        }
        String responseString = JSONUtils.toString(response);
        this.writeJson(responseString, exchange);
    }

    private void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }
}

