/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.oplog;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.eye.api.oplog.OpLogConfig;
import kd.bos.eye.api.oplog.OpLogEntity;
import kd.bos.eye.api.oplog.service.OpLogQueryParam;
import kd.bos.eye.api.oplog.service.OpLogResponse;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class OpLogDbHelper {
    private static final Log logger = LogFactory.getLog(OpLogDbHelper.class);
    private static final String INSERT_SQL = "INSERT INTO T_MONITOR_OPLOG(FID,FUSERNAME,FOPTIME,FCLIENTIP,FOPTYPE,FOPOBJ,FDESCRIPTION) values(?,?,?,?,?,?,?)";
    private static final String DELETE_SQL = "DELETE FROM T_MONITOR_OPLOG WHERE FOPTIME < ?";
    private static final String QUERY_SQL = "SELECT FID,FUSERNAME,FOPTIME,FCLIENTIP,FOPTYPE,FOPOBJ,FDESCRIPTION FROM T_MONITOR_OPLOG WHERE (1=1)";

    public static void saveOpLog(OpLogEntity opLogEntity) {
        try {
            ArrayList<Object> opLogParamList = new ArrayList<Object>(7);
            opLogParamList.add(opLogEntity.getId());
            opLogParamList.add(opLogEntity.getUserName());
            opLogParamList.add(Timestamp.valueOf(opLogEntity.getOpTime()));
            opLogParamList.add(opLogEntity.getClientIp());
            opLogParamList.add(opLogEntity.getOpType());
            opLogParamList.add(opLogEntity.getOpObject());
            opLogParamList.add(opLogEntity.getDescription());
            DBRequest dbRequest = new DBRequest();
            dbRequest.setInsertRequest(new DBRequest.InsertRequest(INSERT_SQL, opLogParamList));
            MetadataFactory.getStatement().executeInsert((Request)dbRequest);
        }
        catch (Exception e) {
            logger.error("Saving monitor's operation logs to DB is error. ", (Throwable)e);
        }
    }

    public static void saveOpLogs(List<OpLogEntity> opLogEntitys) {
        try {
            ArrayList<DBRequest> requests = new ArrayList<DBRequest>(opLogEntitys.size());
            for (OpLogEntity opLogEntity : opLogEntitys) {
                ArrayList<Object> opLogParamList = new ArrayList<Object>(7);
                opLogParamList.add(opLogEntity.getId());
                opLogParamList.add(opLogEntity.getUserName());
                opLogParamList.add(Timestamp.valueOf(opLogEntity.getOpTime()));
                opLogParamList.add(opLogEntity.getClientIp());
                opLogParamList.add(opLogEntity.getOpType());
                opLogParamList.add(opLogEntity.getOpObject());
                opLogParamList.add(opLogEntity.getDescription());
                DBRequest dbRequest = new DBRequest();
                dbRequest.setInsertRequest(new DBRequest.InsertRequest(INSERT_SQL, opLogParamList));
                requests.add(dbRequest);
            }
            MetadataFactory.getStatement().executeInsertBatch(requests);
        }
        catch (Exception e) {
            logger.error("Saving monitor's operation logs to DB is error. ", (Throwable)e);
        }
    }

    public static void deleteExpiredOpLog() {
        try {
            LocalDateTime now = LocalDateTime.now();
            String days = ConfigDbHelper.getValueByKey("monitor.oplog.save.days", "30");
            Timestamp time = Timestamp.valueOf(now.minusDays(Integer.parseInt(days)));
            ArrayList<Timestamp> userParamList = new ArrayList<Timestamp>(1);
            userParamList.add(time);
            DBRequest dbRequest = new DBRequest();
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(DELETE_SQL, userParamList));
            MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
        }
        catch (Exception e) {
            logger.error("Timed deleting monitor's operation logs from DB is error. ", (Throwable)e);
        }
    }

    public static List<OpLogResponse> queryOpLogsByParam(OpLogQueryParam opLogQueryParam) {
        if (opLogQueryParam == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String querySql = OpLogDbHelper.completeQuerySql(opLogQueryParam, values);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, values));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<OpLogResponse> opLogEntities = new ArrayList<OpLogResponse>(results.size());
        for (Result result : results) {
            OpLogResponse opLogResponse = new OpLogResponse();
            opLogResponse.setId(result.getString("fid"));
            opLogResponse.setUserName(result.getString("fusername"));
            opLogResponse.setClientIp(result.getString("fclientip"));
            opLogResponse.setOpType(result.getString("foptype"));
            opLogResponse.setOpObject(result.getString("fopobj"));
            opLogResponse.setDescription(result.getString("fdescription"));
            try {
                DateTimeFormatter originalFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]");
                LocalDateTime dateTime = LocalDateTime.parse(result.getString("foptime"), originalFormat);
                DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                opLogResponse.setOpTime(dateTime.format(timeFormat));
            }
            catch (Exception e) {
                opLogResponse.setOpTime(result.getString("foptime"));
            }
            opLogEntities.add(opLogResponse);
        }
        return opLogEntities;
    }

    private static String completeQuerySql(OpLogQueryParam opLogQueryParam, List<Object> values) {
        StringBuilder completeSql = new StringBuilder(QUERY_SQL);
        if (StringUtils.isNotEmpty((String)opLogQueryParam.getUserName())) {
            values.add(opLogQueryParam.getUserName());
            completeSql.append(" AND FUSERNAME = ?");
        }
        if (StringUtils.isNotEmpty((String)opLogQueryParam.getClientIp())) {
            values.add(opLogQueryParam.getClientIp());
            completeSql.append(" AND FCLIENTIP = ?");
        }
        if (StringUtils.isNotEmpty((String)opLogQueryParam.getOpType())) {
            values.add(opLogQueryParam.getOpType());
            completeSql.append(" AND FOPTYPE = ?");
        }
        if (StringUtils.isNotEmpty((String)opLogQueryParam.getOpObject())) {
            values.add("%" + opLogQueryParam.getOpObject() + "%");
            completeSql.append(" AND FOPOBJ like ?");
        }
        if (StringUtils.isNotEmpty((String)opLogQueryParam.getDescription())) {
            values.add("%" + opLogQueryParam.getDescription() + "%");
            completeSql.append(" AND FDESCRIPTION like ?");
        }
        if (opLogQueryParam.getOpTimeRange() != null && opLogQueryParam.getOpTimeRange().length > 0) {
            if (StringUtils.isNotEmpty((String)opLogQueryParam.getOpTimeRange()[0])) {
                values.add(Timestamp.valueOf(LocalDateTime.parse(opLogQueryParam.getOpTimeRange()[0], OpLogConfig.FRONT_FORMATTER)));
                completeSql.append(" AND FOPTIME > ?");
            }
            if (StringUtils.isNotEmpty((String)opLogQueryParam.getOpTimeRange()[1])) {
                values.add(Timestamp.valueOf(LocalDateTime.parse(opLogQueryParam.getOpTimeRange()[1], OpLogConfig.FRONT_FORMATTER)));
                completeSql.append(" AND FOPTIME < ?");
            }
        } else {
            values.add(Timestamp.valueOf(LocalDateTime.now().minusDays(1L)));
            completeSql.append(" AND FOPTIME > ?");
            values.add(Timestamp.valueOf(LocalDateTime.now()));
            completeSql.append(" AND FOPTIME < ?");
        }
        completeSql.append(" ORDER BY FOPTIME DESC");
        return completeSql.toString();
    }
}

