/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.permission;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.api.permission.dao.UserDao;
import kd.bos.eye.api.permission.entity.User;
import kd.bos.eye.api.permission.entity.UserRequest;
import kd.bos.eye.api.sso.SsoClients;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.RequestTypeEnum;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class UserHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final Log log = LogFactory.getLog(UserHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        String token = UserHandler.getToken(exchange);
        Map<String, String> userInfo = SessionStore.get().get(token);
        ApiResponse response = new ApiResponse();
        UserDao userDao = new UserDao();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (userInfo.get("logintype").equals(SsoClients.COSMICEYE.getName())) {
            map.put("isConfiged", "false");
            map.put("isNewUser", "false");
            map.put("isFirstLogin", userInfo.get("isFirstLogin"));
            map.put("isExpirePassword", "false");
            User user2 = new User();
            user2.setUserName("admin");
            map.put("userInfo", user2);
            response.setCode(0);
            response.setData(map);
            this.writeJson(JSONUtils.toString(response), exchange);
            return;
        }
        if (!DBHelper.dbIsConfigured()) {
            map.put("isConfiged", "false");
            response.setCode(0);
            response.setData(map);
            this.writeJson(JSONUtils.toString(response), exchange);
            return;
        }
        try {
            UserRequest userRequest = ExchangeVueUtils.parseJsonFromPost(exchange, UserRequest.class);
            if (userRequest == null) {
                return;
            }
            String requestType = userRequest.getRequestType();
            String initUser = System.getProperty("monitor.user");
            if (!EyeAuther.checkPermission(exchange, "user:" + userRequest.getUserName(), requestType)) {
                throw new KDException("No permission!");
            }
            if (RequestTypeEnum.USER_LIST_IS_DUPLICATE.getRequestType().equals(requestType)) {
                map.put("isDuplicateUser", userDao.isDuplicateUser(userRequest));
            } else if (RequestTypeEnum.USER_LIST_INFO.getRequestType().equals(requestType)) {
                String userName = userInfo.get("user");
                if (this.checkDebugModeEdit(userName)) {
                    map.put("isNewUser", "false");
                    map.put("isDebugMode", "true");
                    User user3 = new User();
                    user3.setUserName(userName);
                    map.put("userInfo", user3);
                    response.setCode(0);
                    response.setData(map);
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                User user4 = userDao.getUserByName(userName);
                String isNewUser = user4.getUserPassword().endsWith("_NEW") ? "true" : "false";
                map.put("isNewUser", isNewUser);
                user4.setUserPassword(null);
                map.put("userInfo", user4);
                map.put("isFirstLogin", userInfo.get("isFirstLogin"));
                map.put("isExpirePassword", userInfo.get("isExpired"));
                map.put("isConfiged", "true");
            } else {
                String password;
                String userName;
                if (RequestTypeEnum.USER_LIST_ADD.getRequestType().equals(requestType)) {
                    userName = userRequest.getUserName();
                    if (userName.length() < 6 || userName.length() > 32) {
                        throw new KDException("The length of username is limited 6-32!");
                    }
                    userRequest.setUserPassword(MonitorLoginUtils.getDecryptPassword(userRequest.getUserName(), userRequest.getUserPassword()));
                    userDao.addUser(userRequest);
                }
                if (RequestTypeEnum.USER_LIST_EDIT.getRequestType().equals(requestType)) {
                    userName = userRequest.getUserName();
                    if (StringUtils.isEmpty((String)userRequest.getUserPassword())) {
                        userDao.editUser(userRequest);
                    } else {
                        password = MonitorLoginUtils.getDecryptPassword(userName, userRequest.getUserPassword());
                        String oldPassword = MonitorLoginUtils.getDecryptPassword(userName, userRequest.getUserOldPassword());
                        String mp = System.getProperty("monitor.password");
                        mp = Encrypters.decode((String)mp);
                        boolean oldPasswordIsTrue = this.checkPassword(userInfo, userName, oldPassword);
                        boolean isUsedPassword = this.checkPassword(userInfo, userName, password);
                        boolean isDisableChangePassword = this.isDisableChangePassword(userName);
                        if (!isUsedPassword && oldPasswordIsTrue && !isDisableChangePassword) {
                            userRequest.setUserPassword(password);
                            if ("true".equals(userInfo.get("isExpired"))) {
                                LocalDate now = LocalDate.now();
                                LocalDate expireDate = now.plusDays(180L);
                                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                                userRequest.setExpireDate(formatter.format(expireDate));
                            }
                            userDao.editUserPassword(userRequest);
                        }
                        map.put("isUsedPassword", isUsedPassword);
                        map.put("oldPasswordIsTrue", oldPasswordIsTrue);
                        map.put("isDisableChangePassword", isDisableChangePassword);
                    }
                }
                if (RequestTypeEnum.USER_LIST_DELETE.getRequestType().equals(requestType)) {
                    String currentUser = userInfo.get("user");
                    if (userRequest.getUserName().equals(initUser) || userRequest.getUserName().equals(currentUser)) {
                        map.put("cantDel", "true");
                        map.put("currentUser", currentUser);
                    } else {
                        userDao.deleteUser(userRequest);
                    }
                }
                if (RequestTypeEnum.USER_LIST_EDIT_PASSWORD.getRequestType().equals(requestType)) {
                    userName = userRequest.getUserName();
                    boolean isUsedPassword = this.checkPassword(userInfo, userName, password = MonitorLoginUtils.getDecryptPassword(userName, userRequest.getUserPassword()));
                    if (!isUsedPassword) {
                        userRequest.setUserPassword(password);
                        userDao.editUserPassword(userRequest);
                    }
                    map.put("isUsedPassword", isUsedPassword);
                }
                List<User> userList = userDao.getUserList();
                List<String> roleList = userDao.getRoleList();
                if ("true".equals(userInfo.get("isFirstLogin"))) {
                    userList = userList.stream().filter(user -> user.getUserName().equals(userInfo.get("user"))).collect(Collectors.toList());
                }
                if (!initUser.equals(userInfo.get("user"))) {
                    userList = userList.stream().filter(user -> !user.getUserName().equals(initUser)).collect(Collectors.toList());
                }
                map.put("isFirstLogin", userInfo.get("isFirstLogin"));
                map.put("isExpirePassword", userInfo.get("isExpired"));
                map.put("userList", userList);
                map.put("roleList", roleList);
                map.put("isConfiged", "true");
            }
            map.put("ignoreUserPd", this.ignoreUserPd());
            response.setCode(0);
            response.setData(map);
            this.addOpLog(exchange, requestType, userRequest);
        }
        catch (Exception e) {
            log.error("query user error: ", (Throwable)e);
            response.setCode(-1);
            response.setMsg("user exception, message: " + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private boolean checkDebugModeEdit(String userName) {
        String initUser = System.getProperty("monitor.user");
        String mode = System.getProperty("monitor.dev.model");
        return initUser.equals(userName) && "debug".equals(mode);
    }

    private boolean isDisableChangePassword(String userName) {
        String key;
        DistributeSessionableCache cache = SessionStore.get().getCache();
        String oldTimes = (String)cache.get(key = "monitor-change-password-" + userName, (Object)userName);
        if (StringUtils.isEmpty((String)oldTimes)) {
            cache.put(key, (Object)userName, (Object)"1");
            return false;
        }
        int config = Integer.getInteger("monitor.login.errorTimes", 8);
        int parseInt = Integer.parseInt(oldTimes);
        if (parseInt >= config) {
            return true;
        }
        if (parseInt == config - 1) {
            int effectiveTimes = 86400;
            cache.put(key, (Object)userName, (Object)String.valueOf(config));
            cache.expireAfter(key, effectiveTimes);
        } else {
            cache.put(key, (Object)userName, (Object)String.valueOf(parseInt + 1));
        }
        return false;
    }

    private boolean checkPassword(Map<String, String> userInfo, String userName, String password) {
        String initUser = System.getProperty("monitor.user");
        String mp = System.getProperty("monitor.password");
        if ("true".equals(userInfo.get("isFirstLogin")) && userName.equals(initUser)) {
            mp = Encrypters.decode((String)mp);
            return password.equals(mp);
        }
        return EyeAuther.checkUser(userName, password);
    }

    private void addOpLog(HttpExchange exchange, String requestType, UserRequest userRequest) {
        if ("0".equals(requestType)) {
            OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"UserHandler_1", (String)"\u7528\u6237\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"UserHandler_2", (String)"\u65b0\u589e{0}\u7528\u6237", (Object[])new Object[]{userRequest.getUserName()}));
        }
        if ("1".equals(requestType)) {
            // empty if block
        }
        if ("2".equals(requestType)) {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"UserHandler_1", (String)"\u7528\u6237\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"UserHandler_4", (String)"\u4fee\u6539{0}\u7528\u6237\u914d\u7f6e: \u89d2\u8272={1} \u63cf\u8ff0={2} \u5bc6\u7801\u5230\u671f\u65f6\u95f4={3}", (Object[])new Object[]{userRequest.getUserName(), userRequest.getUserRole(), userRequest.getUserDescription(), userRequest.getExpireDate()}));
        }
        if ("3".equals(requestType)) {
            OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"UserHandler_1", (String)"\u7528\u6237\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"UserHandler_5", (String)"\u5220\u9664{0}\u7528\u6237", (Object[])new Object[]{userRequest.getUserName()}));
        }
        if ("6".equals(requestType)) {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"UserHandler_1", (String)"\u7528\u6237\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"UserHandler_6", (String)"\u4fee\u6539{0}\u7528\u6237\u5bc6\u7801", (Object[])new Object[]{userRequest.getUserName()}));
        }
    }

    private boolean ignoreUserPd() {
        boolean ignoreUserPd = Boolean.parseBoolean(System.getProperty("monitor.login.ignoreUserPd.enable", "false"));
        return ignoreUserPd;
    }
}

