/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.prometheus;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import kd.bos.eye.api.prometheus.BizMetricsService;
import kd.bos.eye.api.thread.entity.NodeInfo;
import kd.bos.eye.util.ClusterUtils;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class BizClusterMetricsHandler
implements HttpHandler {
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final int CONNECTION_TIMEOUT = 1000;
    private static final int READ_TIMEOUT = 1000;
    private static final Log logger = LogFactory.getLog(BizClusterMetricsHandler.class);

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Object authorization = httpExchange.getRequestHeaders().get("Authorization");
        try {
            if (BizMetricsService.auth((List<String>)authorization)) {
                this.writeData(httpExchange);
            } else {
                this.writeData(httpExchange, "Access denied: auth failed.");
            }
        }
        catch (IllegalArgumentException e) {
            this.writeData(httpExchange, "Access denied: auth failed." + e.getMessage());
        }
        catch (Exception e) {
            this.writeData(httpExchange, "An error occurred: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(HttpExchange exchange, String response) throws IOException {
        try {
            byte[] bytes = response.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(200, bytes.length);
            exchange.getResponseBody().write(bytes);
        }
        finally {
            exchange.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(HttpExchange exchange) {
        boolean useGzip;
        String authorization = (String)exchange.getRequestHeaders().get("Authorization").get(0);
        boolean bl = useGzip = BizMetricsService.isAcceptGzip(exchange) && !Boolean.getBoolean("monitor.biz.compression.disable");
        if (useGzip) {
            exchange.getResponseHeaders().set("Content-Encoding", "gzip");
            exchange.getResponseHeaders().set("Vary", "Accept-Encoding");
            exchange.getResponseHeaders().set("Transfer-Encoding", "chunked");
        }
        exchange.getResponseHeaders().set("Content-Type", "text/plain; version=0.0.4; charset=utf-8; escaping=underscores");
        try (InputStream in = this.collectAllNodesMetrics(authorization);
             OutputStream out = useGzip ? new GZIPOutputStream(exchange.getResponseBody()) : exchange.getResponseBody();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            logger.warn("An error occurred when write response", (Throwable)e);
        }
        finally {
            exchange.close();
        }
    }

    private InputStream collectAllNodesMetrics(String auth) throws IOException {
        List sortedNodeInfos = ClusterUtils.getSortedNodeInfos().stream().filter(nodeInfo -> !nodeInfo.getInstanceId().equals(Instance.getInstanceId())).collect(Collectors.toList());
        String path = FileUtils.checkFileUrl((String)(TEMP_DIR + "/BIZMETRICS" + UUID.randomUUID().toString().replace("-", "")));
        FileTimeoutUtil.removeFile((String)path, null, (long)120000L);
        BizMetricsService.getMetrics(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]));
        for (NodeInfo nodeInfo2 : sortedNodeInfos) {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", auth);
            header.put("Accept-Encoding", "gzip");
            String url = "http://" + nodeInfo2.getHostIp() + ":" + nodeInfo2.getHostMonitorPort() + "/monitor/eye/biz/prometheusmetrics";
            try {
                CloseableHttpClient client = this.getHttpClient();
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(path, true);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)this.getMetricsByHttp(client, url, header), (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            catch (IOException e) {
                logger.error("collect biz prometheus metrics on " + nodeInfo2.getHostIp() + " failed.", (Throwable)e);
            }
        }
        return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
    }

    private InputStream getMetricsByHttp(CloseableHttpClient client, String url, Map<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpGet.setHeader(entry.getKey(), entry.getValue());
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
        return response.getEntity().getContent();
    }

    private CloseableHttpClient getHttpClient() {
        return HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(1000).setConnectTimeout(1000).setSocketTimeout(1000).build()).build();
    }
}

