/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.prometheus;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import kd.bos.eye.api.prometheus.BizMetricsService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BizMetricsHandler
implements HttpHandler {
    private static final Log logger = LogFactory.getLog(BizMetricsHandler.class);

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Object authorization = httpExchange.getRequestHeaders().get("Authorization");
        try {
            if (BizMetricsService.auth((List<String>)authorization)) {
                this.writeDataInner(httpExchange);
            } else {
                this.writeDataInner(httpExchange, "Access denied: auth failed.");
            }
        }
        catch (IllegalArgumentException e) {
            this.writeDataInner(httpExchange, "Access denied: auth failed." + e.getMessage());
        }
        catch (Exception e) {
            this.writeDataInner(httpExchange, "An error occurred: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataInner(HttpExchange exchange, String response) throws IOException {
        try {
            byte[] bytes = response.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(200, bytes.length);
            exchange.getResponseBody().write(bytes);
        }
        finally {
            exchange.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataInner(HttpExchange exchange) throws IOException {
        boolean useGzip;
        boolean bl = useGzip = BizMetricsService.isAcceptGzip(exchange) && !Boolean.getBoolean("monitor.biz.compression.disable");
        if (useGzip) {
            exchange.getResponseHeaders().set("Content-Encoding", "gzip");
            exchange.getResponseHeaders().set("Vary", "Accept-Encoding");
        }
        exchange.getResponseHeaders().set("Content-Type", "text/plain; version=0.0.4; charset=utf-8; escaping=underscores");
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStream out = useGzip ? new GZIPOutputStream(exchange.getResponseBody()) : exchange.getResponseBody();
             OutputStreamWriter writer = new OutputStreamWriter(out);){
            TextFormat.write004(writer, CollectorRegistry.defaultRegistry.metricFamilySamples());
        }
        catch (Exception e) {
            logger.warn("An error occurred when write response", (Throwable)e);
        }
        finally {
            exchange.close();
        }
    }
}

