/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.prometheus;

import com.sun.net.httpserver.HttpExchange;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Base64;
import java.util.List;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BizMetricsService {
    private static final Log logger = LogFactory.getLog(BizMetricsService.class);

    static void getMetrics(OutputStream outputStream) {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            TextFormat.write004(writer, CollectorRegistry.defaultRegistry.metricFamilySamples());
        }
        catch (IOException e) {
            logger.error("get biz prometheus metrics on local node failed", (Throwable)e);
        }
    }

    public static boolean isAcceptGzip(HttpExchange exchange) {
        String acceptEncoding = exchange.getRequestHeaders().getFirst("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    public static boolean auth(List<String> authorization) {
        if (authorization == null) {
            throw new IllegalArgumentException("authorization information can not be null.");
        }
        String auth = authorization.get(0);
        if (auth.startsWith("Bearer ")) {
            if ((auth = auth.substring(7)).startsWith("123456")) {
                auth = auth.substring(6);
            }
        } else if (auth.startsWith("Basic ")) {
            if ((auth = auth.substring(6)).startsWith("123456")) {
                auth = auth.substring(6);
            }
        } else {
            auth = auth.substring(6);
        }
        String userPass = new String(Base64.getDecoder().decode(auth));
        int indexOf = userPass.indexOf(":");
        String account = userPass.substring(0, indexOf);
        String secret = userPass.substring(indexOf + 1);
        return HealthCheckConfig.checkAuth(account, Encrypters.decode((String)secret));
    }
}

