/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.redis;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.api.redis.RedisRequest;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.redis.RedisProtocols;
import kd.bos.redis.analysis.AnalysisResult;
import kd.bos.redis.xcache.XCacheClient;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import redis.clients.jedis.util.Slowlog;

public class RedisMrgHandler
extends AbstractHttpHandler
implements Serializable {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final Log LOG = LogFactory.getLog(RedisMrgHandler.class);
    private static String DEFAULT_HIGHLIGHT_KEYS = "connected_clients,used_memory_human,rejected_connections,allocator_used_memory_human,allocator_out_of_memory,timer_eviction_cache";
    private static final String[] HIGH_LIGHT_KEYS = System.getProperty("monitor.redis.highlightkeys", DEFAULT_HIGHLIGHT_KEYS).split(",");
    private SlowLogComparator comparator = new SlowLogComparator();

    private Set<String> getRedisUrls() {
        HashSet<String> Urls = new HashSet<String>();
        try {
            Class<?> redisfactorycl = Class.forName("kd.bos.redis.RedisFactory");
            Field filed = redisfactorycl.getDeclaredField("poolMap");
            filed.setAccessible(true);
            Map poolmap = (Map)filed.get(redisfactorycl);
            poolmap.forEach((k, v) -> {
                if (!RedisProtocols.isXCache((String)k)) {
                    Urls.add((String)k);
                }
            });
        }
        catch (Exception e) {
            return Urls;
        }
        return Urls;
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        RedisRequest params;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            params = (RedisRequest)ExchangeVueUtils.parsePostJson(exchange, RedisRequest.class);
        }
        catch (Exception e) {
            return;
        }
        Set<String> redisEndpoints = this.getRedisUrls();
        ArrayList nodeData = new ArrayList(10);
        HashMap redisInfo = new HashMap(1);
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        if (!redisEndpoints.isEmpty()) {
            for (String url : redisEndpoints) {
                HashMap<String, Object> dataMap;
                int index = url.indexOf(47);
                String substring = url;
                if (index != -1) {
                    substring = url.substring(0, index);
                }
                HashMap<String, String> nodeTemp = new HashMap<String, String>(2);
                nodeTemp.put("label", substring);
                nodeTemp.put("value", substring);
                nodeData.add(nodeTemp);
                try (JedisClient client = RedisFactory.getJedisClient((String)url);){
                    dataMap = new HashMap<String, Object>(4);
                    dataMap.put("canAnalysisBigKeys", RedisProtocols.isXCache((String)url));
                    dataMap.put("runtimeList", this.getRuntimeList(client));
                    dataMap.put("slowList", this.getSlowList(client, dateFormat));
                    String node = params.getNode();
                    String kv = params.getKv();
                    this.exeCommand(node, url, kv, client, response);
                    RedisMrgHandler.tryToAnalysisBigKeys(url, node, params, client, response);
                }
                redisInfo.put(substring, dataMap);
            }
        }
        response.put("clusterName", Instance.getClusterName() == null ? " " : Instance.getClusterName());
        response.put("code", 0);
        response.put("data", redisInfo);
        response.put("nodeData", nodeData);
        response.put("keys", HIGH_LIGHT_KEYS);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
        if (StringUtils.isNotEmpty((String)params.getKv())) {
            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"RedisMrgHandler_3", (String)"Redis\u76d1\u63a7", (Object[])new Object[0]), LangRes.get((String)"RedisMrgHandler_5", (String)"\u67e5\u8be2\u4e86 {0} \u8282\u70b9\u4e2d\uff0cKEY\u4e3a {1} \u7684\u7f13\u5b58\u503c", (Object[])new Object[]{params.getNode(), params.getKv()}));
        }
    }

    private static void tryToAnalysisBigKeys(String url, String node, RedisRequest params, JedisClient client, Map<String, Object> response) {
        if (params.getBigKeyCount() > 0 && params.getBigKeySize() > 0 && url.contains(node) && RedisProtocols.isXCache((String)url)) {
            XCacheClient xcacheClient = XCacheClient.newClient((JedisClient)client);
            AnalysisResult result = xcacheClient.analysis(params.getBigKeySize(), params.getBigKeyCount());
            response.put("bigKeyAnalysisResult", result);
        }
    }

    private List<Map<String, String>> getRuntimeList(JedisClient client) {
        ArrayList<Map<String, String>> runtimeList = new ArrayList<Map<String, String>>();
        List infos = null;
        try {
            infos = client.getRedisInfo();
        }
        catch (Exception e) {
            LOG.error("redis getRuntimeList error", (Throwable)e);
        }
        if (infos != null) {
            for (Map info : infos) {
                Set set = info.entrySet();
                for (Map.Entry entry : set) {
                    HashMap<String, String> runtimeMap = new HashMap<String, String>(8);
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    runtimeMap.put("key", key);
                    runtimeMap.put("value", value);
                    runtimeList.add(runtimeMap);
                }
            }
        }
        return runtimeList;
    }

    private List<Map<String, Object>> getSlowList(JedisClient client, SimpleDateFormat dateFormat) {
        ArrayList<Map<String, Object>> slowList = new ArrayList<Map<String, Object>>();
        List logs = null;
        try {
            logs = client.getLogs(20L);
        }
        catch (Exception e) {
            LOG.error("redis getSlowList error", (Throwable)e);
        }
        if (logs != null) {
            Collections.sort(logs, this.comparator);
            for (Slowlog log : logs) {
                HashMap<String, Object> slowMap = new HashMap<String, Object>(3);
                slowMap.put("time", dateFormat.format(new Date(log.getTimeStamp() * 1000L)));
                slowMap.put("log", log.getArgs());
                slowMap.put("costTime", log.getExecutionTime() / 1000L);
                slowList.add(slowMap);
            }
        }
        return slowList;
    }

    private void exeCommand(String node, String url, String kv, JedisClient client, Map<String, Object> response) {
        kv = kv.trim();
        if (url.contains(node) && kv.length() > 0) {
            String type;
            switch (type = client.type(kv)) {
                case "string": {
                    response.put("commandData", client.get(kv));
                    break;
                }
                case "hash": {
                    Map hgetAll = client.hgetAll(kv);
                    response.put("commandData", hgetAll.toString());
                    break;
                }
            }
        }
    }

    private static class SlowLogComparator
    implements Comparator<Slowlog> {
        private SlowLogComparator() {
        }

        @Override
        public int compare(Slowlog o1, Slowlog o2) {
            if (o1.getExecutionTime() > o2.getExecutionTime()) {
                return -1;
            }
            if (o1.getExecutionTime() == o2.getExecutionTime()) {
                return 0;
            }
            return 1;
        }
    }
}

