/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.sso;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.eye.api.oplog.OpLogEntity;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogUtil;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.api.sso.SsoRequeset;
import kd.bos.eye.api.sso.WhitelistVerify;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SsoLoginApiHandler
implements HttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    public static final SsoLoginApiHandler instance = new SsoLoginApiHandler();

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        String token = null;
        try {
            SsoRequeset request = (SsoRequeset)ExchangeVueUtils.parsePostJson(exchange, SsoRequeset.class);
            Map auth = request.getAuth();
            String userName = (String)auth.get("username");
            String passwd = (String)auth.get("password");
            if (auth == null || StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)passwd)) {
                throw new IllegalArgumentException("auth message is null, access denied");
            }
            if (HealthCheckConfig.checkAuth(userName, Encrypters.decode((String)passwd))) {
                String client = request.getClient();
                if (!WhitelistVerify.isClientEnable(client)) {
                    response.setCode(1);
                    response.setData(null);
                    response.setMsg(LangRes.get((String)"SsoLoginHandler_0", (String)"Third-party login is not enabled", (Object[])new Object[0]));
                } else {
                    String clientRemoteIp = OpLogUtil.getRemoteHost(exchange);
                    if (!WhitelistVerify.isClientWhite(client, clientRemoteIp)) {
                        response.setCode(1);
                        response.setData(null);
                        response.setMsg(LangRes.get((String)"SsoLoginHandler_1", (String)"Third-party login is restricted by whitelist, request IP: {0}", (Object[])new Object[]{clientRemoteIp}));
                    } else {
                        token = request.getToken();
                        if (StringUtils.isEmpty((String)token)) {
                            response.setCode(1);
                            response.setData(null);
                            response.setMsg(LangRes.get((String)"SsoLoginHandler_2", (String)"Token is empty", (Object[])new Object[0]));
                        } else {
                            CosmiceyeResponse rs = CosmiceyeAuth.get().auth(token);
                            if (rs != null) {
                                if (rs.getErrcode() == 0) {
                                    this.writeSession(token, client);
                                    response.setMsg("success");
                                    response.setCode(0);
                                    OPLOGGER.opLog(this.addLoginLog(exchange, client, true));
                                } else {
                                    response.setCode(rs.getErrcode());
                                    response.setMsg(rs.getDescription());
                                    OPLOGGER.opLog(this.addLoginLog(exchange, client, false));
                                }
                            } else {
                                response.setCode(1);
                                response.setMsg(LangRes.get((String)"SsoLoginHandler_3", (String)"Third-party authentication request exception", (Object[])new Object[0]));
                                OPLOGGER.opLog(this.addLoginLog(exchange, client, false));
                            }
                        }
                    }
                }
            } else {
                response.setCode(-1);
                response.setMsg("[ERROR] access denied,user and password doesn't match,please check monitor configuration ");
            }
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg("SsoLogin exception, message: " + e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange, token);
    }

    private void writeSession(String token, String client) {
        String localToken = CosmiceyeAuth.get().formatLocalToken(token);
        EyeAuther.createClientSession(localToken, client);
    }

    private OpLogEntity addLoginLog(HttpExchange exchange, String user, boolean isSuccess) {
        OpLogEntity opLogEntity = new OpLogEntity();
        opLogEntity.setId(DB.genLongId((String)"T_MONITOR_OPLOG"));
        opLogEntity.setUserName(user);
        opLogEntity.setOpTime(LocalDateTime.now());
        opLogEntity.setClientIp(OpLogUtil.getRemoteHost(exchange));
        opLogEntity.setOpType(OpType.EXECUTE.getTypeDescription());
        opLogEntity.setOpObject("\u767b\u5f55");
        if (isSuccess) {
            opLogEntity.setDescription("\u767b\u5f55\u6210\u529f");
        } else {
            opLogEntity.setDescription("\u767b\u5f55\u5931\u8d25");
        }
        return opLogEntity;
    }

    protected void writeJson(String str, HttpExchange exchange, String token) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        if (StringUtils.isNotEmpty((String)token)) {
            exchange.getResponseHeaders().add("Set-Cookie", this.getSafetyToken(token));
            String localToken = CosmiceyeAuth.get().formatLocalToken(token);
            String csrfToken = EyeAuther.getCsrfToken(localToken);
            exchange.getResponseHeaders().add("monitor-csrf-token", csrfToken == null ? "" : csrfToken);
        }
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private String getSafetyToken(String token) {
        String safetyToken = Boolean.getBoolean("monitor.add.securehttponly.enable") ? EyeAuther.AUTH_TOKEN + "=" + token + ";path=/;secure;HttpOnly" : EyeAuther.AUTH_TOKEN + "=" + token + ";path=/";
        return safetyToken;
    }
}

