/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.sso;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class WhitelistVerify {
    private static final Log logger = LogFactory.getLog(WhitelistVerify.class);
    private static final String SSO_ENABLE = "eye.sso.%s.enable";
    private static final String SSO_WHITE_LIST = "eye.sso.%s.whitelist";
    private static final Map<String, Boolean> clientEnable = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Set<String>> whiteList = new ConcurrentHashMap<String, Set<String>>();

    public static boolean isClientEnable(String client) {
        if (client == null || client.length() == 0) {
            return false;
        }
        return clientEnable.computeIfAbsent(client, k -> {
            String clientEnableKey = String.format(SSO_ENABLE, client);
            AtomicBoolean clientEnabled = new AtomicBoolean(true);
            ConfigurationUtil.observeBoolean((String)clientEnableKey, (boolean)true, v -> clientEnabled.set((boolean)v));
            return clientEnabled.get();
        });
    }

    public static boolean isClientWhite(String client, String clientRemoteIp) {
        if (client == null || client.length() == 0 || clientRemoteIp == null || clientRemoteIp.length() == 0) {
            return false;
        }
        Set clientWhiteList = whiteList.computeIfAbsent(client, k -> {
            final String whitelistKey = String.format(SSO_WHITE_LIST, k);
            String whiteListStr = System.getProperty(whitelistKey);
            logger.info("WhitelistVerify whitelistKey:" + whitelistKey + ",whiteListStr:" + whiteListStr);
            final HashSet<String> whiteSet = new HashSet<String>();
            if (whiteListStr != null && whiteListStr.length() > 0) {
                String[] whiteIds;
                for (String whiteId : whiteIds = whiteListStr.split(",|;")) {
                    if (whiteId.endsWith("*")) {
                        while (whiteId.endsWith("*") || whiteId.endsWith(".")) {
                            whiteId = whiteId.substring(0, whiteId.length() - 1);
                        }
                        whiteSet.add(whiteId);
                    }
                    whiteSet.add(whiteId);
                }
            }
            ConfigurationUtil.observeChange((String)whitelistKey, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    String whiteListStr = System.getProperty(whitelistKey);
                    logger.info("WhitelistVerify change whitelistKey:" + whitelistKey + ",whiteListStr:" + whiteListStr);
                    whiteSet.clear();
                    if (whiteListStr != null && whiteListStr.length() > 0) {
                        String[] whiteIds;
                        for (String whiteId : whiteIds = whiteListStr.split(",|;")) {
                            if (whiteId.endsWith("*")) {
                                while (whiteId.endsWith("*") || whiteId.endsWith(".")) {
                                    whiteId = whiteId.substring(0, whiteId.length() - 1);
                                }
                                whiteSet.add(whiteId);
                            }
                            whiteSet.add(whiteId);
                        }
                    }
                }
            });
            return whiteSet;
        });
        if (clientWhiteList.isEmpty()) {
            return false;
        }
        for (String whiteId : clientWhiteList) {
            if (!clientRemoteIp.startsWith(whiteId)) continue;
            return true;
        }
        return clientWhiteList.contains(clientRemoteIp);
    }
}

