/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.sso.components;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.sso.components.impl.ComponentStatusCheckerBySocket;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class DBListApiHandler
extends AbstractHttpHandler {
    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<Map<String, List>> response1 = new ApiResponse<Map<String, List>>();
        try {
            String cookieToken = EyeAuther.getToken(exchange);
            CosmiceyeResponse rs = CosmiceyeAuth.get().dbList(cookieToken);
            if (rs != null) {
                if (rs.getErrcode() == 0) {
                    response1.setCode(rs.getErrcode());
                    response1.setMsg(rs.getDescription());
                    response1.setData(this.DBList(rs.getData()));
                } else {
                    response1.setCode(rs.getErrcode());
                    response1.setMsg(rs.getDescription());
                    response1.setData(null);
                }
            } else {
                response1.setCode(1);
                response1.setMsg(LangRes.get((String)"SsoLoginHandler_3", (String)"Third-party authentication request exception", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            response1.setCode(-1);
            response1.setMsg("DBList exception, message: " + e.getMessage());
        }
        String str = JSONUtils.toString(response1);
        this.writeJson(str, exchange);
    }

    private Map<String, List> DBList(Map<String, List> dbs) {
        ArrayList dbList1 = new ArrayList();
        if (dbs != null) {
            List dbsdatas = dbs.get("dbs");
            for (Map dbsdata : dbsdatas) {
                HashMap map = new HashMap(8);
                map.put("type", dbsdata.get("type"));
                String ip = (String)dbsdata.get("ip");
                map.put("ip", ip);
                map.put("host_type", dbsdata.get("host_type"));
                int port = (Integer)dbsdata.get("port");
                map.put("port", port);
                map.put("version", dbsdata.get("version"));
                String status = new ComponentStatusCheckerBySocket().check(dbsdata.get("type").toString(), ip, port);
                if (status.equals("ok")) {
                    map.put("status", "ok");
                    map.put("exception", "");
                } else {
                    map.put("status", "exception");
                    map.put("exception", status);
                }
                dbList1.add(map);
            }
            HashMap<String, List> dbList = new HashMap<String, List>(1);
            dbList.put("dbList", dbList1);
            return dbList;
        }
        return null;
    }
}

