/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.sso.cosmiceye;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.sso.cosmiceye.CommonResponse;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

public class CosmiceyeAuth {
    private static Log logger = LogFactory.getLog(CosmiceyeAuth.class);
    private static String ssoAuthUri = "";
    public static final String COSMICEYE_TOKEN_SUFFIX = "$COSMICEYE";
    private static final CosmiceyeAuth INSTANCE;

    private CosmiceyeAuth() {
    }

    public static CosmiceyeAuth get() {
        return INSTANCE;
    }

    private boolean checkAuthUri() {
        return ssoAuthUri != null && ssoAuthUri.length() != 0;
    }

    public CosmiceyeResponse auth(String token) throws IOException {
        return this.remotePost("auth", token, null);
    }

    public CosmiceyeResponse checkpermission(String token, String permission) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("permission", permission);
        return this.remotePost("checkpermission", token, data);
    }

    public CosmiceyeResponse getpermissions(String token) throws IOException {
        HashMap data = new HashMap();
        return this.remotePost("getpermissions", token, data);
    }

    public CosmiceyeResponse middlewareList(String token) throws IOException {
        return this.remotePost("middlewareList", token, null);
    }

    public CosmiceyeResponse dbList(String token) throws IOException {
        return this.remotePost("dbList", token, null);
    }

    public CommonResponse promqlQuery(String token, Map data) throws IOException {
        return this.commonRemotePost("query", token, data);
    }

    public CommonResponse promqlQueryRange(String token, Map data) throws IOException {
        return this.commonRemotePost("queryrange", token, data);
    }

    public CommonResponse promqlQueryRaw(String token, Map data) throws IOException {
        return this.commonRemotePost("queryraw", token, data);
    }

    private CosmiceyeResponse remotePost(String action, String token, Map data) throws IOException {
        if (!this.checkAuthUri()) {
            throw new KDException("The Cosmiceye Auth Url is null");
        }
        token = this.formatCosmicToken(token);
        HashMap<String, Object> body = new HashMap<String, Object>(16);
        body.put("action", action);
        body.put("token", token);
        body.put("data", data);
        String postJson = HttpClientUtils.postAppJson((String)ssoAuthUri, new HashMap(0), body);
        if (postJson != null && postJson.length() != 0) {
            CosmiceyeResponse rs = (CosmiceyeResponse)JSONUtils.cast((String)postJson, CosmiceyeResponse.class);
            if (rs != null && rs.getErrcode() != 0) {
                logger.error("CosmiceyeAuth remotePost failed:" + rs.getDescription());
            }
            return rs;
        }
        return null;
    }

    private CommonResponse commonRemotePost(String action, String token, Map data) throws IOException {
        if (!this.checkAuthUri()) {
            throw new KDException("The Cosmiceye Auth Url is null");
        }
        token = this.formatCosmicToken(token);
        HashMap<String, Object> body = new HashMap<String, Object>(16);
        body.put("action", action);
        body.put("token", token);
        body.put("data", data);
        String postJson = HttpClientUtils.postAppJson((String)ssoAuthUri, new HashMap(0), body);
        if (postJson != null && postJson.length() != 0) {
            CommonResponse rs = (CommonResponse)JSONUtils.cast((String)postJson, CommonResponse.class);
            if (rs != null && rs.getErrcode() != 0) {
                logger.error("CosmiceyeAuth remotePost failed:" + rs.getDescription());
            }
            return rs;
        }
        return null;
    }

    public String formatCosmicToken(String token) {
        if (COSMICEYE_TOKEN_SUFFIX.length() > 0 && token.endsWith(COSMICEYE_TOKEN_SUFFIX)) {
            String localToken = token.substring(0, token.indexOf(COSMICEYE_TOKEN_SUFFIX));
            return localToken;
        }
        return token;
    }

    public String formatLocalToken(String token) {
        if (COSMICEYE_TOKEN_SUFFIX.length() > 0 && !token.endsWith(COSMICEYE_TOKEN_SUFFIX)) {
            String localToken = token + COSMICEYE_TOKEN_SUFFIX;
            return localToken;
        }
        return token;
    }

    static {
        ConfigurationUtil.observeString((String)"eye.sso.cosmiceye.auth", (String)"", v -> {
            ssoAuthUri = v;
        });
        INSTANCE = new CosmiceyeAuth();
    }
}

