/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.sso.cosmiceye;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.sso.SsoClients;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.api.thirdauth.AuthResponseInfo;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class CosmiceyeAuthHandler
implements HttpHandler {
    private final Log logger = LogFactory.getLog(CosmiceyeAuthHandler.class);
    public static final CosmiceyeAuthHandler instance = new CosmiceyeAuthHandler();

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
        AuthResponseInfo response = new AuthResponseInfo();
        String token = "";
        String paramsToken = params.get("token");
        String cookieToken = EyeAuther.getToken(exchange);
        if (StringUtils.isNotEmpty((String)cookieToken) && StringUtils.isNotEmpty((String)paramsToken)) {
            token = cookieToken.startsWith(paramsToken) ? cookieToken : paramsToken;
        } else if (StringUtils.isNotEmpty((String)cookieToken) && StringUtils.isEmpty((String)paramsToken)) {
            token = cookieToken;
        } else if (StringUtils.isEmpty((String)cookieToken) && StringUtils.isNotEmpty((String)paramsToken)) {
            token = paramsToken;
        }
        if (StringUtils.isEmpty((String)token)) {
            this.sendParamsError(response, exchange);
            return;
        }
        String formatToken = CosmiceyeAuth.get().formatLocalToken(token);
        if (!SessionStore.get().exists(formatToken)) {
            CosmiceyeResponse rs = CosmiceyeAuth.get().auth(token);
            if (rs == null || rs.getErrcode() != 0) {
                this.sendCheckError(response, exchange);
                return;
            }
            EyeAuther.createClientSession(formatToken, SsoClients.COSMICEYE.getName());
        }
        exchange.getResponseHeaders().add("Set-Cookie", EyeAuther.AUTH_TOKEN + "=" + formatToken + ";path=/");
        this.success(exchange, formatToken);
    }

    private void sendParamsError(AuthResponseInfo response, HttpExchange exchange) throws IOException {
        response.setCode("1");
        response.setMessage(LangRes.get((String)"ThirdAuthHandler_0", (String)"Parameter Error", (Object[])new Object[0]));
        String str = JSONUtils.toString((Object)response);
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        exchange.sendResponseHeaders(401, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void sendCheckError(AuthResponseInfo response, HttpExchange exchange) throws IOException {
        response.setCode("1");
        response.setMessage(LangRes.get((String)"ThirdAuthHandler_2", (String)"Token Verification Failed", (Object[])new Object[0]));
        String str = JSONUtils.toString((Object)response);
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        exchange.sendResponseHeaders(401, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    protected void writeJson(String str, HttpExchange exchange, String token) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        if (StringUtils.isNotEmpty((String)token)) {
            exchange.getResponseHeaders().add("monitor-csrf-token", EyeAuther.getCsrfToken(token));
        }
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void success(HttpExchange exchange, String token) throws IOException {
        ApiResponse apiResponse = new ApiResponse();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("clusterName", Instance.getClusterName());
        data.put("webPort", Integer.getInteger("EYE_HTTP_PORT"));
        data.put("circuitbreaker", System.getProperty("circuitbreaker.type", "nothing").toLowerCase());
        data.put("traceType", System.getProperty("gov.trace.reporter.type", "sword").toLowerCase());
        apiResponse.setCode(0);
        apiResponse.setData(data);
        apiResponse.setMsg("success");
        String str = JSONUtils.toString(apiResponse);
        this.writeJson(str, exchange, token);
    }
}

