/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.sysprop;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import kd.bos.eye.api.common.entity.KeyValueEntity;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class SystemPropApiHandler
extends AbstractHttpHandler {
    private static final String STRICT_ENABLE_CONFIG = "monitor.properties.strict.enable";
    private static final String STRICT_SHOW = "monitor.properties.strict.show";
    private static final String STRICT_NOT_SHOW = "monitor.properties.strict.notshow";
    private static final String DEFAULT_STRICT_SHOW = "appIds,registedAppIds,appIdsFromAppStore,appSplit,appName,configAppName,JVM_OPTS,WEB_OPTS,clusterName,BIZLIBS,BOSLIBS,lightweightdeploy,APPSTORE_URL";
    private static final String DEFAULT_ALWAYS_NOT_SHOW = "monitor.password,kd.bos.encrypt.encryptKey,kd.bos.encrypt.encryptIvKey,kd.bos.encrypt.keyLength,spring.cloud.nacos.password,";
    private static final String ALWAYS_NOT_SHOW = "monitor.properties.always.notshow";
    private static final Log logger = LogFactory.getLog(SystemPropApiHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        Properties ps = System.getProperties();
        String ip = NetAddressUtils.getLocalIpAddress();
        try {
            String filter = params.get("filter");
            List<KeyValueEntity> properties = this.isStrictEnable(ps) ? this.getStrictAllProperties(ps, filter) : this.getNotStrictAllProperties(ps, filter);
            String wantToGetStr = params.get("properties");
            if (StringUtils.isNotEmpty((String)wantToGetStr)) {
                String[] wantToGetProArr = wantToGetStr.split(",|;");
                properties = properties.stream().filter(keyValueEntity -> Arrays.stream(wantToGetProArr).anyMatch(keyValueEntity::containsKey)).collect(Collectors.toList());
            }
            response.put("code", 0);
            response.put("data", properties);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", "");
            response.put("msg", e);
            logger.error((Throwable)e);
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private static boolean matchIgnoreCase(String str, String word) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.toLowerCase().contains(word.toLowerCase());
    }

    private boolean isStrictEnable(Properties properties) {
        return Boolean.parseBoolean(properties.getProperty(STRICT_ENABLE_CONFIG, "false"));
    }

    private List<String> getStrictShowList(Properties properties) {
        String strictShowString = properties.getProperty(STRICT_SHOW, "");
        String[] strictShowArray = strictShowString.split(",");
        ArrayList<String> strictShowList = new ArrayList<String>(strictShowArray.length);
        Collections.addAll(strictShowList, strictShowArray);
        return strictShowList;
    }

    private List<String> getStrictNotShowList(Properties properties) {
        String strictNotShowString = properties.getProperty(STRICT_NOT_SHOW, "");
        String[] strictNotShowArray = strictNotShowString.split(",");
        ArrayList<String> strictNotShowList = new ArrayList<String>(strictNotShowArray.length);
        Collections.addAll(strictNotShowList, strictNotShowArray);
        return strictNotShowList;
    }

    private List<String> getDefaultShowList() {
        String[] defaultShowArray = DEFAULT_STRICT_SHOW.split(",");
        ArrayList<String> defaultShowList = new ArrayList<String>(defaultShowArray.length);
        Collections.addAll(defaultShowList, defaultShowArray);
        return defaultShowList;
    }

    private List<KeyValueEntity> getNotStrictAllProperties(Properties properties, String filter) {
        ArrayList<KeyValueEntity> allProperties = new ArrayList<KeyValueEntity>(properties.size());
        for (String key : properties.stringPropertyNames()) {
            if (StringUtils.isNull((String)System.getProperty(key))) {
                logger.error("SYS_PROPS: key = " + key + ", value = null");
                try {
                    System.clearProperty(key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.isAlwaysNotShow(key) || filter != null && !SystemPropApiHandler.matchIgnoreCase(key, filter) && !SystemPropApiHandler.matchIgnoreCase(System.getProperty(key), filter)) continue;
            allProperties.add(new KeyValueEntity(key, properties.getProperty(key)));
        }
        return allProperties;
    }

    private List<KeyValueEntity> getStrictAllProperties(Properties properties, String filter) {
        ArrayList<KeyValueEntity> allProperties = new ArrayList<KeyValueEntity>(properties.size());
        List<String> defaultShowList = this.getDefaultShowList();
        List<String> strictShowList = this.getStrictShowList(properties);
        List<String> strictNotShowList = this.getStrictNotShowList(properties);
        defaultShowList.addAll(strictShowList);
        defaultShowList.removeIf(strictNotShowList::contains);
        for (String key : properties.stringPropertyNames()) {
            if (!defaultShowList.contains(key) || filter != null && !SystemPropApiHandler.matchIgnoreCase(key, filter) && !SystemPropApiHandler.matchIgnoreCase(System.getProperty(key), filter)) continue;
            allProperties.add(new KeyValueEntity(key, properties.getProperty(key)));
        }
        return allProperties;
    }

    private boolean isAlwaysNotShow(String key) {
        String[] alwaysNotShowArr;
        String alwaysNotShow = DEFAULT_ALWAYS_NOT_SHOW + System.getProperty(ALWAYS_NOT_SHOW);
        for (String str : alwaysNotShowArr = alwaysNotShow.split(",")) {
            if (!str.equals(key)) continue;
            return true;
        }
        return false;
    }
}

