/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.temptable;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.registry.PKTempTableRegistry;
import kd.bos.db.temptable.pk.stats.PKTempTableStats;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;

public class TempTableHandler
extends AbstractHttpHandler {
    private static final String VALUE = "value";
    private static final String KEY = "key";
    private static final String DESC = "desc";
    private static final String PROJECT_NAME = "bos-eye";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        try {
            CountDownLatch latch = new CountDownLatch(1);
            boolean noPool = PKTempTableConfig.isNoPool();
            PKTempTableRegistry.RegistryType registryType = PKTempTableConfig.getRegistryType();
            retMap.put("configTable", this.getPKTempTableConfig());
            retMap.put("unCheck", PKTempTableStats.getUncheck());
            retMap.put("timeouts", PKTempTableStats.getTimeout());
            retMap.put("unRelease", PKTempTableStats.getUnRelease());
            retMap.put("borrowed", PKTempTableStats.getBorrowed());
            retMap.put("release", PKTempTableStats.getReleased());
            retMap.put("usedInPool", PKTempTableStats.getUsedInPool());
            retMap.put("poolTotal", PKTempTableStats.getPoolTotal());
            retMap.put("noPool", noPool);
            retMap.put("registryType", registryType);
            if (registryType == PKTempTableRegistry.RegistryType.db) {
                ThreadPools.executeOnce((String)"query t_pktemp_instance", () -> {
                    try {
                        retMap.put("tempInstances", PKTempTableStats.getPKTempInstanceInDB());
                    }
                    finally {
                        latch.countDown();
                    }
                });
                latch.await();
            }
            ArrayList crashTable = new ArrayList(32);
            Iterator iterator = PKTempTableStats.getCrashNode().entrySet().iterator();
            while (iterator.hasNext()) {
                HashMap<String, Object> crashMap = new HashMap<String, Object>(8);
                Map.Entry next = iterator.next();
                crashMap.put("instanceId", next.getKey());
                Integer[] value = (Integer[])next.getValue();
                crashMap.put("crashTimes", value[0]);
                crashMap.put("tableNum", value[1]);
                crashTable.add(crashMap);
            }
            retMap.put("crashTable", crashTable);
            response.setMsg("success");
            response.setCode(0);
            response.setData(retMap);
        }
        catch (Exception e) {
            response.setCode(1);
            response.setMsg(ExceptionHandler.getExceptionStackTrace(e));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<Map<String, Object>> getPKTempTableConfig() {
        ArrayList<Map<String, Object>> configTable = new ArrayList<Map<String, Object>>(16);
        HashMap<String, Object> item = new HashMap<String, Object>(3);
        item.put(KEY, "db.pktemp.registry");
        item.put(VALUE, PKTempTableConfig.getRegistryType());
        item.put(DESC, LangRes.get((String)"TempTableHandler_1", (String)"Registration Type Zookeeper/DB (Default DB)", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.nopool");
        item.put(VALUE, String.valueOf(PKTempTableConfig.isNoPool()));
        item.put(DESC, LangRes.get((String)"TempTableHandler_2", (String)"Enable Temporary Table Pool", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.withindex");
        item.put(VALUE, String.valueOf(PKTempTableConfig.isTempWithIndex()));
        item.put(DESC, LangRes.get((String)"TempTableHandler_3", (String)"Create Index for Temporary Tables", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.clearservice.interval_minute");
        item.put(VALUE, PKTempTableConfig.getClearIntervalMinute());
        item.put(DESC, LangRes.get((String)"TempTableHandler_4", (String)"Temporary Table Cleanup Interval (Minutes)", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.timeout_minute");
        item.put(VALUE, PKTempTableConfig.getTimeoutMinute());
        item.put(DESC, LangRes.get((String)"TempTableHandler_5", (String)"Temporary Table Timeout (Minutes)", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.big_string_length");
        item.put(VALUE, PKTempTableConfig.getBigStringLength());
        item.put(DESC, LangRes.get((String)"TempTableHandler_6", (String)"Table Character Column Length", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.clearservice.startup_delay_minute");
        item.put(VALUE, PKTempTableConfig.getClearStartupDelayMinute());
        item.put(DESC, LangRes.get((String)"TempTableHandler_7", (String)"Delayed Start for Table Cleanup Service (Minutes)", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.pool.maxTotal");
        item.put(VALUE, PKTempTableConfig.getPoolMaxTotal());
        item.put(DESC, LangRes.get((String)"TempTableHandler_8", (String)"Maximum Temporary Tables in the Pool", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.pool.maxIdle");
        item.put(VALUE, PKTempTableConfig.getPoolMaxIdle());
        item.put(DESC, LangRes.get((String)"TempTableHandler_9", (String)"Maximum Idle Temporary Tables in the Pool", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.pool.minIdle");
        item.put(VALUE, PKTempTableConfig.getPoolMinIdle());
        item.put(DESC, LangRes.get((String)"TempTableHandler_10", (String)"Minimum Idle Temporary Tables in the Pool", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.pool.maxWait");
        item.put(VALUE, PKTempTableConfig.getPoolMaxWait());
        item.put(DESC, LangRes.get((String)"TempTableHandler_11", (String)"Maximum Wait Time for Temporary Tables (Milliseconds)", (Object[])new Object[0]));
        configTable.add(item);
        item = new HashMap(3);
        item.put(KEY, "db.pktemp.release_thread");
        item.put(VALUE, PKTempTableConfig.getReleaseThread());
        item.put(DESC, LangRes.get((String)"TempTableHandler_12", (String)"Temporary Table Recycling Task Threads", (Object[])new Object[0]));
        configTable.add(item);
        return configTable;
    }
}

