/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.tenantresource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.eye.api.tenantresource.entity.MetricsEnum;
import kd.bos.eye.api.tenantresource.entity.TenantMetrics;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.resource.balancer.quota.TenantWeightManage;
import kd.bos.util.JSONUtils;

public class ResourcesMetricsHandler
extends AbstractHttpHandler {
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);
    private static final String SPLIT = "-";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        Map params = ExchangeVueUtils.parseJsonFromPost(exchange, Map.class);
        JSONArray array = storage.queryTenantMetrics(params);
        List list = array.toJavaList(TenantMetrics.class);
        List accounts = TenantWeightManage.getAllAccountsOfCurrentEnv();
        HashMap nameMap = new HashMap(accounts.size());
        accounts.forEach(a -> nameMap.put(a.getAccountId(), a.getAccountName()));
        Map<String, Map<String, List>> groupedAndSorted = list.stream().collect(Collectors.groupingBy(TenantMetrics::getIp, Collectors.groupingBy(TenantMetrics::getResourceName, Collectors.collectingAndThen(Collectors.toList(), l -> l.stream().sorted(Comparator.comparing(TenantMetrics::getTimestamp)).collect(Collectors.toList())))));
        JSONObject retData = new JSONObject();
        for (Map.Entry<String, Map<String, List>> ipEntry : groupedAndSorted.entrySet()) {
            String ip = ipEntry.getKey();
            Map<String, List> resources = ipEntry.getValue();
            for (Map.Entry<String, List> resourceEntry : resources.entrySet()) {
                String resource = resourceEntry.getKey();
                List data = resourceEntry.getValue();
                String appName = "";
                ArrayList<String> legends = new ArrayList<String>(16);
                HashMap<String, List> activeTenantData = new HashMap<String, List>(6);
                HashMap<String, List> waitingTenantData = new HashMap<String, List>(6);
                HashMap<String, List> rejectedTenantData = new HashMap<String, List>(6);
                ArrayList<String> xData = new ArrayList<String>(16);
                for (TenantMetrics tenantMetrics : data) {
                    String accountId;
                    String name;
                    if ("".equals(appName)) {
                        appName = tenantMetrics.getAppName();
                    }
                    String string = name = nameMap.containsKey(accountId = tenantMetrics.getAccountId()) ? (String)nameMap.get(accountId) : accountId;
                    if (!legends.contains(name)) {
                        legends.add(name);
                    }
                    if (!xData.contains(tenantMetrics.getxAxis())) {
                        xData.add(tenantMetrics.getxAxis());
                    }
                    List aData = activeTenantData.computeIfAbsent(name, k -> new ArrayList(16));
                    aData.add(tenantMetrics.getActive());
                    List wData = waitingTenantData.computeIfAbsent(name, k -> new ArrayList(16));
                    wData.add(tenantMetrics.getWaiting());
                    List rData = rejectedTenantData.computeIfAbsent(name, k -> new ArrayList(16));
                    rData.add(tenantMetrics.getRejected());
                }
                JSONObject activeData = new JSONObject();
                String activeTitle = appName + SPLIT + ip + SPLIT + resource + SPLIT + MetricsEnum.ACTIVE.getDes();
                activeData.put("name", (Object)activeTitle);
                activeData.put("xAxis", xData);
                activeData.put("legendData", legends);
                activeData.put("yAxis", activeTenantData);
                JSONObject waitingData = new JSONObject();
                String waitingTitle = appName + SPLIT + ip + SPLIT + resource + SPLIT + MetricsEnum.WAITING.getDes();
                waitingData.put("name", (Object)waitingTitle);
                waitingData.put("xAxis", xData);
                waitingData.put("legendData", legends);
                waitingData.put("yAxis", waitingTenantData);
                JSONObject rejectedData = new JSONObject();
                String rejectedTitle = appName + SPLIT + ip + SPLIT + resource + SPLIT + MetricsEnum.REJECTED.getDes();
                rejectedData.put("name", (Object)rejectedTitle);
                rejectedData.put("xAxis", xData);
                rejectedData.put("legendData", legends);
                rejectedData.put("yAxis", rejectedTenantData);
                String activeKey = ip + SPLIT + resource + SPLIT + MetricsEnum.ACTIVE.getLabel();
                retData.put(activeKey, (Object)activeData);
                String waitingKey = ip + SPLIT + resource + SPLIT + MetricsEnum.WAITING.getLabel();
                retData.put(waitingKey, (Object)waitingData);
                String rejectedKey = ip + SPLIT + resource + SPLIT + MetricsEnum.REJECTED.getLabel();
                retData.put(rejectedKey, (Object)rejectedData);
            }
        }
        ApiResponse<JSONObject> apiResponse = new ApiResponse<JSONObject>();
        apiResponse.setData(retData);
        apiResponse.setCode(0);
        this.writeJson(JSONUtils.toString(apiResponse), exchange);
    }
}

