/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.tenantresource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.eye.api.tenantresource.ResourceQueueConfig;
import kd.bos.eye.api.tenantresource.TenantWeightPriority;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.quota.ResourceConfigManage;
import kd.bos.resource.balancer.quota.config.TenantConfigDao;
import kd.bos.resource.balancer.quota.config.TenantConfigInfo;

public class TenantConfigMonitorDao
implements TenantConfigDao {
    private static final Log LOGGER = LogFactory.getLog(TenantConfigMonitorDao.class);
    private static final String TENANT_CONFIG_TABLE = "t_monitor_multitenant_tc";
    private static final String TENANT_WEIGHT_PRIORITY_TABLE = "t_monitor_multitenant_twp";
    private static final String RESOURCE_QUEUE_CONFIG_TABLE = "t_monitor_multitenant_rqc";
    private Map<String, TenantConfigInfo> configInfoMap = new ConcurrentHashMap<String, TenantConfigInfo>(16);
    private Map<String, TenantWeightPriority> tenantWeightMap = new ConcurrentHashMap<String, TenantWeightPriority>(16);
    private Map<String, ResourceQueueConfig> resourceQueueConfigMap = new ConcurrentHashMap<String, ResourceQueueConfig>(16);
    private boolean isInitCache = false;

    private boolean queryDbEnable() {
        return "true".equals(System.getProperty("bos.multiTenant.resource.balance.enable"));
    }

    public void initCache() {
        this.configInfoMap.clear();
        this.tenantWeightMap.clear();
        this.resourceQueueConfigMap.clear();
        if (this.queryDbEnable()) {
            List<TenantConfigInfo> configInfoList = this.getTenantConfigFromDB();
            configInfoList.forEach(tenantConfigInfo -> this.configInfoMap.put(tenantConfigInfo.getResourceName() + tenantConfigInfo.getAccountId(), (TenantConfigInfo)tenantConfigInfo));
            List<TenantWeightPriority> tenantWeightList = this.getTenantWeightPriority();
            tenantWeightList.forEach(tenantWeightPriority -> this.tenantWeightMap.put(tenantWeightPriority.getAccountId(), (TenantWeightPriority)tenantWeightPriority));
            List<ResourceQueueConfig> resourceConfigList = this.getResourceQueueConfig();
            resourceConfigList.forEach(res -> this.resourceQueueConfigMap.put(res.getResourceName(), (ResourceQueueConfig)res));
        }
        this.isInitCache = true;
    }

    private TenantConfigInfo getTenantConfigInfoFromCache(String key) {
        return this.configInfoMap.get(key);
    }

    private TenantWeightPriority getTenantWeightPriorityFromCache(String key) {
        TenantWeightPriority weightPriority = this.tenantWeightMap.computeIfAbsent(key, k -> new TenantWeightPriority((String)k));
        return weightPriority;
    }

    private ResourceQueueConfig getResourceQueueConfigFromCache(String key) {
        ResourceQueueConfig resourceConfig = this.resourceQueueConfigMap.computeIfAbsent(key, k -> new ResourceQueueConfig((String)k, ResourceConfigManage.getResourceMaxQueueSize((String)k), ResourceConfigManage.getResourceMinProportion((String)k)));
        return resourceConfig;
    }

    public TenantConfigInfo getTenantConfig(String resourceName, String accountId) {
        TenantWeightPriority defaultTenant;
        String key;
        TenantConfigInfo info;
        if (!this.isInitCache) {
            this.initCache();
        }
        if ((info = this.getTenantConfigInfoFromCache(key = resourceName + accountId)) == null) {
            info = new TenantConfigInfo(resourceName, accountId);
            defaultTenant = this.getTenantWeightPriorityFromCache(accountId);
            ResourceQueueConfig defaultResource = this.getResourceQueueConfigFromCache(resourceName);
            info.setWeight(defaultTenant.getWeight());
            info.setPriority(defaultTenant.getPriority());
            info.setMaxQueueSize(defaultResource.getMaxQueueSize());
            info.setMinProportion(defaultResource.getMinProportion());
        }
        if (info.getWeight() <= 0 || info.getPriority() <= 0) {
            defaultTenant = this.getTenantWeightPriorityFromCache(accountId);
            info.setWeight(defaultTenant.getWeight());
            info.setPriority(defaultTenant.getPriority());
        }
        if (info.getMaxQueueSize() <= 0 || info.getMinProportion() <= 0) {
            ResourceQueueConfig defaultResource = this.getResourceQueueConfigFromCache(resourceName);
            info.setMaxQueueSize(defaultResource.getMaxQueueSize());
            info.setMinProportion(defaultResource.getMinProportion());
        }
        return info;
    }

    public TenantConfigInfo getTenantConfigFromDB(String resourceName, String accountId) {
        if (!DBHelper.dbIsConfigured()) {
            return null;
        }
        TenantConfigInfo info = null;
        String sql = TenantConfigMonitorDao.buildQuerySql(TENANT_CONFIG_TABLE, new String[]{"fid", "fresourcename", "faccountid", "fweight", "fpriority", "fmaxqueuesize"}, new String[]{"fresourcename", "faccountid"});
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(resourceName);
        params.add(accountId);
        try {
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, params));
            List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (!results.isEmpty()) {
                Result result = (Result)results.get(0);
                info = new TenantConfigInfo(result.getString("fresourcename"), result.getString("faccountid"));
                info.setId(Long.valueOf(Long.parseLong(result.getString("fid"))));
                info.setWeight(Integer.parseInt(result.getString("fweight")));
                info.setPriority(Integer.parseInt(result.getString("fpriority")));
                info.setMaxQueueSize(Integer.parseInt(result.getString("fmaxqueuesize")));
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return info;
    }

    public List<TenantConfigInfo> getTenantConfigFromDB(String resourceName) {
        if (!DBHelper.dbIsConfigured()) {
            return Collections.EMPTY_LIST;
        }
        String sql = TenantConfigMonitorDao.buildQuerySql(TENANT_CONFIG_TABLE, new String[]{"fid", "fresourcename", "faccountid", "fweight", "fpriority", "fmaxqueuesize"}, new String[]{"fresourcename"});
        ArrayList<String> params = new ArrayList<String>(1);
        ArrayList<TenantConfigInfo> list = new ArrayList<TenantConfigInfo>(16);
        params.add(resourceName);
        try {
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, params));
            List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            for (Result row : result) {
                TenantConfigInfo info = new TenantConfigInfo(row.getString("fresourcename"), row.getString("faccountid"));
                info.setId(Long.valueOf(Long.parseLong(row.getString("fid"))));
                info.setWeight(Integer.parseInt(row.getString("fweight")));
                info.setPriority(Integer.parseInt(row.getString("fpriority")));
                info.setMaxQueueSize(Integer.parseInt(row.getString("fmaxqueuesize")));
                list.add(info);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return list;
    }

    public List<TenantConfigInfo> getTenantConfigFromDB() {
        if (!DBHelper.dbIsConfigured()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TenantConfigInfo> list = new ArrayList<TenantConfigInfo>(16);
        try {
            String sql = TenantConfigMonitorDao.buildQuerySql(TENANT_CONFIG_TABLE, new String[]{"fid", "fresourcename", "faccountid", "fweight", "fpriority", "fmaxqueuesize"}, new String[0]);
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, new ArrayList()));
            List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            for (Result row : result) {
                TenantConfigInfo info = new TenantConfigInfo(row.getString("fresourcename"), row.getString("faccountid"));
                info.setId(Long.valueOf(Long.parseLong(row.getString("fid"))));
                info.setWeight(Integer.parseInt(row.getString("fweight")));
                info.setPriority(Integer.parseInt(row.getString("fpriority")));
                info.setMaxQueueSize(Integer.parseInt(row.getString("fmaxqueuesize")));
                list.add(info);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return list;
    }

    public ResourceQueueConfig getResourceQueueConfig(String resourceName) {
        ResourceQueueConfig config = null;
        if (!DBHelper.dbIsConfigured()) {
            return new ResourceQueueConfig(resourceName, ResourceConfigManage.getResourceMaxQueueSize((String)resourceName), ResourceConfigManage.getResourceMinProportion((String)resourceName));
        }
        String sql = TenantConfigMonitorDao.buildQuerySql(RESOURCE_QUEUE_CONFIG_TABLE, new String[]{"fid", "fresourcename", "fmaxqueuesize", "fminproportion"}, new String[]{"fresourcename"});
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(resourceName);
        try {
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, params));
            List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (!results.isEmpty()) {
                Result result = (Result)results.get(0);
                config = new ResourceQueueConfig(result.getString("fresourcename"), Integer.parseInt(result.getString("fmaxqueuesize")), Integer.parseInt(result.getString("fminproportion")));
                config.setId(Long.parseLong(result.getString("fid")));
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        if (config == null) {
            config = new ResourceQueueConfig(resourceName, ResourceConfigManage.getResourceMaxQueueSize((String)resourceName), ResourceConfigManage.getResourceMinProportion((String)resourceName));
        }
        return config;
    }

    public List<ResourceQueueConfig> getResourceQueueConfig() {
        if (!DBHelper.dbIsConfigured()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResourceQueueConfig> list = new ArrayList<ResourceQueueConfig>(16);
        try {
            String sql = TenantConfigMonitorDao.buildQuerySql(RESOURCE_QUEUE_CONFIG_TABLE, new String[]{"fid", "fresourcename", "fmaxqueuesize", "fminproportion"}, new String[0]);
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, new ArrayList()));
            List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            for (Result row : result) {
                ResourceQueueConfig config = new ResourceQueueConfig(row.getString("fresourcename"), Integer.parseInt(row.getString("fmaxqueuesize")), Integer.parseInt(row.getString("fminproportion")));
                config.setId(Long.parseLong(row.getString("fid")));
                list.add(config);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return list;
    }

    public TenantWeightPriority getTenantWeightPriority(String accountId) {
        if (!DBHelper.dbIsConfigured()) {
            return new TenantWeightPriority(accountId);
        }
        TenantWeightPriority weightPriority = null;
        String sql = TenantConfigMonitorDao.buildQuerySql(TENANT_WEIGHT_PRIORITY_TABLE, new String[]{"fid", "faccountid", "fweight", "fpriority"}, new String[]{"faccountid"});
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(accountId);
        try {
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, params));
            List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (!results.isEmpty()) {
                Result result = (Result)results.get(0);
                weightPriority = new TenantWeightPriority(result.getString("faccountid"));
                weightPriority.setId(Long.parseLong(result.getString("fid")));
                weightPriority.setWeight(Integer.parseInt(result.getString("fweight")));
                weightPriority.setPriority(Integer.parseInt(result.getString("fpriority")));
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        if (weightPriority == null) {
            weightPriority = new TenantWeightPriority(accountId);
        }
        return weightPriority;
    }

    public List<TenantWeightPriority> getTenantWeightPriority() {
        if (!DBHelper.dbIsConfigured()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TenantWeightPriority> list = new ArrayList<TenantWeightPriority>(16);
        try {
            String sql = TenantConfigMonitorDao.buildQuerySql(TENANT_WEIGHT_PRIORITY_TABLE, new String[]{"fid", "faccountid", "fweight", "fpriority"}, new String[0]);
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, new ArrayList()));
            List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            for (Result row : result) {
                TenantWeightPriority tenantWeightPriority = new TenantWeightPriority(row.getString("faccountid"));
                tenantWeightPriority.setId(Long.parseLong(row.getString("fid")));
                tenantWeightPriority.setWeight(Integer.parseInt(row.getString("fweight")));
                tenantWeightPriority.setPriority(Integer.parseInt(row.getString("fpriority")));
                list.add(tenantWeightPriority);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return list;
    }

    public void saveTenantConfig(TenantConfigInfo info) {
        if (!DBHelper.dbIsConfigured() || info == null) {
            return;
        }
        if (info.getId() != null) {
            this.updateTenantConfig(info);
            return;
        }
        info.setId(Long.valueOf(ID.genLongId()));
        ArrayList paramList = new ArrayList(6);
        Collections.addAll(paramList, info.getId(), info.getResourceName(), info.getAccountId(), info.getWeight(), info.getPriority(), info.getMaxQueueSize());
        String sql = TenantConfigMonitorDao.buildInsertSql(TENANT_CONFIG_TABLE, 6);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    public void updateTenantConfig(TenantConfigInfo info) {
        String updateSql = TenantConfigMonitorDao.buildUpdateSql(TENANT_CONFIG_TABLE, new String[]{"fweight", "fpriority", "fmaxqueuesize"}, new String[]{"fid"});
        ArrayList paramList = new ArrayList(4);
        Collections.addAll(paramList, info.getWeight(), info.getPriority(), info.getMaxQueueSize(), info.getId());
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    public void saveDefaultTenantConfig(TenantWeightPriority tenantWeightPriority) {
        if (!DBHelper.dbIsConfigured() || tenantWeightPriority == null) {
            return;
        }
        if (tenantWeightPriority.getId() != null) {
            this.updateDefaultTenantConfig(tenantWeightPriority);
            return;
        }
        tenantWeightPriority.setId(ID.genLongId());
        ArrayList paramList = new ArrayList(4);
        Collections.addAll(paramList, tenantWeightPriority.getId(), tenantWeightPriority.getAccountId(), tenantWeightPriority.getWeight(), tenantWeightPriority.getPriority());
        String sql = TenantConfigMonitorDao.buildInsertSql(TENANT_WEIGHT_PRIORITY_TABLE, 4);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    public void updateDefaultTenantConfig(TenantWeightPriority tenantWeightPriority) {
        String updateSql = TenantConfigMonitorDao.buildUpdateSql(TENANT_WEIGHT_PRIORITY_TABLE, new String[]{"fweight", "fpriority"}, new String[]{"fid"});
        ArrayList paramList = new ArrayList(3);
        Collections.addAll(paramList, tenantWeightPriority.getWeight(), tenantWeightPriority.getPriority(), tenantWeightPriority.getId());
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    public void saveDefaultResourceQueueConfig(ResourceQueueConfig config) {
        if (!DBHelper.dbIsConfigured() || config == null) {
            return;
        }
        if (config.getId() != null) {
            this.updateDefaultResourceQueueConfig(config);
            return;
        }
        config.setId(ID.genLongId());
        ArrayList paramList = new ArrayList(4);
        Collections.addAll(paramList, config.getId(), config.getResourceName(), config.getMaxQueueSize(), config.getMinProportion());
        String sql = TenantConfigMonitorDao.buildInsertSql(RESOURCE_QUEUE_CONFIG_TABLE, 4);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    public void updateDefaultResourceQueueConfig(ResourceQueueConfig config) {
        String updateSql = TenantConfigMonitorDao.buildUpdateSql(RESOURCE_QUEUE_CONFIG_TABLE, new String[]{"fmaxqueuesize", "fminproportion"}, new String[]{"fid"});
        ArrayList paramList = new ArrayList(3);
        Collections.addAll(paramList, config.getMaxQueueSize(), config.getMinProportion(), config.getId());
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    private static String buildUpdateSql(String tableName, String[] updateFields, String[] filterFields) {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tableName).append(" ");
        int updateSize = updateFields.length;
        for (int i = 0; i < updateSize; ++i) {
            if (i == 0) {
                updateSql.append("set ");
            }
            updateSql.append(updateFields[i]).append("= ?");
            if (i == updateSize - 1) continue;
            updateSql.append(",");
        }
        updateSql.append(" where ");
        int filterSize = filterFields.length;
        for (int i = 0; i < filterSize; ++i) {
            updateSql.append(filterFields[i]).append(" = ?");
            if (i == filterSize - 1) continue;
            updateSql.append(" and ");
        }
        return updateSql.toString();
    }

    private static String buildInsertSql(String tableName, int filedSize) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into ").append(tableName).append(" values( ");
        for (int i = 0; i < filedSize; ++i) {
            if (i == filedSize - 1) {
                insertSql.append("?)");
                continue;
            }
            insertSql.append("?,");
        }
        return insertSql.toString();
    }

    private static String buildQuerySql(String tableName, String[] queryFields, String[] filterFields) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ");
        int querySize = queryFields.length;
        for (int i = 0; i < querySize; ++i) {
            querySql.append(queryFields[i]);
            if (i == querySize - 1) continue;
            querySql.append(",");
        }
        querySql.append(" from ").append(tableName);
        if (filterFields != null && filterFields.length > 0) {
            int filterSize = filterFields.length;
            querySql.append(" where ");
            for (int i = 0; i < filterSize; ++i) {
                querySql.append(filterFields[i]).append(" = ?");
                if (i == filterSize - 1) continue;
                querySql.append(" and ");
            }
        }
        return querySql.toString();
    }
}

