/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.eye.api.common.entity.KeyValueEntity;
import kd.bos.eye.api.thread.NewThreadDumpHandler;
import kd.bos.eye.api.thread.ThreadInfo;
import kd.bos.eye.api.thread.entity.AllThreadDumpInfo;
import kd.bos.eye.api.thread.entity.NodeInfo;
import kd.bos.eye.api.thread.entity.ThreadDumpInfo;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.eye.util.HttpClients;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangUtil;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class NewRemoteThreadHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(NewRemoteThreadHandler.class);
    private static final int readtimeout = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    private static final String PROXY_HEADER_KEY = EyeProxyHandler.PROXY_HEADER_KEY;
    private static final String PROXY_HEADER_VALUE = EyeProxyHandler.PROXY_HEADER_VALUE;

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        String userName = params.get("user");
        String traceId = params.get("traceId");
        String ipAndPort = params.get("ipAndPort");
        String userPermission = EyeAuther.getUserPermission(userName);
        String ip = null;
        if (ipAndPort != null) {
            ip = ipAndPort.split(":")[0];
        }
        List<ThreadDumpInfo> threadDumpInfoList = this.getAllRemoteThreadDumpInfo(ip, traceId, ipAndPort, exchange);
        String remoteData = "";
        if (threadDumpInfoList != null && !threadDumpInfoList.isEmpty()) {
            remoteData = this.createRemoteThreadDumpHtml(userPermission, threadDumpInfoList);
        }
        try {
            this.sendResponse(exchange, remoteData);
        }
        catch (IOException e) {
            logger.error("send response is failed.", (Throwable)e);
        }
    }

    private void sendResponse(HttpExchange exchange, String data) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private String createRemoteThreadDumpHtml(String userPermission, List<ThreadDumpInfo> threadDumpInfoList) {
        StringBuilder content = new StringBuilder();
        String spanContent = "<div style=\"display: inline-block; margin-right: 10px; margin-left: 10px; margin-top: 300px;\">==></div>";
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            String showThreadName = threadDumpInfo.getShowThreadName();
            String traceId = threadDumpInfo.getTraceId();
            if (StringUtils.isNotEmpty((String)traceId) && threadDumpInfo.isSupportTerminationSql() && Long.parseLong(threadDumpInfo.getDuration()) >= threadDumpInfo.getAfterTimeShow() * 1000L && StringUtils.isNotEmpty((String)userPermission) && userPermission.contains("threadAnalyse-terminateRequest") && threadDumpInfo.getShowThreadName().startsWith("RpcRequest")) {
                long threadId = threadDumpInfo.getThreadId();
                String threadName = threadDumpInfo.getThreadName();
                String ip = threadDumpInfo.getIp();
                String monitorPort = threadDumpInfo.getMonitorPort();
                String btnId = UUID.randomUUID().toString().split("-")[0];
                String threadContent = StringEscapeUtils.escapeJavaScript((String)("Terminated appName: " + threadDumpInfo.getAppName() + ",formId: " + threadDumpInfo.getFormId() + ",action: " + threadDumpInfo.getAction() + ",tenantId: " + threadDumpInfo.getTenantId() + ",userName: " + threadDumpInfo.getUserName() + ",startup Time: " + threadDumpInfo.getStartTime() + ",clientUrl: " + threadDumpInfo.getClientUrl()));
                String rpcContent = " <a class=\"review\" id=" + btnId + " href=\"javascript:void(0);\" onclick=\"stopRpcMethod('" + LangRes.get((String)"ThreadDumpHandler_18", (String)"StopRpcMethodConfirmationPrompt", (Object[])new Object[0]) + "', '" + Instance.getClusterName() + "', '" + threadName + "', '" + threadId + "', '" + traceId + "', '" + ip + "', '" + monitorPort + "', '" + threadContent + "', '" + threadDumpInfo.getDuration() + "')\"" + " style=\"color: #ff0000;\" > ( " + LangRes.get((String)"ThreadDumpHandler_16", (String)"StopRpcMethod", (Object[])new Object[0]) + " ) </a>";
                showThreadName = showThreadName + rpcContent;
            }
            content.append(spanContent).append("<div style=\"display: inline-block; width: 900px; word-wrap: break-word\">").append("<div class=\"line1\">").append(showThreadName).append("</div>").append(this.getFormatThreadStatisticInfo(threadDumpInfo)).append(this.getFormatMemSpanInfo(userPermission, threadDumpInfo)).append(this.getFormatStackTrace(threadDumpInfo)).append("</div>");
        }
        return content.toString();
    }

    private String getFormatThreadStatisticInfo(ThreadDumpInfo threadDumpInfo) {
        String info = "<div class=\"line2\">&nbsp;&nbsp;[" + LangRes.get((String)"NewThreadDumpHandler_10", (String)"Thread Information", (Object[])new Object[0]) + "]</div>";
        String content = "<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + LangRes.get((String)"NewThreadDumpHandler_9", (String)"Instance IP", (Object[])new Object[0]) + ": " + threadDumpInfo.getIp() + ",&nbsp;&nbsp;" + LangRes.get((String)"NewThreadDumpHandler_8", (String)"Microservices", (Object[])new Object[0]) + ": " + threadDumpInfo.getAppName() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + LangRes.get((String)"NewThreadDumpHandler_51", (String)"Thread ID", (Object[])new Object[0]) + ": " + threadDumpInfo.getThreadId() + "</div>";
        if (StringUtils.isNotEmpty((String)threadDumpInfo.getStartTime())) {
            content = content + "<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + LangRes.get((String)"ThreadDumpHandler_1", (String)"Startup Time", (Object[])new Object[0]) + ": " + threadDumpInfo.getStartTime() + ",&nbsp;&nbsp;" + LangRes.get((String)"ThreadDumpHandler_2", (String)"Already Running", (Object[])new Object[0]) + ": " + NewThreadDumpHandler.convertMillisToTimeFormat(threadDumpInfo.getDuration()) + (StringUtils.isEmpty((String)threadDumpInfo.getClientUrl()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;URL: " + threadDumpInfo.getClientUrl()) + (StringUtils.isEmpty((String)threadDumpInfo.getUserName()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;UserName: " + this.cleanXss(threadDumpInfo.getUserName())) + (StringUtils.isEmpty((String)threadDumpInfo.getTenantId()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;TenantId: " + threadDumpInfo.getTenantId()) + (StringUtils.isEmpty((String)threadDumpInfo.getFormId()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;FormId: " + threadDumpInfo.getFormId()) + (StringUtils.isEmpty((String)threadDumpInfo.getAction()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Action: " + threadDumpInfo.getAction()) + "</div>" + (threadDumpInfo.getThreadTraceStatList() == null || threadDumpInfo.getThreadTraceStatList().size() == 0 ? "" : "<div class=\"line2\">&nbsp;&nbsp;[" + LangRes.get((String)"ThreadDumpHandler_5", (String)"Thread Statistics", (Object[])new Object[0]) + "]</div>" + this.getFormatThreadTraceStat(threadDumpInfo.getThreadTraceStatList()));
        }
        return info + content;
    }

    private String cleanXss(String message) {
        if (!StringUtils.isEmpty((String)message)) {
            message = message.replaceAll("'", "&#39;");
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
            message = message.replaceAll("\"", "&quot;");
            message = message.replaceAll("'", "&#x27;");
            message = message.replaceAll("/", "&#x2f;");
        }
        return message;
    }

    private String getFormatThreadTraceStat(List<TraceStatistics.ThreadTraceStat> threadTraceStatList) {
        StringBuilder content = new StringBuilder();
        for (TraceStatistics.ThreadTraceStat threadTraceStat : threadTraceStatList) {
            content.append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(threadTraceStat.getType()).append(": ").append(LangRes.get((String)"NewThreadDumpHandler_1", (String)"Number of Executions", (Object[])new Object[0])).append(": ").append(threadTraceStat.getExecCount()).append(",&nbsp;&nbsp;").append(LangRes.get((String)"NewThreadDumpHandler_2", (String)"Total Time", (Object[])new Object[0])).append(": ").append(NewThreadDumpHandler.convertMillisToTimeFormat(String.valueOf(threadTraceStat.getTotalDuration()))).append(",&nbsp;&nbsp;").append(LangRes.get((String)"NewThreadDumpHandler_3", (String)"Average Time", (Object[])new Object[0])).append(": ").append(NewThreadDumpHandler.convertMillisToTimeFormat(String.valueOf(threadTraceStat.getAvgDuration()))).append("<br>").append(threadTraceStat.getCustomExtendStatictics()).append("</div>");
        }
        return content.toString();
    }

    private String getFormatMemSpanInfo(String userPermission, ThreadDumpInfo threadDumpInfo) {
        List<ThreadInfo.MemSpanInfo> memSpanInfoList = threadDumpInfo.getMemSpanInfoList();
        if (memSpanInfoList.isEmpty()) {
            return "";
        }
        long threadId = threadDumpInfo.getThreadId();
        String threadName = threadDumpInfo.getThreadName();
        String traceId = threadDumpInfo.getTraceId();
        String ip = threadDumpInfo.getIp();
        String monitorPort = threadDumpInfo.getMonitorPort();
        StringBuilder content = new StringBuilder();
        for (ThreadInfo.MemSpanInfo memSpanInfo : memSpanInfoList) {
            List<KeyValueEntity> details;
            String btnId = UUID.randomUUID().toString().split("-")[0];
            content.append("<div class=\"line2\">&nbsp;&nbsp;[").append(LangRes.get((String)"ThreadDumpHandler_7", (String)"Current Method", (Object[])new Object[0])).append("]</div> ").append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(LangRes.get((String)"ThreadDumpHandler_8", (String)"Start Time", (Object[])new Object[0])).append(": ").append(memSpanInfo.getMethodStartTime()).append(",&nbsp;&nbsp;").append(LangRes.get((String)"ThreadDumpHandler_9", (String)"Executed", (Object[])new Object[0])).append(": ").append(NewThreadDumpHandler.convertMillisToTimeFormat(memSpanInfo.getMethodDuration())).append("</div>").append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(LangRes.get((String)"ThreadDumpHandler_11", (String)" Executing Method", (Object[])new Object[0])).append(": ");
            if (memSpanInfo.getExecuteMethod().contains("[")) {
                content.append(memSpanInfo.getExecuteMethod(), 0, memSpanInfo.getExecuteMethod().indexOf("[")).append("<a id=").append(btnId).append(" href=\"javascript:void(0);\" onclick=\"openModal(this.id)\" style=\"color: #409eff;\">&nbsp;&nbsp;(").append(LangRes.get((String)"ThreadDumpHandler_13", (String)"View", (Object[])new Object[0])).append(")&nbsp;&nbsp;</a>").append("<div id=").append(btnId).append("-modal class=\"modal\"><div class=\"modal-content\"><span id=").append(btnId).append("-span class=\"close\">&times;</span><div>").append(LangRes.get((String)"ThreadDumpHandler_11", (String)"Executing Method", (Object[])new Object[0])).append("</div><div>").append(NewThreadDumpHandler.replaceLinkIpPort(memSpanInfo.getExecuteMethod())).append("</div></div></div></div>");
            } else if (StringUtils.isNotEmpty((String)traceId) && threadDumpInfo.isSupportTerminationSql() && StringUtils.isNotEmpty((String)threadDumpInfo.getDuration()) && Long.parseLong(threadDumpInfo.getDuration()) >= threadDumpInfo.getAfterTimeShow() * 1000L && StringUtils.isNotEmpty((String)userPermission) && userPermission.contains("threadAnalyse-killSqlMethod") && memSpanInfo.getExecuteMethod().contains("jdbc")) {
                String escapedSql = StringEscapeUtils.escapeJavaScript((String)String.valueOf(memSpanInfo.getDetails().get(0).getValue()).replace("\"", "'"));
                content.append(memSpanInfo.getExecuteMethod()).append(" <a id=").append(btnId).append(" href=\"javascript:void(0);\" onclick=\"stopSqlMethod('").append(LangRes.get((String)"ThreadDumpHandler_17", (String)"stopSqlMethodConfirmationPrompt", (Object[])new Object[0])).append("', '").append(Instance.getClusterName()).append("', '").append(threadName).append("', '").append(threadId).append("', '").append(traceId).append("', '").append(ip).append("', '").append(monitorPort).append("', '").append(escapedSql).append("', '").append(memSpanInfo.getMethodDuration()).append("')\"").append(" style=\"color: #ff0000;\"> ( ").append(LangRes.get((String)"ThreadDumpHandler_15", (String)"StopMethod", (Object[])new Object[0])).append(" ) </a>");
            } else {
                content.append(memSpanInfo.getExecuteMethod()).append("</div>");
            }
            if ((details = memSpanInfo.getDetails()).size() == 0) continue;
            for (KeyValueEntity detail : details) {
                if ("service".equals(detail.getKey())) continue;
                content.append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append("[").append(detail.getKey()).append("]: ").append(NewThreadDumpHandler.replaceLinkIpPort(detail.getValue().toString())).append("</div>");
            }
        }
        return content.toString();
    }

    private String getFormatStackTrace(ThreadDumpInfo threadDumpInfo) {
        List<String> stackTraceList = threadDumpInfo.getStackTraceInfoList();
        if (stackTraceList.isEmpty()) {
            return "";
        }
        StringBuilder formatStackTrace = new StringBuilder();
        formatStackTrace.append("<div class=\"line2\">&nbsp;&nbsp;[").append(LangRes.get((String)"ThreadDumpHandler_12", (String)"Thread Stack", (Object[])new Object[0])).append("]</div>");
        int line = 20;
        String divId = UUID.randomUUID().toString().split("-")[0];
        for (String stackTrace : stackTraceList) {
            formatStackTrace.append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;at ").append(stackTrace).append("</div>");
            if (--line != 0) continue;
            formatStackTrace.append("<div id=hide-").append(divId).append(" name='hide' style=\"display: none\">");
        }
        if (line <= 0) {
            formatStackTrace.append("</div>&nbsp;&nbsp;<a class=\"review\" href=\"javascript:void(0);\" style=\"font-size:14px;\" onclick=\"showMore(this.id)\" id=more-").append(divId).append(" name='more'>").append(LangRes.get((String)"ThreadDumpHandler_14", (String)"Expand", (Object[])new Object[0])).append("</a><br>");
        }
        return formatStackTrace.toString();
    }

    private List<ThreadDumpInfo> getAllRemoteThreadDumpInfo(String ip, String traceId, String ipAndPort, HttpExchange exchange) {
        ThreadDumpInfo headRemoteThread = this.getRemoteThreadDumpInfo(ip, traceId, ipAndPort, exchange);
        if (headRemoteThread == null) {
            return null;
        }
        ArrayList<ThreadDumpInfo> threadDumpInfoList = new ArrayList<ThreadDumpInfo>(3);
        threadDumpInfoList.add(headRemoteThread);
        ThreadDumpInfo tempRemoteThread = headRemoteThread;
        while (tempRemoteThread != null && tempRemoteThread.getRemoteIPAndPort() != null) {
            String tempIpAndPort = tempRemoteThread.getRemoteIPAndPort();
            String tempIp = tempIpAndPort.split(":")[0];
            ThreadDumpInfo nextRemoteThread = this.getRemoteThreadDumpInfo(tempIp, traceId, tempIpAndPort, exchange);
            if (nextRemoteThread != null) {
                threadDumpInfoList.add(nextRemoteThread);
            }
            tempRemoteThread = nextRemoteThread;
        }
        return threadDumpInfoList;
    }

    private List<String> getRemoteThreadInfoUrl(String ip, String traceId, String ipAndPort, HttpExchange exchange) {
        String remoteThreadInfoUrl = null;
        List<NodeInfo> nodeInfoList = NewRemoteThreadHandler.getRemoteNodeInfo(ip);
        if (nodeInfoList.isEmpty()) {
            return null;
        }
        ArrayList<String> remoteThreadInfoUrlList = new ArrayList<String>(3);
        Locale locale = LangUtil.tryGetLocal((HttpExchange)exchange);
        for (NodeInfo nodeInfo : nodeInfoList) {
            remoteThreadInfoUrl = nodeInfo.getMonitorUrl(false) + "/monitor/eye/newthreaddumpproxy?proxyurl=/monitor/eye/proxy&ip=" + ip + "&appname=" + nodeInfo.getAppName() + "&threadname=" + "RpcRequest" + "&traceId=" + traceId + "&key=" + ipAndPort + (locale == null ? "" : "&monitor_language=" + locale.toString());
            remoteThreadInfoUrlList.add(remoteThreadInfoUrl);
        }
        return remoteThreadInfoUrlList;
    }

    private static List<NodeInfo> getRemoteNodeInfo(String ip) {
        ArrayList<NodeInfo> nodeInfoList = new ArrayList<NodeInfo>(3);
        try {
            Map nodesMap = ClusterInstances.getAllOriginNodesString();
            for (Map.Entry entry : nodesMap.entrySet()) {
                String value = (String)entry.getValue();
                NodeInfo nodeInfo = (NodeInfo)JSONUtils.cast((String)value, NodeInfo.class, (boolean)true);
                if (nodeInfo == null || !ip.contains(nodeInfo.getIp())) continue;
                nodeInfoList.add(nodeInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodeInfoList;
    }

    private ThreadDumpInfo getRemoteThreadDumpInfo(String ip, String traceId, String ipAndPort, HttpExchange exchange) {
        List<String> remoteThreadInfoUrlList = this.getRemoteThreadInfoUrl(ip, traceId, ipAndPort, exchange);
        if (remoteThreadInfoUrlList == null || remoteThreadInfoUrlList.isEmpty()) {
            return null;
        }
        AllThreadDumpInfo allThreadDumpInfo = null;
        try {
            String remoteThreadInfoUrl;
            String remoteThreadInfoJson;
            Iterator<String> iterator = remoteThreadInfoUrlList.iterator();
            while (iterator.hasNext() && ((allThreadDumpInfo = this.castThreadDumpInfoJsonToThreadDumpInfo(remoteThreadInfoJson = this.getThreadDumpInfoJsonFromUrl(remoteThreadInfoUrl = iterator.next()))) == null || allThreadDumpInfo.getThreadDumpInfoList().isEmpty())) {
            }
        }
        catch (Exception e) {
            logger.error("JSON cast to AllThreadDumpInfo Object is failed. ERROR INFO: ", (Throwable)e);
        }
        return allThreadDumpInfo == null || allThreadDumpInfo.getThreadDumpInfoList().isEmpty() ? null : allThreadDumpInfo.getThreadDumpInfoList().get(0);
    }

    private String getThreadDumpInfoJsonFromUrl(String accessUrlOfNodeInfo) throws Exception {
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        try {
            return HttpClients.get(accessUrlOfNodeInfo, proxyHeader, 5000, readtimeout * 1000);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private AllThreadDumpInfo castThreadDumpInfoJsonToThreadDumpInfo(String allThreadDumpInfoJSON) throws Exception {
        AllThreadDumpInfo allThreadDumpInfo = null;
        if (allThreadDumpInfoJSON != null) {
            try {
                allThreadDumpInfo = (AllThreadDumpInfo)JSONUtils.cast((String)allThreadDumpInfoJSON, AllThreadDumpInfo.class);
            }
            catch (IOException e) {
                logger.error("JSON cast to AllThreadDumpInfo Object is failed. ERROR INFO: ", (Throwable)e);
                throw new Exception(e);
            }
        }
        return allThreadDumpInfo;
    }
}

