/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.config.manager.UnifiedConfigHookService;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.util.StringUtils;

public class ThreadDumpParamHook
implements UnifiedConfigHookService {
    public static final String MONITOR_THREADDUMP_TERMINATION_SHOWTIME = "monitor.threaddump.termination.showtime";
    private static Map paramMap = new ConcurrentHashMap(1);

    public static void registerHook() {
        ThreadDumpParamHook threadDumpParamHook = new ThreadDumpParamHook();
        UnifiedConfigManager.registHookService(ConfigModule.THREAD_DUMP.getNumber(), MONITOR_THREADDUMP_TERMINATION_SHOWTIME, threadDumpParamHook);
    }

    @Override
    public String beforeSave(String key, UnifiedConfigManager.ConfigParam configParam) {
        String value = configParam.getValue();
        if (StringUtils.isEmpty((String)value)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"the param monitor.threaddump.termination.showtime can not be null!"});
        }
        if (StringUtils.isNumberString((String)value)) {
            int showtime = Integer.parseInt(value);
            if (showtime <= 0) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"the param monitor.threaddump.termination.showtime must be a Positive number!"});
            }
        } else {
            throw new KDException(BosErrorCode.bOS, new Object[]{"the param monitor.threaddump.termination.showtime must be a Positive number!"});
        }
        return null;
    }

    @Override
    public void afterSave(String key, UnifiedConfigManager.ConfigParam configParam) {
        paramMap.put(key, configParam.getValue());
    }

    public static String getValue(String key) {
        return (String)paramMap.computeIfAbsent(key, k -> ThreadDumpParamHook.queryFromDatabase((String)k));
    }

    private static String queryFromDatabase(String key) {
        return ConfigDbHelper.getValueByKey(key);
    }
}

