/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kd.bos.eye.api.common.entity.KeyValueEntity;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.thread.NewThreadDumpHandler;
import kd.bos.eye.api.thread.ThreadInfo;
import kd.bos.eye.api.thread.entity.AllThreadDumpInfo;
import kd.bos.eye.api.thread.entity.NodeInfo;
import kd.bos.eye.api.thread.entity.ThreadDumpInfo;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.eye.util.HttpClients;
import kd.bos.eye.util.StringFormatUtils;
import kd.bos.eye.util.ThreadDumpUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangContext;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangUtil;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ThreadMonitor
extends AbstractHttpHandler {
    private static final String PROXY_HEADER_KEY = EyeProxyHandler.PROXY_HEADER_KEY;
    private static final Log logger = LogFactory.getLog(ThreadMonitor.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String PROXY_HEADER_VALUE = EyeProxyHandler.PROXY_HEADER_VALUE;
    private static final int READ_TIME_OUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    private static final List<Set<String>> EXCEPTION_NODES = new ArrayList<Set<String>>();
    private String appNameParam = "*";
    private String ipParam = "*";
    private int selected = 12;
    private String keyParam = "";
    private String excludeKeyParam = "";
    private int rowParam = 20;
    private boolean isOpenParam = false;
    private boolean isLiveParam = false;
    private boolean webThreadParam = false;
    private boolean serviceThreadParam = false;
    private boolean MQconsumerThreadParam = false;
    String CSS_threadMonitor = "<style>\n    .modal {\n        display: none;\n        position: fixed;\n        z-index: 1;\n        padding-top: 100px;\n        left: 0;\n        top: 0;\n        width: 100%;\n        height: 100%;\n        overflow: auto;\n        background-color: rgb(0,0,0);\n        background-color: rgba(0,0,0,0.4);\n    }\n    .modal-content {\n        background-color: #fefefe;\n        margin: auto;\n        padding: 20px;\n        border: 1px solid #888;\n        width: 60%;\n    }\n    .close {\n        color: #aaaaaa;\n        float: right;\n        font-size: 28px;\n        font-weight: bold;\n    }\n    .close:hover,\n    .close:focus {\n        color: #000;\n        text-decoration: none;\n        cursor: pointer;\n    }\n    .go-top {\n        position: fixed;\n        bottom: 20px;\n        right: 20px;\n    }  \n    .go-top a {\n        display: block;\n        text-decoration: none;\n        color: white;\n        background-color: #409eff;\n        border: 1px solid #ccc;\n        padding: 5px 5px;\n        border-radius: 5px;\n        letter-spacing: 2px;\n    }    .go-top a:hover {\n        color: white;\n        background-color:#66b1ff;\n        box-shadow: 0 2px 2px 0 rgba(0,0,0,0.24),0 5px 5px 0 rgba(0,0,0,0.19);\n    }  \n    .search {\n        color: white;\n        background-color:#409eff;\n        border-radius:4px;\n        border: 1px solid #409eff;\n    }  \n    .search:hover {\n        color: white;\n        background-color:#66b1ff;\n        border-radius:4px;\n        border: 1px solid #66b1ff;\n    }  \n    .review:link {\n        color: #409eff;\n    }  \n    .review:visited {\n        color: #8f31a7;\n    }  \n    .review:hover {\n        color: #8f31a7;\n    }  \n    .review:active {\n        color: red;\n    }  \n    .review1:link {\n        color: #409eff;\n    }  \n    .review1:visited {\n        color: #409eff;\n    }  \n    .review1:hover {\n        color: #8f31a7;\n    }  \n    .review1:active {\n        color: red;\n    }  \n    .line1 {\n        color: black;\n        font-weight:bold;\n        font-size:15px;\n    }  \n    .line2 {\n        color: #409eff;\n        font-weight:bold;\n        font-size:14px;\n    }  \n    .line3 {\n        color: black;\n        font-weight:350;\n        font-size:14px;\n        line-height: 23px;\n    }  \n</style>";
    private static final String SCRIPT = "<script>\n    function getIP(appName) {\n        var url = \"./threadmonitor?ajaxAppName=\" + appName;\n        ajaxGet(url, function (response) {\n            var ipNode = document.getElementById(\"ip\");\n            ipNode.options.length = 1;\n            ipJSON = JSON.parse(response);\n            var ipList = ipJSON.ips;\n            var exceptionIpList = ipJSON.exceptionIps;\n            for (var i = 0; i < ipList.length; i++) {\n                var textNode = document.createTextNode(ipList[i]);\n                var optionNode = document.createElement(\"option\");\n                if (isExceptionIp(ipList[i], exceptionIpList)) {\n                    optionNode.style.color = \"red\";\n                }\n                optionNode.appendChild(textNode);\n                ipNode.appendChild(optionNode);\n            }\n        });\n\n        function isExceptionIp(ip, exceptionIpList) {\n            var flag = false;\n            for (var i = 0; i < exceptionIpList.length; i++) {\n                if (ip === exceptionIpList[i]) {\n                    flag = true;\n                    break;\n                }\n            }\n            return flag;\n        }\n    }\n    function ajaxGet(url, callback) {\n        var xhr = new XMLHttpRequest();\n        xhr.open('GET', url, true);\n        xhr.send();\n        xhr.onreadystatechange = function () {\n            if (xhr.readyState === 4 && xhr.status === 202) {\n                callback(xhr.responseText);\n            }\n        }\n    }\nfunction showMore(id) {\n    var hide = \"hide\" + id.substring(4)\n    var more = document.getElementById(id)\n    document.getElementById(hide).style.display = \"block\"\n    more.innerHTML = \"@%0%\";\n    more.href = \"javascript:void(0);\"\n    more.setAttribute(\"onclick\", \"showLess(id)\")\n    more.setAttribute(\"name\", \"less\")\n}\nfunction showLess(id) {\n    var hide = \"hide\" + id.substring(4)\n    var less = document.getElementById(id)\n    document.getElementById(hide).style.display = \"none\";\n    less.innerHTML = \"@%1%\";\n    less.href = \"javascript:void(0);\"\n    less.setAttribute(\"onclick\", \"showMore(id)\")\n    less.setAttribute(\"name\", \"more\")\n}\nfunction showAllMore() {\n    var nodeList = document.getElementsByName(\"hide\")\n    var moreNodeList = document.getElementsByName(\"more\")\n    var moreList = []\n    for (const more of moreNodeList) {\n        moreList.push(more)\n    }\n    for (const node of nodeList) {\n        node.style.display = \"block\"\n    }\n    for (const more of moreList) {\n        more.innerHTML = \"@%0%\"\n        more.href = \"javascript:void(0);\"\n        more.setAttribute(\"onclick\", \"showLess(id)\")\n        more.setAttribute(\"name\", \"less\")\n    }\n}\nfunction showAllLess() {\n    var nodeList = document.getElementsByName(\"hide\")\n    var lessNodeList = document.getElementsByName(\"less\")\n    var lessList = []\n    for (const less of lessNodeList) {\n        lessList.push(less)\n    }\n    for (const node of nodeList) {\n        node.style.display = \"none\"\n    }\n    for (const less of lessList) {\n        less.innerHTML = \"@%1%\";\n        less.href = \"javascript:void(0);\"\n        less.setAttribute(\"onclick\", \"showMore(id)\")\n        less.setAttribute(\"name\", \"more\")\n    }\n}function openModal(id) {\n        var modalId = id + \"-modal\";\n        var spanId = id + \"-span\";\n        var modal = document.getElementById(modalId);\n        var span = document.getElementById(spanId);\n\n        modal.style.display = \"block\";\n        span.onclick = function() {\n            modal.style.display = \"none\";\n        }\n        window.onclick = function(event) {\n            if (event.target === modal) {\n                modal.style.display = \"none\";\n            }\n        }\n    }\nfunction getRemote(id, traceId, ipAndPort){\n    var div = document.getElementById(id);\n    var url = \"./newremotethreaddump?traceId=\" + traceId + \"&ipAndPort=\" + ipAndPort;\n    ajaxGet(url, function (response) {\n        div.innerHTML = response;\n    });\n}</script>";
    private static final String FLOAT = "<div class=\"go-top\">\n    <a href=\"#\">@%0%</a>\n    <a href=\"javascript:void(0)\" onClick=\"showAllMore()\">@%1%</a>\n    <a href=\"javascript:void(0)\" onClick=\"showAllLess()\">@%2%</a>\n</div>";

    private static String getLocalScript() {
        String collapse = LangRes.get((String)"NewThreadDumpHandler_21", (String)"Collapse", (Object[])new Object[0]);
        String expand = LangRes.get((String)"NewThreadDumpHandler_22", (String)"Expand", (Object[])new Object[0]);
        return StringFormatUtils.format(SCRIPT, collapse, expand);
    }

    private static String getLocalFloat() {
        String backTop = LangRes.get((String)"NewThreadDumpHandler_23", (String)"Back to top", (Object[])new Object[0]);
        String expandAll = LangRes.get((String)"NewThreadDumpHandler_24", (String)"Expand All", (Object[])new Object[0]);
        String collapseAll = LangRes.get((String)"NewThreadDumpHandler_25", (String)"Collapse All", (Object[])new Object[0]);
        return StringFormatUtils.format(FLOAT, backTop, expandAll, collapseAll);
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ArrayList<NodeInfo> nodeInfoList = ThreadDumpUtil.getSortedNodeInfos();
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        String ajaxAppName = params.get("ajaxAppName");
        String appName = params.get("appname");
        if (appName == null) {
            appName = nodeInfoList.size() > 10 ? ((NodeInfo)nodeInfoList.get(0)).getAppName() : "*";
        }
        String ip = params.get("ip") == null ? "*" : params.get("ip");
        String isWebNode = params.get("isWebNode") == null ? "" : params.get("isWebNode");
        String key = params.get("key") == null ? "" : params.get("key");
        String excludeKey = params.get("excludeKey") == null ? "" : params.get("excludeKey");
        this.appNameParam = appName;
        this.ipParam = ip;
        this.keyParam = key;
        this.excludeKeyParam = excludeKey;
        this.rowParam = this.rowParamToInt(params.get("row"));
        int threaddurationParam = params.get("threadduration") == null ? 0 : Integer.parseInt(params.get("threadduration"));
        this.isOpenParam = params.get("isOpen") != null;
        this.isLiveParam = params.get("isLive") == null;
        this.webThreadParam = params.get("webThread") != null;
        this.serviceThreadParam = params.get("serviceThread") != null;
        this.MQconsumerThreadParam = params.get("MQconsumerThread") != null;
        this.setSelectChecked(exchange);
        if (!StringUtils.isEmpty((String)ajaxAppName)) {
            this.ajaxDropDownHandle(exchange, ajaxAppName);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (appName.equals("*")) {
            List<NodeInfo> filterNodeInfoList = this.getFilteredNodeInfoList(nodeInfoList, appName, ip);
            List<AllThreadDumpInfo> allThreadDumpInfoList = this.asynGetAllThreadDumpInfoList(filterNodeInfoList, exchange);
            List<ThreadDumpInfo> sortedThreadDumpInfoList = this.createSortedThreadDumpInfoList(allThreadDumpInfoList, threaddurationParam, isWebNode);
            List<String> deadLockList = this.createDeadLockList(allThreadDumpInfoList);
            if (sortedThreadDumpInfoList.isEmpty() && deadLockList.isEmpty()) {
                String data = "<font face=\"Helvetica Neue\">" + this.titleToHTML(nodeInfoList, LangRes.get((String)"NewThreadDumpHandler_45", (String)"No data available", (Object[])new Object[0])) + this.deadLockListToHTML(deadLockList) + this.threadDumpInfoListToHTML(sortedThreadDumpInfoList) + (this.isOpenParam ? "<script>showAllMore()</script>" : "") + "</font>";
                stringBuilder.append(data);
            } else {
                String data = "<font face=\"Helvetica Neue\">" + this.titleToHTML(nodeInfoList) + this.deadLockListToHTML(deadLockList) + this.threadDumpInfoListToHTML(sortedThreadDumpInfoList) + (this.isOpenParam ? "<script>showAllMore()</script>" : "") + "</font>";
                stringBuilder.append(data);
            }
        } else {
            String[] appNameArray = appName.split(",");
            String[] ipArray = ip.split(",");
            ArrayList<NodeInfo> filterNodeInfoList = new ArrayList<NodeInfo>();
            for (int i = 0; i < appNameArray.length; ++i) {
                filterNodeInfoList.addAll(this.getFilteredNodeInfoList(nodeInfoList, appNameArray[i], ipArray[i]));
            }
            List<AllThreadDumpInfo> allThreadDumpInfoList = this.asynGetAllThreadDumpInfoList(filterNodeInfoList, exchange);
            List<ThreadDumpInfo> sortedThreadDumpInfoList = this.createSortedThreadDumpInfoList(allThreadDumpInfoList, threaddurationParam, isWebNode);
            List<String> deadLockList = this.createDeadLockList(allThreadDumpInfoList);
            if (sortedThreadDumpInfoList.isEmpty() && deadLockList.isEmpty()) {
                String data = "<font face=\"Helvetica Neue\">" + this.titleToHTML(nodeInfoList, LangRes.get((String)"NewThreadDumpHandler_45", (String)"No data available", (Object[])new Object[0])) + this.deadLockListToHTML(deadLockList) + this.threadDumpInfoListToHTML(sortedThreadDumpInfoList) + (this.isOpenParam ? "<script>showAllMore()</script>" : "") + "</font>";
                stringBuilder.append(data);
            } else {
                String data = "<font face=\"Helvetica Neue\">" + this.titleToHTML(nodeInfoList) + this.deadLockListToHTML(deadLockList) + this.threadDumpInfoListToHTML(sortedThreadDumpInfoList) + (this.isOpenParam ? "<script>showAllMore()</script>" : "") + "</font>";
                stringBuilder.append(data);
            }
        }
        this.sendResponse(exchange, stringBuilder.toString());
    }

    private void ajaxDropDownHandle(HttpExchange exchange, String ajaxAppName) {
        ArrayList<NodeInfo> nodeInfoList = ThreadDumpUtil.getSortedNodeInfos();
        Multimap<String, String> appNameAndIpMultimap = this.createAppNameAndIpMultimap(nodeInfoList);
        List<String> allIpList = this.getAllIpList(nodeInfoList);
        StringBuilder data = new StringBuilder();
        try {
            data.append("{\"ips\": ").append(ajaxAppName.equals("*") ? JSONUtils.toString(allIpList) : JSONUtils.toString((Object)appNameAndIpMultimap.get((Object)ajaxAppName))).append(",\"exceptionIps\":").append(EXCEPTION_NODES.isEmpty() ? "[]" : JSONUtils.toString(EXCEPTION_NODES.get(0))).append("}");
            this.sendResponse(exchange, data.toString());
        }
        catch (IOException e) {
            logger.error("send response is failed.", (Throwable)e);
        }
    }

    private List<NodeInfo> getFilteredNodeInfoList(List<NodeInfo> nodeInfoList, String appName, String ip) {
        Multimap<String, NodeInfo> appNameAndNodeInfoMultimap = this.createAppNameAndNodeInfoMultimap(nodeInfoList);
        if (!ip.equals("*")) {
            ArrayList<NodeInfo> filteredNodeInfoList = new ArrayList<NodeInfo>(1);
            filteredNodeInfoList.add(this.getNodeInfoByIp(ip, nodeInfoList));
            return filteredNodeInfoList;
        }
        if (appName.equals("*")) {
            return nodeInfoList;
        }
        return new ArrayList<NodeInfo>(appNameAndNodeInfoMultimap.get((Object)appName));
    }

    private void sendResponse(HttpExchange exchange, String data) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void addOperateToThreadName(AllThreadDumpInfo allThreadDumpInfo, NodeInfo nodeInfo) {
        List<ThreadDumpInfo> threadDumpInfoList = allThreadDumpInfo.getThreadDumpInfoList();
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            if (threadDumpInfo.getTraceId() != null) {
                threadDumpInfo.setShowThreadName(threadDumpInfo.getShowThreadName() + " ( <a class=\"review\" href=./#/logQuery-new?appName=" + nodeInfo.getAppName() + "&instanceId=" + nodeInfo.getInstanceId() + "&traceId=" + threadDumpInfo.getTraceId() + " target=_blank>" + LangRes.get((String)"NewThreadDumpHandler_11", (String)"View Log", (Object[])new Object[0]) + "</a> ) ( <a class=\"review\" href=./#/trace-new?showFoldHeader=false&showFoldIcon=false&traceId=" + threadDumpInfo.getTraceId() + " target=_blank>" + LangRes.get((String)"NewThreadDumpHandler_13", (String)"View Call Chain", (Object[])new Object[0]) + "</a> ) ( <a class=\"review\" href=./ShowThreadDumpInfo?appname=" + threadDumpInfo.getAppName() + "&ip=" + threadDumpInfo.getIp() + "&key=" + threadDumpInfo.getShowThreadName() + " target=_blank>" + LangRes.get((String)"NewThreadDumpHandler_14", (String)"Open in a New Window to View", (Object[])new Object[0]) + "</a> )");
                continue;
            }
            threadDumpInfo.setShowThreadName(threadDumpInfo.getShowThreadName() + " ( <a class=\"review\" href=./ShowThreadDumpInfo?appname=" + threadDumpInfo.getAppName() + "&ip=" + threadDumpInfo.getIp() + "&key=" + threadDumpInfo.getThreadName() + " target=_blank>" + LangRes.get((String)"NewThreadDumpHandler_14", (String)"Open in a New Window to View", (Object[])new Object[0]) + "</a> )");
        }
    }

    private void setSelectChecked(HttpExchange exchange) {
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        int value = 8;
        int live = 4;
        int webRequest = 2;
        int service = 1;
        if (params.get("live") != null && params.get("live").equals("true")) {
            value |= live;
        }
        if (params.get("threadname") != null && params.get("threadname").contains("http-request-pool")) {
            value |= webRequest;
        }
        if (params.get("threadname") != null && params.get("threadname").contains("RpcRequest")) {
            value |= service;
        }
        if (params.get("live") == null && params.get("threadname") == null) {
            value = 12;
        }
        if (params.get("threadname") != null && (params.get("threadname").contains("MQConsumerChannelMonitor") || params.get("threadname").contains("RabbitMqAsyncConsumer"))) {
            value = 6;
        }
        if (params.get("live") != null && params.get("live").equals("true") && params.get("threadname") != null && (params.get("threadname").contains("MQConsumerChannelMonitor") || params.get("threadname").contains("RabbitMqAsyncConsumer"))) {
            value = 7;
        }
        this.selected = value;
    }

    private List<ThreadDumpInfo> createSortedThreadDumpInfoList(List<AllThreadDumpInfo> allThreadDumpInfoList, int threaddurationParam, String isWebNode) {
        ArrayList<ThreadDumpInfo> threadDumpInfoList = new ArrayList<ThreadDumpInfo>();
        for (AllThreadDumpInfo allThreadDumpInfo : allThreadDumpInfoList) {
            if (allThreadDumpInfo == null) continue;
            threadDumpInfoList.addAll(allThreadDumpInfo.getThreadDumpInfoList());
        }
        threadDumpInfoList.sort((o1, o2) -> {
            if (o1.getDuration().equals("") && o2.getDuration().equals("")) {
                return 0;
            }
            if (o1.getDuration().equals("")) {
                return 1;
            }
            if (o2.getDuration().equals("")) {
                return -1;
            }
            return (int)(Long.parseLong(o2.getDuration()) - Long.parseLong(o1.getDuration()));
        });
        if (!isWebNode.isEmpty()) {
            for (int i = threadDumpInfoList.size() - 1; i >= 0; --i) {
                if (!isWebNode.contains(((ThreadDumpInfo)threadDumpInfoList.get(i)).getIp()) || !((ThreadDumpInfo)threadDumpInfoList.get(i)).getThreadName().toLowerCase().contains("http-request-pool")) continue;
                threadDumpInfoList.remove(i);
            }
        }
        if (threaddurationParam > 0) {
            for (int i = threadDumpInfoList.size() - 1; i >= 0; --i) {
                if (((ThreadDumpInfo)threadDumpInfoList.get(i)).getDuration().equals("") || ((ThreadDumpInfo)threadDumpInfoList.get(i)).getDuration() == null) {
                    threadDumpInfoList.remove(i);
                    continue;
                }
                int duration = Integer.parseInt(((ThreadDumpInfo)threadDumpInfoList.get(i)).getDuration());
                if (duration >= threaddurationParam) continue;
                threadDumpInfoList.remove(i);
            }
        }
        int index = 1;
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            threadDumpInfo.setShowThreadName(index + "." + threadDumpInfo.getShowThreadName());
            ++index;
        }
        return threadDumpInfoList;
    }

    private List<String> createDeadLockList(List<AllThreadDumpInfo> allThreadDumpInfoList) {
        ArrayList<String> deadLockList = new ArrayList<String>();
        for (AllThreadDumpInfo allThreadDumpInfo : allThreadDumpInfoList) {
            if (allThreadDumpInfo == null || allThreadDumpInfo.getDeadLockList() == null) continue;
            deadLockList.addAll(allThreadDumpInfo.getDeadLockList());
        }
        return deadLockList;
    }

    private String getAccessUrlOfNodeInfo(HttpExchange exchange, NodeInfo nodeInfo) {
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        boolean live = false;
        if (params.get("live") == null) {
            live = true;
        } else if (params.get("live").equals("true")) {
            live = true;
        }
        String threadName = params.get("threadname") == null ? "" : params.get("threadname");
        String key = params.get("key") == null ? "" : params.get("key");
        String excludeKey = params.get("excludeKey") == null ? "" : params.get("excludeKey");
        Locale locale = LangUtil.tryGetLocal((HttpExchange)exchange);
        return nodeInfo.getMonitorUrl(false) + "/monitor/eye/newthreaddumpproxy?proxyurl=/monitor/eye/proxy&appname=" + nodeInfo.getAppName() + "&ip=" + nodeInfo.getIp() + (live ? "&live=true" : "&live=false") + "&threadname=" + threadName + "&key=" + key + "&excludeKey=" + excludeKey + (locale == null ? "" : "&monitor_language=" + locale.toString());
    }

    private Multimap<String, String> createAppNameAndIpMultimap(List<NodeInfo> nodeInfoList) {
        ArrayListMultimap appNameAndIpMultimap = ArrayListMultimap.create();
        for (NodeInfo nodeInfo : nodeInfoList) {
            appNameAndIpMultimap.put((Object)nodeInfo.getAppName(), (Object)nodeInfo.getIp());
        }
        return appNameAndIpMultimap;
    }

    private Multimap<String, NodeInfo> createAppNameAndNodeInfoMultimap(List<NodeInfo> nodeInfoList) {
        ArrayListMultimap appNameAndIpMultimap = ArrayListMultimap.create();
        for (NodeInfo nodeInfo : nodeInfoList) {
            appNameAndIpMultimap.put((Object)nodeInfo.getAppName(), (Object)nodeInfo);
        }
        return appNameAndIpMultimap;
    }

    private NodeInfo getNodeInfoByIp(String ip, List<NodeInfo> nodeInfoList) {
        for (NodeInfo nodeInfo : nodeInfoList) {
            if (!ip.equals(nodeInfo.getIp())) continue;
            return nodeInfo;
        }
        return null;
    }

    private List<String> getAllIpList(List<NodeInfo> nodeInfoList) {
        ArrayList<String> allIpList = new ArrayList<String>(nodeInfoList.size());
        for (NodeInfo nodeInfo : nodeInfoList) {
            allIpList.add(nodeInfo.getIp());
        }
        return allIpList;
    }

    private HashSet<String> getAppNameSet(List<NodeInfo> nodeInfoList) {
        HashSet<String> appNameSet = new HashSet<String>();
        for (NodeInfo nodeInfo : nodeInfoList) {
            appNameSet.add(nodeInfo.getAppName());
        }
        return appNameSet;
    }

    private String getThreadDumpInfoJsonFromUrl(String accessUrlOfNodeInfo) throws Exception {
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        try {
            return HttpClients.get(accessUrlOfNodeInfo, proxyHeader, 5000, READ_TIME_OUT * 1000);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private AllThreadDumpInfo castThreadDumpInfoJsonToThreadDumpInfo(String allThreadDumpInfoJSON) throws Exception {
        AllThreadDumpInfo allThreadDumpInfo = null;
        if (allThreadDumpInfoJSON != null) {
            try {
                allThreadDumpInfo = (AllThreadDumpInfo)JSONUtils.cast((String)allThreadDumpInfoJSON, AllThreadDumpInfo.class);
            }
            catch (IOException e) {
                logger.error("JSON cast to AllThreadDumpInfo Object is failed. ERROR INFO: ", (Throwable)e);
                throw new Exception(e);
            }
        }
        return allThreadDumpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AllThreadDumpInfo> asynGetAllThreadDumpInfoList(List<NodeInfo> filterNodeInfoList, HttpExchange exchange) {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        CountDownLatch countDownLatch = new CountDownLatch(filterNodeInfoList.size());
        CopyOnWriteArrayList<AllThreadDumpInfo> allThreadDumpInfoList = new CopyOnWriteArrayList<AllThreadDumpInfo>();
        HashSet exceptionNodes = new HashSet();
        if (EXCEPTION_NODES.isEmpty()) {
            EXCEPTION_NODES.add(exceptionNodes);
        } else {
            EXCEPTION_NODES.set(0, exceptionNodes);
        }
        try {
            for (NodeInfo filteredNodeInfo : filterNodeInfoList) {
                executorService.submit(() -> {
                    try {
                        LangContext.setLangContext((HttpExchange)exchange);
                        String accessUrlOfNodeInfo = this.getAccessUrlOfNodeInfo(exchange, filteredNodeInfo);
                        String allThreadDumpInfoJson = this.getThreadDumpInfoJsonFromUrl(accessUrlOfNodeInfo);
                        AllThreadDumpInfo allThreadDumpInfo = this.castThreadDumpInfoJsonToThreadDumpInfo(allThreadDumpInfoJson);
                        if (allThreadDumpInfo != null) {
                            this.addOperateToThreadName(allThreadDumpInfo, filteredNodeInfo);
                            allThreadDumpInfoList.add(allThreadDumpInfo);
                        }
                    }
                    catch (Exception e) {
                        exceptionNodes.add(filteredNodeInfo.getIp());
                        logger.error("Getting allThreadDumpInfoJson is failed. ERROR INFO: ", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                logger.error("Thread of getting threadDumpInfo is interrupted.", (Throwable)e);
            }
        }
        finally {
            executorService.shutdown();
        }
        return allThreadDumpInfoList;
    }

    private String threadDumpInfoListToHTML(List<ThreadDumpInfo> threadDumpInfoList) {
        StringBuilder content = new StringBuilder();
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            String remoteIPAndPort = threadDumpInfo.getRemoteIPAndPort();
            if (remoteIPAndPort == null) {
                content.append("<div class=\"line1\">").append(threadDumpInfo.getShowThreadName()).append("</div>").append(this.getFormatThreadStatisticInfo(threadDumpInfo)).append(this.getFormatMemSpanInfo(threadDumpInfo)).append(this.getFormatStackTrace(threadDumpInfo)).append("<br>");
                continue;
            }
            StringBuilder remoteContent = new StringBuilder();
            String remoteId = UUID.randomUUID().toString().split("-")[0];
            remoteContent.append("<div id=").append(remoteId).append(" style=\"display: flex; align-items: flex-start\">").append("</div>").append("<script> getRemote('").append(remoteId).append("','").append(threadDumpInfo.getTraceId()).append("','").append(threadDumpInfo.getRemoteIPAndPort()).append("')</script>");
            content.append("<div style=\"display: flex; align-items: flex-start\">").append("<div style=\"display: inline-block; width: 900px; word-wrap: break-word\">").append("<div class=\"line1\">").append(threadDumpInfo.getShowThreadName()).append("</div>").append(this.getFormatThreadStatisticInfo(threadDumpInfo)).append(this.getFormatMemSpanInfo(threadDumpInfo)).append(this.getFormatStackTrace(threadDumpInfo)).append("</div>").append((CharSequence)remoteContent).append("</div><br>");
        }
        return content.toString();
    }

    private String getFormatThreadStatisticInfo(ThreadDumpInfo threadDumpInfo) {
        String info = "<div class=\"line2\">&nbsp;&nbsp;[" + LangRes.get((String)"NewThreadDumpHandler_10", (String)"Thread Information", (Object[])new Object[0]) + "]</div>";
        String content = "<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + LangRes.get((String)"NewThreadDumpHandler_9", (String)"Instance IP", (Object[])new Object[0]) + ": " + threadDumpInfo.getIp() + ",&nbsp;&nbsp;" + LangRes.get((String)"NewThreadDumpHandler_8", (String)"Microservices", (Object[])new Object[0]) + ": " + threadDumpInfo.getAppName() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + LangRes.get((String)"NewThreadDumpHandler_51", (String)"Thread ID", (Object[])new Object[0]) + ": " + threadDumpInfo.getThreadId() + "</div>";
        if (StringUtils.isNotEmpty((String)threadDumpInfo.getStartTime())) {
            content = content + "<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + LangRes.get((String)"ThreadDumpHandler_1", (String)"Startup Time", (Object[])new Object[0]) + ": " + threadDumpInfo.getStartTime() + ",&nbsp;&nbsp;" + LangRes.get((String)"ThreadDumpHandler_2", (String)"Already Running", (Object[])new Object[0]) + ": " + NewThreadDumpHandler.convertMillisToTimeFormat(threadDumpInfo.getDuration()) + (StringUtils.isEmpty((String)threadDumpInfo.getClientUrl()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;URL: " + threadDumpInfo.getClientUrl()) + (StringUtils.isEmpty((String)threadDumpInfo.getUserName()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;UserName: " + this.cleanXss(threadDumpInfo.getUserName())) + (StringUtils.isEmpty((String)threadDumpInfo.getTenantId()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;TenantId: " + threadDumpInfo.getTenantId()) + (StringUtils.isEmpty((String)threadDumpInfo.getFormId()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;FormId: " + threadDumpInfo.getFormId()) + (StringUtils.isEmpty((String)threadDumpInfo.getAction()) ? "" : "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Action: " + threadDumpInfo.getAction()) + "</div>" + (threadDumpInfo.getThreadTraceStatList() == null || threadDumpInfo.getThreadTraceStatList().size() == 0 ? "" : "<div class=\"line2\">&nbsp;&nbsp;[" + LangRes.get((String)"ThreadDumpHandler_5", (String)"Thread Statistics", (Object[])new Object[0]) + "]</div>" + this.getFormatThreadTraceStat(threadDumpInfo.getThreadTraceStatList()));
        }
        return info + content;
    }

    private String cleanXss(String message) {
        if (!StringUtils.isEmpty((String)message)) {
            message = message.replaceAll("'", "&#39;");
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
            message = message.replaceAll("\"", "&quot;");
            message = message.replaceAll("'", "&#x27;");
            message = message.replaceAll("/", "&#x2f;");
        }
        return message;
    }

    private String getFormatMemSpanInfo(ThreadDumpInfo threadDumpInfo) {
        List<ThreadInfo.MemSpanInfo> memSpanInfoList = threadDumpInfo.getMemSpanInfoList();
        if (memSpanInfoList.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        for (ThreadInfo.MemSpanInfo memSpanInfo : memSpanInfoList) {
            List<KeyValueEntity> details;
            String btnId = UUID.randomUUID().toString().split("-")[0];
            content.append("<div class=\"line2\">&nbsp;&nbsp;[").append(LangRes.get((String)"ThreadDumpHandler_7", (String)"Current Method", (Object[])new Object[0])).append("]</div> ").append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(LangRes.get((String)"ThreadDumpHandler_8", (String)"Start Time", (Object[])new Object[0])).append(": ").append(memSpanInfo.getMethodStartTime()).append(",&nbsp;&nbsp;").append(LangRes.get((String)"ThreadDumpHandler_9", (String)"Executed", (Object[])new Object[0])).append(": ").append(NewThreadDumpHandler.convertMillisToTimeFormat(memSpanInfo.getMethodDuration())).append("</div>").append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(LangRes.get((String)"ThreadDumpHandler_11", (String)" Executing Method", (Object[])new Object[0])).append(": ");
            if (memSpanInfo.getExecuteMethod().contains("[")) {
                content.append(memSpanInfo.getExecuteMethod(), 0, memSpanInfo.getExecuteMethod().indexOf("[")).append("<a id=").append(btnId).append(" href=\"javascript:void(0);\" onclick=\"openModal(this.id)\" style=\"color: #409eff;\">&nbsp;&nbsp;(").append(LangRes.get((String)"ThreadDumpHandler_13", (String)"View", (Object[])new Object[0])).append(")&nbsp;&nbsp;</a>").append("<div id=").append(btnId).append("-modal class=\"modal\"><div class=\"modal-content\"><span id=").append(btnId).append("-span class=\"close\">&times;</span><div>").append(LangRes.get((String)"ThreadDumpHandler_11", (String)"Executing Method", (Object[])new Object[0])).append("</div><div>").append(NewThreadDumpHandler.replaceLinkIpPort(memSpanInfo.getExecuteMethod())).append("</div></div></div></div>");
            } else {
                content.append(memSpanInfo.getExecuteMethod()).append("</div>");
            }
            if ((details = memSpanInfo.getDetails()).size() == 0) continue;
            for (KeyValueEntity detail : details) {
                if ("service".equals(detail.getKey())) continue;
                content.append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append("[").append(detail.getKey()).append("]: ").append(NewThreadDumpHandler.replaceLinkIpPort(detail.getValue().toString())).append("</div>");
            }
        }
        return content.toString();
    }

    private String getFormatThreadTraceStat(List<TraceStatistics.ThreadTraceStat> threadTraceStatList) {
        StringBuilder content = new StringBuilder();
        for (TraceStatistics.ThreadTraceStat threadTraceStat : threadTraceStatList) {
            content.append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(threadTraceStat.getType()).append(": ").append(LangRes.get((String)"NewThreadDumpHandler_1", (String)"Number of Executions", (Object[])new Object[0])).append(": ").append(threadTraceStat.getExecCount()).append(",&nbsp;&nbsp;").append(LangRes.get((String)"NewThreadDumpHandler_2", (String)"Total Time", (Object[])new Object[0])).append(": ").append(NewThreadDumpHandler.convertMillisToTimeFormat(String.valueOf(threadTraceStat.getTotalDuration()))).append(",&nbsp;&nbsp;").append(LangRes.get((String)"NewThreadDumpHandler_3", (String)"Average Time", (Object[])new Object[0])).append(": ").append(NewThreadDumpHandler.convertMillisToTimeFormat(String.valueOf(threadTraceStat.getAvgDuration()))).append("</div>");
        }
        return content.toString();
    }

    private String getFormatStackTrace(ThreadDumpInfo threadDumpInfo) {
        List<String> stackTraceList = threadDumpInfo.getStackTraceInfoList();
        if (stackTraceList.isEmpty()) {
            return "";
        }
        StringBuilder formatStackTrace = new StringBuilder();
        formatStackTrace.append("<div class=\"line2\">&nbsp;&nbsp;[").append(LangRes.get((String)"ThreadDumpHandler_12", (String)"Thread Stack", (Object[])new Object[0])).append("]</div>");
        int line = this.rowParam;
        String divId = UUID.randomUUID().toString().split("-")[0];
        for (String stackTrace : stackTraceList) {
            formatStackTrace.append("<div class=\"line3\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;at ").append(stackTrace).append("</div>");
            if (--line != 0) continue;
            formatStackTrace.append("<div id=hide-").append(divId).append(" name='hide' style=\"display: none\">");
        }
        if (line <= 0) {
            formatStackTrace.append("</div>&nbsp;&nbsp;<a class=\"review\" href=\"javascript:void(0);\" style=\"font-size:14px;\" onclick=\"showMore(this.id)\" id=more-").append(divId).append(" name='more'>\u5c55\u5f00</a><br>");
        }
        return formatStackTrace.toString();
    }

    private String deadLockListToHTML(List<String> deadLockList) {
        if (deadLockList.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder("<font color=\"red\">Thread DeadLock checked!!!</font><br><br>");
        for (String deadLock : deadLockList) {
            content.append(deadLock);
        }
        return content.toString();
    }

    private String getThreadTypeSelectHTMLNew() {
        String webThread = LangRes.get((String)"NewThreadDumpHandler_27", (String)"Thread Type", (Object[])new Object[0]) + ": <label for=\"webThread\">" + LangRes.get((String)"NewThreadDumpHandler_28", (String)"WEB Thread", (Object[])new Object[0]) + "</label><input type=\"checkbox\" name=\"webThread\" id=\"webThread\" value=\"true\" " + (this.webThreadParam ? "checked" : "") + " style=\"zoom: 150%;\">&nbsp;&nbsp;&nbsp;";
        String serviceThread = "<label for=\"serviceThread\">" + LangRes.get((String)"NewThreadDumpHandler_29", (String)"Service Thread", (Object[])new Object[0]) + "</label><input type=\"checkbox\" name=\"serviceThread\" id=\"serviceThread\" value=\"true\" " + (this.serviceThreadParam ? "checked" : "") + " style=\"zoom: 150%;\">&nbsp;&nbsp;&nbsp;";
        String MQconsumerThread = "<label for=\"MQconsumerThread\">" + LangRes.get((String)"NewThreadDumpHandler_30", (String)"MQ Consumer Thread", (Object[])new Object[0]) + "</label><input type=\"checkbox\" name=\"MQconsumerThread\" id=\"MQconsumerThread\" value=\"true\" " + (this.MQconsumerThreadParam ? "checked" : "") + " style=\"zoom: 150%;\"><br>";
        String threadSelect = webThread + serviceThread + MQconsumerThread;
        String isLive = LangRes.get((String)"NewThreadDumpHandler_31", (String)"Active Thread", (Object[])new Object[0]) + ":<input type=\"checkbox\" name=\"isLive\" id=\"isLive\" value=\"true\" " + (this.isLiveParam ? "checked" : "") + " style=\"zoom: 150%;\">";
        return threadSelect + isLive;
    }

    private String getThreadTypeSelectHTML() {
        String options;
        String select = LangRes.get((String)"NewThreadDumpHandler_7", (String)"Thread Type", (Object[])new Object[0]);
        switch (this.selected) {
            case 8: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false selected>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 10: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false selected>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 14: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true selected>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 9: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false selected>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 13: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true selected>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 11: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false selected>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 15: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true selected>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 6: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false selected>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            case 7: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true selected>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
                break;
            }
            default: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>" + LangRes.get((String)"NewThreadDumpHandler_32", (String)"All Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&live=true selected>" + LangRes.get((String)"NewThreadDumpHandler_33", (String)"All Active Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_34", (String)"All WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_35", (String)"All Active WEB Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=false>" + LangRes.get((String)"NewThreadDumpHandler_36", (String)"All Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + "&live=true>" + LangRes.get((String)"NewThreadDumpHandler_37", (String)"All Active Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=false>" + LangRes.get((String)"NewThreadDumpHandler_38", (String)"All MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=MQConsumerChannelMonitor,RabbitMqAsyncConsumer&live=true>" + LangRes.get((String)"NewThreadDumpHandler_39", (String)"All Active MQ Consumer Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=false>" + LangRes.get((String)"NewThreadDumpHandler_40", (String)"All WEB and Service Thread", (Object[])new Object[0]) + "</option>\n            <option value=true&threadname=" + "RpcRequest" + ",http-request-pool&live=true>" + LangRes.get((String)"NewThreadDumpHandler_41", (String)"All Active WEB and Service Thread", (Object[])new Object[0]) + "</option>\n        </select>";
            }
        }
        return select + options;
    }

    private String titleToHTML(List<NodeInfo> nodeInfoList) {
        StringBuilder appNameSelect;
        List<String> ipList;
        HashSet<String> appNameSet = this.getAppNameSet(nodeInfoList);
        String title = LangRes.get((String)"ThreadDumpAllHandler_1", (String)"Thread Monitoring", (Object[])new Object[0]);
        String APP_NAME = LangRes.get((String)"NewThreadDumpHandler_8", (String)"Microservices", (Object[])new Object[0]);
        String IP = LangRes.get((String)"NewThreadDumpHandler_9", (String)"Instance IP", (Object[])new Object[0]);
        String select = this.getThreadTypeSelectHTML();
        String threadSelect = this.getThreadTypeSelectHTMLNew();
        Multimap<String, String> appNameAndNodeInfoMultimap = this.createAppNameAndIpMultimap(nodeInfoList);
        if (this.appNameParam.equals("*")) {
            ipList = this.getAllIpList(nodeInfoList);
            appNameSelect = new StringBuilder(APP_NAME).append("<select name=appname style=\"width: 160;\" onchange=getIP(this.value)> <option value=* selected=selected>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>");
        } else {
            ipList = new ArrayList<String>(appNameAndNodeInfoMultimap.get((Object)this.appNameParam));
            appNameSelect = new StringBuilder(APP_NAME).append("<select name=appname style=\"width: 160;\" onchange=getIP(this.value)> <option value=*>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>");
        }
        for (String appName : appNameSet) {
            if (appName.equals(this.appNameParam)) {
                appNameSelect.append("<option value=").append(appName).append(" selected=selected>").append(appName).append("</option>");
                continue;
            }
            appNameSelect.append("<option value=").append(appName).append(">").append(appName).append("</option>");
        }
        appNameSelect.append("</select>&nbsp;&nbsp;");
        StringBuilder ipSelect = this.ipParam.equals("*") ? new StringBuilder(IP).append("<select name=ip style=\"width: 160;\" id=ip><option value=* selected=selected>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>") : new StringBuilder(IP).append("<select name=ip style=\"width: 160;\" id=ip><option value=*>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>");
        for (String ip : ipList) {
            if (EXCEPTION_NODES.get(0).contains(ip)) {
                if (ip.equals(this.ipParam)) {
                    ipSelect.append("<option style=\"color: red\" value=").append(ip).append(" selected=selected>").append(ip).append("</option>");
                    continue;
                }
                ipSelect.append("<option style=\"color: red\" value=").append(ip).append(">").append(ip).append("</option>");
                continue;
            }
            if (ip.equals(this.ipParam)) {
                ipSelect.append("<option value=").append(ip).append(" selected=selected>").append(ip).append("</option>");
                continue;
            }
            ipSelect.append("<option value=").append(ip).append(">").append(ip).append("</option>");
        }
        ipSelect.append("</select>");
        return "<title>" + title + "</title>" + this.CSS_threadMonitor + ThreadMonitor.getLocalScript() + "<form name=input action=./threadmonitor method=get></form>" + ThreadMonitor.getLocalFloat();
    }

    private String titleToHTML(List<NodeInfo> nodeInfoList, String appNameByTitle) {
        StringBuilder appNameSelect;
        List<String> ipList;
        HashSet<String> appNameSet = this.getAppNameSet(nodeInfoList);
        String title = LangRes.get((String)"ThreadDumpAllHandler_1", (String)"Thread Monitoring", (Object[])new Object[0]);
        String APP_NAME = LangRes.get((String)"NewThreadDumpHandler_8", (String)"Microservices", (Object[])new Object[0]);
        String IP = LangRes.get((String)"NewThreadDumpHandler_9", (String)"Instance IP", (Object[])new Object[0]);
        String select = this.getThreadTypeSelectHTML();
        String threadSelect = this.getThreadTypeSelectHTMLNew();
        Multimap<String, String> appNameAndNodeInfoMultimap = this.createAppNameAndIpMultimap(nodeInfoList);
        if (this.appNameParam.equals("*")) {
            ipList = this.getAllIpList(nodeInfoList);
            appNameSelect = new StringBuilder(APP_NAME).append("<select name=appname style=\"width: 160;\" onchange=getIP(this.value)> <option value=* selected=selected>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>");
        } else {
            ipList = new ArrayList<String>(appNameAndNodeInfoMultimap.get((Object)this.appNameParam));
            appNameSelect = new StringBuilder(APP_NAME).append("<select name=appname style=\"width: 160;\" onchange=getIP(this.value)> <option value=*>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>");
        }
        for (String appName : appNameSet) {
            if (appName.equals(this.appNameParam)) {
                appNameSelect.append("<option value=").append(appName).append(" selected=selected>").append(appName).append("</option>");
                continue;
            }
            appNameSelect.append("<option value=").append(appName).append(">").append(appName).append("</option>");
        }
        appNameSelect.append("</select>&nbsp;&nbsp;");
        StringBuilder ipSelect = this.ipParam.equals("*") ? new StringBuilder(IP).append("<select name=ip style=\"width: 160;\" id=ip><option value=* selected=selected>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>") : new StringBuilder(IP).append("<select name=ip style=\"width: 160;\" id=ip><option value=*>").append(LangRes.get((String)"NewThreadDumpHandler_42", (String)"All", (Object[])new Object[0])).append("</option>");
        for (String ip : ipList) {
            if (EXCEPTION_NODES.get(0).contains(ip)) {
                if (ip.equals(this.ipParam)) {
                    ipSelect.append("<option style=\"color: red\" value=").append(ip).append(" selected=selected>").append(ip).append("</option>");
                    continue;
                }
                ipSelect.append("<option style=\"color: red\" value=").append(ip).append(">").append(ip).append("</option>");
                continue;
            }
            if (ip.equals(this.ipParam)) {
                ipSelect.append("<option value=").append(ip).append(" selected=selected>").append(ip).append("</option>");
                continue;
            }
            ipSelect.append("<option value=").append(ip).append(">").append(ip).append("</option>");
        }
        ipSelect.append("</select>");
        return "<title>" + title + "</title><center><h3>" + appNameByTitle + "</h3></center>" + this.CSS_threadMonitor + ThreadMonitor.getLocalScript() + "<form name=input action=./threadmonitor method=get></form>" + ThreadMonitor.getLocalFloat();
    }

    private int rowParamToInt(String rowParam) {
        int row = 20;
        try {
            int parseRow = Integer.parseInt(rowParam);
            return parseRow <= 0 ? row : parseRow;
        }
        catch (Exception e) {
            return row;
        }
    }
}

