/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.threadpool;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.api.threadpool.ThreadPoolInfoProxyHandler;
import kd.bos.eye.config.EyeConfig;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.unifiedthreadpool.helper.vo.ThreadPoolInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ThreadPoolSetProxyHandler
extends AbstractHttpHandler {
    private static Log logger = LogFactory.getLog(ThreadPoolInfoProxyHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String REQUEST_PATH = "/monitor/eye/threadpool/setThreadPool";
    private static final int READ_TIME_OUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        response.setCode(0);
        response.setMsg("success");
        List<EyeNodeInfo> list = EyeConfig.getSortedNodeList();
        Map<String, String> param = this.getParams(exchange, false);
        String range = param.get("range");
        if (StringUtils.isEmpty((String)range)) {
            range = "currentInstance";
        }
        ThreadPoolInfo info = ExchangeVueUtils.parseJsonFromPost(exchange, ThreadPoolInfo.class);
        String text = JSONUtils.toString((Object)info);
        ArrayList<ErrorMsg> errList = new ArrayList<ErrorMsg>(10);
        boolean isAllSuccess = true;
        for (EyeNodeInfo nodeInfo : list) {
            if (nodeInfo.isGateWay() || "currentInstance".equals(range) && !nodeInfo.getIp().equals(info.getIpPort()) || "allAppInstance".equals(range) && !nodeInfo.getAppName().equals(info.getAppName())) continue;
            String reqPath = nodeInfo.getMonitorUrl(false) + REQUEST_PATH;
            HashMap<String, String> proxyHeader = new HashMap<String, String>();
            proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
            try {
                String ret = EyeHttpClients.postjson(reqPath, proxyHeader, text, 5000, READ_TIME_OUT * 1000);
                if ("success".equals(ret)) continue;
                errList.add(new ErrorMsg(nodeInfo.getInstanceId(), ret));
                isAllSuccess = false;
            }
            catch (Exception e) {
                logger.error(nodeInfo.getHostIp() + " cannot set ThreadPoolConfig!" + e);
                errList.add(new ErrorMsg(nodeInfo.getInstanceId(), e.getMessage()));
                isAllSuccess = false;
            }
        }
        if (!isAllSuccess) {
            response.setMsg("error");
            response.setData(errList);
        }
        OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"ThreadPoolInfoProxyHandler_2", (String)"\u7ebf\u7a0b\u6c60\u670d\u52a1", (Object[])new Object[0]), LangRes.get((String)"ThreadPoolInfoProxyHandler_4", (String)"\u4fee\u6539\u7ebf\u7a0b\u6c60\u670d\u52a1\u6570\u636e", (Object[])new Object[0]));
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private static class ErrorMsg {
        String instanceId;
        String errorMsg;

        public ErrorMsg(String instanceId, String errorMsg) {
            this.instanceId = instanceId;
            this.errorMsg = errorMsg;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }
    }
}

