/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.threadpool;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.config.EyeConfig;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.util.HttpClients;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.helper.ThreadPoolHelper;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.bos.unifiedthreadpool.tasktype.ThreadLimitedModel;
import kd.bos.util.StringUtils;

public class ThreadPoolTaskHandler
implements HttpHandler {
    private static Log logger = LogFactory.getLog(ThreadPoolTaskHandler.class);
    private static ThreadExecutorService service;
    private static Timer timer;
    private static final String POOL_NAME = "TASK-TEST";
    private static final String REGION = "demo";
    private static SecureRandom random;

    private static void init() {
        TaskType taskType1 = new TaskType("task-1", Priority.ONE);
        taskType1.setTaskQueueMaxSize(10);
        taskType1.setImmutable(true);
        taskType1.setMaxThreadLimit((Object)0.5, ThreadLimitedModel.RATE);
        TaskType taskType2 = new TaskType("task-2", Priority.FIVE);
        TaskType taskType3 = new TaskType("task-3", Priority.TEN);
        TaskType taskType4 = new TaskType("task-4", Priority.TEN);
        TaskType taskType5 = new TaskType("task-5", Priority.ONE);
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        PoolRejectedExecutionHandler handler = (r, executor) -> logger.info("\u81ea\u5b9a\u4e49\u62d2\u7edd\u7b56\u7565\u6d4b\u8bd5-" + r);
        strategy.setRejectedExecutionHandler(handler);
        strategy.register(taskType1).register(taskType2).register(taskType3).register(taskType4).register(taskType5);
        service = ThreadPoolFactory.create((String)REGION, (String)POOL_NAME, (ThreadPoolStrategy)strategy);
    }

    private static void startTimer() {
        if (timer == null) {
            timer = new Timer();
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                int rd = random.nextInt(5) + 1;
                String taskType = "task-" + rd;
                int w = random.nextInt(2000);
                ThreadPoolTaskHandler.executeTask(taskType, w);
            }
        }, 1000L, 50L);
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        if (service == null) {
            try {
                ThreadPoolTaskHandler.init();
            }
            catch (Exception e) {
                this.writeJson("fail:" + e, httpExchange);
            }
        }
        Map<String, String> param = this.getParams(httpExchange, false);
        String taskType = param.get("task");
        String time = param.get("time");
        String waitTime = param.get("wait");
        String host = param.get("host");
        String reset = param.get("reset");
        String add = param.get("add");
        String remove = param.get("remove");
        String timerOp = param.get("timer");
        if (host != null) {
            String str = "success";
            List<EyeNodeInfo> list = EyeConfig.getSortedNodeList();
            for (EyeNodeInfo nodeInfo : list) {
                if (!nodeInfo.getHostIp().equals(host)) continue;
                HashMap<String, String> proxyHeader = new HashMap<String, String>();
                taskType = StringUtils.isEmpty((String)taskType) ? "" : taskType;
                time = StringUtils.isEmpty((String)time) ? "" : time;
                waitTime = StringUtils.isEmpty((String)waitTime) ? "" : waitTime;
                reset = StringUtils.isEmpty((String)reset) ? "" : reset;
                remove = StringUtils.isEmpty((String)remove) ? "" : remove;
                add = StringUtils.isEmpty((String)add) ? "" : add;
                timerOp = StringUtils.isEmpty((String)timerOp) ? "" : timerOp;
                String reqPath = nodeInfo.getMonitorUrl(false) + "/monitor/eye/threadpool/taskTest?task=" + taskType + "&time=" + time + "&wait=" + waitTime + "&reset=" + reset + "&remove=" + remove + "&add=" + add + "&timer=" + timerOp;
                proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
                try {
                    str = HttpClients.get((String)reqPath, proxyHeader, (int)100, (int)600);
                }
                catch (Exception e) {
                    logger.error("cannot get taskTest from " + nodeInfo.getHostIp() + "," + e);
                    str = "fail";
                }
            }
            this.writeJson(str, httpExchange);
            return;
        }
        if (StringUtils.isNotEmpty((String)timerOp)) {
            if ("start".equals(timerOp)) {
                ThreadPoolTaskHandler.startTimer();
            } else {
                timer.cancel();
            }
        }
        if (StringUtils.isNotEmpty((String)reset)) {
            ThreadPoolHelper.removeThreadPool((String)REGION, (String)POOL_NAME);
            ThreadPoolTaskHandler.init();
            this.writeJson("success!", httpExchange);
            return;
        }
        if (StringUtils.isNotEmpty((String)add)) {
            TaskType addType = new TaskType(add, Priority.FIVE);
            service.addTaskType(addType);
            this.writeJson("success!", httpExchange);
            return;
        }
        if (StringUtils.isNotEmpty((String)remove)) {
            service.removeTaskType(remove);
            this.writeJson("success!", httpExchange);
            return;
        }
        long w = waitTime == null ? 0L : Long.parseLong(waitTime);
        int timeCount = time == null ? 20 : Integer.parseInt(time);
        for (int i = 0; i < timeCount; ++i) {
            if (StringUtils.isEmpty((String)taskType)) {
                ThreadPoolTaskHandler.executeTask("task-1", 5000L);
                ThreadPoolTaskHandler.executeTask("task-2", 100L);
                ThreadPoolTaskHandler.executeTask("task-3", 100L);
                ThreadPoolTaskHandler.executeTask("task-4", 100L);
                ThreadPoolTaskHandler.executeTask("task-5", 100L);
                continue;
            }
            ThreadPoolTaskHandler.executeTask(taskType, w);
        }
        this.writeJson("success!", httpExchange);
    }

    private static void executeTask(String taskType, long waitTime) {
        service.execute(() -> {
            try {
                logger.info(Thread.currentThread().getName() + ":" + taskType + " \u4efb\u52a1\u6267\u884c\uff01");
                Thread.sleep(waitTime);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }, taskType, null, null);
    }

    private Map<String, String> getParams(HttpExchange exchange, boolean rawQuery) {
        URI uri = exchange.getRequestURI();
        String query = rawQuery ? uri.getRawQuery() : uri.getQuery();
        Map<String, String> params = EyeUriQuery.toMap(query);
        for (Map.Entry<String, String> param : params.entrySet()) {
            params.put(param.getKey(), param.getValue());
        }
        return params;
    }

    private void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    static {
        random = new SecureRandom();
    }
}

