/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.top;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.top.TopUtils;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class TopHandler
extends AbstractHttpHandler {
    private static final String COMMAND_LINUX = "top -b -n 1 -p ";
    private static final String COMMAND_LINUX_THREAD = "top -b -n 1 -Hp ";
    private static final String COMMAND_LINUX_THREAD_CLUSTER_SUB = " |head -n 12";
    private static final String COMMAND_LINUX_THREAD_MODEL_KEY = "model";
    private static final String COMMAND_LINUX_THREAD_MODEL_ONLYONE = "onlyOne";
    private static final String COMMAND_LINUX_THREAD_MODEL_CLUSTER = "cluster";
    private static String COMMAND_WINDOWS = "wmic process where processId=? list full";
    private static int PID = -1;

    public static int getPid() {
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                PID = 1;
            }
        }
        return PID;
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        boolean windows = this.isWindows();
        Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
        String model = params.get(COMMAND_LINUX_THREAD_MODEL_KEY);
        String command = windows ? COMMAND_WINDOWS.replace("?", String.valueOf(TopHandler.getPid())) : COMMAND_LINUX + TopHandler.getPid();
        response.setCode(0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm.ss");
        if (windows) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("windows", "true");
            response.setData(hashMap);
        } else {
            Process ps = Runtime.getRuntime().exec(command);
            try (InputStream inputStream = ps.getInputStream();
                 InputStreamReader isr = new InputStreamReader(inputStream);
                 LineNumberReader br = new LineNumberReader(isr);){
                String line;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
                ArrayList<String> result = new ArrayList<String>(2);
                int index = 1;
                StringBuilder cpuInfo = new StringBuilder(TopUtils.getCpuNumInfo()).append("|");
                while ((line = br.readLine()) != null) {
                    if (line.contains("load average")) {
                        cpuInfo.append(TopUtils.getAvgLoadInfo(line)).append("|");
                        continue;
                    }
                    if (line.contains("%Cpu(s)")) {
                        cpuInfo.append(TopUtils.getCPUUsageInfo(line)).append("|");
                        continue;
                    }
                    if ((!StringUtils.isNotEmpty((String)line) || !line.contains("COMMAND")) && index <= true) continue;
                    result.add(line);
                    ++index;
                }
                hashMap.put("result", result);
                hashMap.put("pid", TopHandler.getPid());
                hashMap.put("cpuInfo", cpuInfo.toString());
                if (result.size() >= 2) {
                    String[] titles = ((String)result.get(0)).split(" ");
                    String[] values = ((String)result.get(1)).split(" ");
                    ArrayList<String> realTitles = new ArrayList<String>(16);
                    realTitles.add("TIME");
                    ArrayList<String> realValues = new ArrayList<String>(16);
                    realValues.add(dateFormat.format(new Date()));
                    for (String title : titles) {
                        if (!StringUtils.isNotEmpty((String)title)) continue;
                        realTitles.add(title);
                    }
                    for (String value : values) {
                        if (!StringUtils.isNotEmpty((String)value)) continue;
                        realValues.add(value);
                    }
                    if (realTitles.size() > 2) {
                        realTitles.remove(2);
                        realValues.remove(2);
                    }
                    hashMap.put("title", realTitles.subList(0, realTitles.size() - 1));
                    hashMap.put("value", realValues.subList(0, realValues.size() - 1));
                }
                if (StringUtils.isNotEmpty((String)model) && COMMAND_LINUX_THREAD_MODEL_CLUSTER.equals(model)) {
                    hashMap.putAll(this.getThreadResult(COMMAND_LINUX_THREAD + TopHandler.getPid(), COMMAND_LINUX_THREAD_MODEL_CLUSTER));
                } else {
                    hashMap.putAll(this.getThreadResult(COMMAND_LINUX_THREAD + TopHandler.getPid(), COMMAND_LINUX_THREAD_MODEL_ONLYONE));
                }
                hashMap.put("windows", "false");
                response.setData(hashMap);
            }
            catch (Exception e) {
                response.setCode(-1);
                response.setMsg(ExceptionHandler.getExceptionStackTrace(e));
            }
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (StringUtils.isNotEmpty((String)osName)) {
            return osName.toLowerCase().contains("win");
        }
        return false;
    }

    private Map<String, Object> getThreadResult(String command, String model) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(16);
        Process ps = Runtime.getRuntime().exec(command);
        try (InputStream inputStream = ps.getInputStream();
             InputStreamReader isr = new InputStreamReader(inputStream);
             LineNumberReader br = new LineNumberReader(isr);){
            int size;
            String line;
            ArrayList<String> result = new ArrayList<String>(2);
            int index = 0;
            while ((line = br.readLine()) != null) {
                if (!line.contains("COMMAND") && index <= 0) continue;
                result.add(line);
                if (!model.equals(COMMAND_LINUX_THREAD_MODEL_CLUSTER) || ++index < 6) continue;
            }
            if ((size = result.size()) > 1) {
                String[] titles;
                ArrayList<String> realTitles = new ArrayList<String>(16);
                String titleLine = (String)result.get(0);
                titleLine = titleLine.replaceAll("PID", "THREADID");
                for (String title : titles = titleLine.split(" ")) {
                    if (!StringUtils.isNotEmpty((String)title)) continue;
                    realTitles.add(title);
                }
                ArrayList realValues = new ArrayList(16);
                for (int i = 1; i < size; ++i) {
                    String[] values;
                    ArrayList<String> tempList = new ArrayList<String>(16);
                    for (String value : values = ((String)result.get(i)).split(" ")) {
                        if (!StringUtils.isNotEmpty((String)value)) continue;
                        tempList.add(value);
                    }
                    if (tempList.size() > 1) {
                        tempList.remove(1);
                        tempList.remove(tempList.size() - 1);
                    }
                    realValues.add(tempList);
                }
                if (realTitles.size() > 1) {
                    realTitles.remove(1);
                }
                response.put("threadTitle", realTitles.subList(0, realTitles.size() - 1));
                response.put("threadValue", realValues);
            }
        }
        return response;
    }
}

