/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.trace;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.instance.Instance;
import kd.bos.util.JSONUtils;
import org.elasticsearch.search.SearchHit;

public class TraceHandlerV2
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    protected static final Storage storage = StorageFactory.getStorage((StorageType)storageType);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
        ApiResponse<Map> apiResponse = new ApiResponse<Map>();
        String start = params.get("startDate");
        String end = params.get("endDate");
        if (!GovernConfigs.getTraceEnable()) {
            HashMap<String, String> retMap = new HashMap<String, String>(8);
            apiResponse.setCode(0);
            retMap.put("enable", "false");
            retMap.put("key", "gov.trace.enable");
            apiResponse.setData(retMap);
            this.writeJson(JSONUtils.toString(apiResponse), exchange);
            return;
        }
        try {
            Date from = dateFormat.parse(start);
            Date to = end != null ? dateFormat.parse(end) : new Date();
            params.put("from", String.valueOf(from.getTime()));
            params.put("to", String.valueOf(to.getTime()));
            Map map = storage.traceList(from, to, params);
            String optimize = System.getProperty("monitor.trace.query.optimize", "true");
            if (!Boolean.parseBoolean(optimize) && !map.isEmpty()) {
                SearchHit[] list = (SearchHit[])map.get("list");
                int size = list == null ? 0 : list.length;
                HashMap<String, Integer> statMap = new HashMap<String, Integer>(16);
                for (int i = 0; i < size; ++i) {
                    JSONObject traceTree = JSONObject.parseObject((String)list[i].getSourceAsString());
                    String serviceName = traceTree.getString("serviceName");
                    if (statMap.containsKey(serviceName)) {
                        Integer integer = (Integer)statMap.get(serviceName);
                        integer = integer + 1;
                        statMap.put(serviceName, integer);
                        continue;
                    }
                    statMap.put(serviceName, 1);
                }
                map.put("statMap", statMap);
            }
            map.put("clusterName", Instance.getClusterName() == null ? " " : Instance.getClusterName());
            apiResponse.setData(map);
            apiResponse.setCode(0);
        }
        catch (Exception e) {
            apiResponse.setCode(1);
            apiResponse.setMsg(ExceptionHandler.getExceptionStackTrace(e));
        }
        this.writeJson(JSONUtils.toString(apiResponse), exchange);
    }
}

