/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.trace;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import kd.bos.eye.api.metric.MetricApiHandler;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.eye.util.EyeUrlUtils;

public class TraceResourceHandler
extends AbstractHttpHandler {
    private static final String HEADER = "Content-Type";
    private final String path;
    private String context;

    public TraceResourceHandler(String path, String context) {
        this.path = path;
        this.context = context;
    }

    @Override
    protected void handle0(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        Map<String, String> params = EyeUriQuery.toMap(pExchange.getRequestURI().getQuery());
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(this.context);
        if (!(reqPath = reqPath.substring(pos + this.context.length())).startsWith("/")) {
            reqPath = "/" + reqPath;
        }
        if ("/".equals(reqPath)) {
            reqPath = "/index.html";
        }
        try (InputStream in = MetricApiHandler.class.getResourceAsStream(this.path + reqPath);
             OutputStream os = pExchange.getResponseBody();){
            if (in == null) {
                pExchange.sendResponseHeaders(404, 0L);
                pExchange.close();
                return;
            }
            if (reqPath.endsWith(".js")) {
                pExchange.getResponseHeaders().set(HEADER, "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".css")) {
                pExchange.getResponseHeaders().set(HEADER, "text/css; charset=UTF-8");
            } else if (reqPath.endsWith(".html")) {
                pExchange.getResponseHeaders().set(HEADER, "text/html; charset=UTF-8");
            } else if (reqPath.endsWith(".json")) {
                pExchange.getResponseHeaders().set(HEADER, "application/json; charset=UTF-8");
            } else if (reqPath.endsWith(".properties")) {
                pExchange.getResponseHeaders().set(HEADER, "text/html; charset=UTF-8");
            }
            String baseUrl = EyeUrlUtils.getHomeUrl(pExchange, "tc");
            if (baseUrl.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                baseUrl = baseUrl.substring(baseUrl.indexOf("//") + 2);
                baseUrl = baseUrl.substring(baseUrl.indexOf(47));
            }
            byte[] response = this.readBytes(in);
            if (reqPath.endsWith("/index.html")) {
                response = this.replaceIndex(response, params, baseUrl);
            }
            pExchange.sendResponseHeaders(202, response.length);
            os.write(response);
            pExchange.close();
        }
    }

    private byte[] replaceIndex(byte[] response, Map<String, String> params, String baseUrl) throws UnsupportedEncodingException {
        String text = new String(response, "UTF-8");
        text = text.replace("{baseUrl}", baseUrl);
        return text.getBytes("UTF-8");
    }

    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

