/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.trace;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import kd.bos.eye.api.metric.MetricApiHandler;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUrlUtils;

public class TraceSpecialResourceHandler
extends AbstractHttpHandler {
    private final String path;
    private static final String HEADER = "Content-Type";

    public TraceSpecialResourceHandler(String path, Map<String, String> variables) {
        this.path = path;
    }

    @Override
    protected void handle0(HttpExchange pExchange) throws IOException {
        InputStream in;
        int lastindex;
        String reqPath;
        String res;
        URI uri = pExchange.getRequestURI();
        OutputStream os = null;
        String httpRootUrl = EyeUrlUtils.getMonitorRootUrl(pExchange);
        if (httpRootUrl.endsWith("/")) {
            httpRootUrl = httpRootUrl.substring(0, httpRootUrl.length() - 1);
        }
        if (!(res = (reqPath = uri.getPath()).substring((lastindex = reqPath.lastIndexOf(47)) + 1)).startsWith("/")) {
            res = "/" + res;
        }
        if ((in = MetricApiHandler.class.getResourceAsStream(this.path + res)) == null) {
            pExchange.sendResponseHeaders(404, 0L);
            pExchange.close();
            return;
        }
        if (reqPath.endsWith(".js")) {
            pExchange.getResponseHeaders().set(HEADER, "text/javascript; charset=UTF-8");
        } else if (reqPath.endsWith(".css")) {
            pExchange.getResponseHeaders().set(HEADER, "text/css; charset=UTF-8");
        } else if (reqPath.endsWith(".html")) {
            pExchange.getResponseHeaders().set(HEADER, "text/html; charset=UTF-8");
        } else if (reqPath.endsWith(".json")) {
            pExchange.getResponseHeaders().set(HEADER, "application/json; charset=UTF-8");
        } else if (reqPath.endsWith(".properties")) {
            pExchange.getResponseHeaders().set(HEADER, "text/html; charset=UTF-8");
        }
        byte[] response = this.readBytes(in);
        pExchange.sendResponseHeaders(202, response.length);
        os = pExchange.getResponseBody();
        os.write(response);
        pExchange.close();
    }

    /*
     * Loose catch block
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int thisLine;
                while ((thisLine = str.read()) != -1) {
                    bos.write(thisLine);
                }
                bos.flush();
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (str != null) {
                str.close();
            }
        }
    }
}

