/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.unifiedmetrics.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.eye.api.config.manager.UnifiedConfigHookService;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.api.unifiedmetrics.MetricMetaReader;
import kd.bos.eye.api.unifiedmetrics.MetricSpiServiceLoader;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.eye.spi.MetricQueryService;
import kd.bos.util.StringUtils;

public class MetricSpiServiceLoaderImpl
implements MetricSpiServiceLoader {
    private static Map<String, MetricMetaReader> readerMap = new ConcurrentHashMap<String, MetricMetaReader>();
    private static Map<String, MetricQueryService> queryServiceMap = new ConcurrentHashMap<String, MetricQueryService>();

    @Override
    public MetricMetaReader loadMetaReader() {
        String storageType = MetricSpiServiceLoaderImpl.getStorageType();
        return this.loadMetaReader(storageType);
    }

    @Override
    public MetricMetaReader loadMetaReader(String metricStorageType) {
        MetricMetaReader provider = readerMap.computeIfAbsent(metricStorageType, k -> (MetricMetaReader)ExtensionFactory.getExtensionFacotry(MetricMetaReader.class).getExtension(metricStorageType));
        return provider;
    }

    @Override
    public MetricQueryService loadQueryService() {
        return this.loadQueryService(MetricSpiServiceLoaderImpl.getStorageType());
    }

    @Override
    public MetricQueryService loadQueryService(String metricStorageType) {
        MetricQueryService service = queryServiceMap.computeIfAbsent(metricStorageType, k -> (MetricQueryService)ExtensionFactory.getExtensionFacotry(MetricQueryService.class).getExtension(metricStorageType));
        return service;
    }

    private static String getStorageType() {
        String storageType = ConfigDbHelper.getValueByKey("monitor.dashboard.metric.storage.type");
        if (StringUtils.isEmpty((String)storageType)) {
            throw new KDException("The [monitor.dashboard.metric.storage] is not configured.");
        }
        return storageType;
    }

    public static class MetricsStorageConfigHook
    implements UnifiedConfigHookService {
        public static void registerHook() {
            UnifiedConfigManager.registHookService(ConfigModule.DASHBOARD_CONFIG.getNumber(), "monitor.dashboard.metric.storage.type", new MetricsStorageConfigHook());
        }

        @Override
        public String beforeSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
            return UnifiedConfigHookService.super.beforeSave(key, configParam);
        }

        @Override
        public void afterSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
        }
    }
}

