/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.unifiedmetrics.prometheus.dao;

import java.util.Map;
import kd.bos.eye.api.unifiedmetrics.prometheus.dao.PromTimeUnit;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromqlArgsMedia;
import kd.bos.util.StringUtils;

public class PromqlHelper {
    private static final String REGEX_METRIC = "#metric";
    private static final String REGEX_GROUP = "#group";
    private static final String REGEX_LABELS = "#label";
    private static final String REGEX_INTERVAL = "#interval";
    private static final String REGEX_UNIT_EXPRESSION = "#convert";
    private static final String REGEX_N = "#n";
    private static final String AGG_BY = "by(%s)";

    public static String getInterval(long start, long end, PromTimeUnit timeUnit) {
        long interval = (end - start) * 1000L;
        String unit = timeUnit.unit;
        long den = timeUnit.millisTo;
        int range = (int)Math.ceil((double)interval / (double)den);
        range = range <= 0 ? 1 : range;
        return range + unit;
    }

    public static String formatPromQL(String template, PromqlArgsMedia property) {
        String unitExp;
        template = template.replaceAll(REGEX_METRIC, property.getMetrics());
        Map<String, String> param = property.getLabels();
        StringBuilder params = new StringBuilder();
        if (param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getValue())) continue;
                params.append(entry.getKey()).append("=").append("\"").append(entry.getValue()).append("\"").append(",");
            }
        }
        template = template.replaceAll(REGEX_LABELS, params.toString());
        if (StringUtils.isNotEmpty((String)property.getInterval())) {
            template = template.replaceAll(REGEX_INTERVAL, property.getInterval());
        }
        if (StringUtils.isNotEmpty((String)property.getTopN())) {
            template = template.replaceAll(REGEX_N, property.getTopN());
        }
        unitExp = StringUtils.isEmpty((String)(unitExp = property.getUnitExp())) ? "" : unitExp;
        template = template.replaceAll(REGEX_UNIT_EXPRESSION, unitExp);
        String group = property.getGroup();
        group = StringUtils.isEmpty((String)group) ? "" : String.format(AGG_BY, group);
        template = template.replaceAll(REGEX_GROUP, group);
        return template;
    }

    public static String createVectorPromQL(String metric, Map<String, String> param) {
        StringBuilder pql = new StringBuilder(metric);
        if (param != null && !param.isEmpty()) {
            pql.append("{");
            for (Map.Entry<String, String> entry : param.entrySet()) {
                pql.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
            }
            pql.append("}");
        }
        return pql.toString();
    }

    public static String createMatrixPromQL(String metric, Map<String, String> param, int interval, PromTimeUnit timeUnit) {
        StringBuilder pql = new StringBuilder(metric);
        if (param != null && !param.isEmpty()) {
            pql.append("{");
            for (Map.Entry<String, String> entry : param.entrySet()) {
                pql.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
            }
            pql.append("}");
        }
        pql.append("[").append(interval).append(timeUnit.unit).append("]");
        return pql.toString();
    }
}

