/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.unifiedmetrics.prometheus.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.eye.api.unifiedmetrics.entity.MetricDictionary;
import kd.bos.eye.api.unifiedmetrics.entity.MetricParam;
import kd.bos.eye.api.unifiedmetrics.entity.SpecificSourceMetrics;
import kd.bos.eye.api.unifiedmetrics.entity.TokenQueryCondition;
import kd.bos.eye.api.unifiedmetrics.entity.UnifiedMetrics;
import kd.bos.eye.api.unifiedmetrics.entity.UnitEntity;
import kd.bos.eye.api.unifiedmetrics.helper.DictionaryParseHelper;
import kd.bos.eye.api.unifiedmetrics.helper.ValueTypeEnum;
import kd.bos.eye.api.unifiedmetrics.impl.MetricSpiServiceLoaderImpl;
import kd.bos.eye.api.unifiedmetrics.prometheus.dao.PromApiQueryDao;
import kd.bos.eye.api.unifiedmetrics.prometheus.dao.PromTimeUnit;
import kd.bos.eye.api.unifiedmetrics.prometheus.dao.PromqlHelper;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromApiArgs;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromResponse;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromResult;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromqlArgsMedia;
import kd.bos.eye.api.unifiedmetrics.prometheus.service.PromJsonParseHelper;
import kd.bos.eye.spi.BaseChartData;
import kd.bos.eye.spi.MetricQueryService;
import kd.bos.eye.spi.MetricsCondition;
import kd.bos.eye.spi.QueryCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class PromMetricQueryService
implements MetricQueryService {
    private static Log logger = LogFactory.getLog(PromMetricQueryService.class);
    private static final String DEFAULT_STEP = "1m";
    private static final String DEFAULT_INTERVAL_TIME = "1m";

    /*
     * WARNING - void declaration
     */
    @Override
    public BaseChartData query(QueryCondition condition) {
        TokenQueryCondition tkCondition = (TokenQueryCondition)condition;
        long start = tkCondition.getStart();
        long end = tkCondition.getEnd();
        List<MetricsCondition> metrics = tkCondition.getMetrics();
        String step = StringUtils.isEmpty((String)condition.getStep()) ? "1m" : condition.getStep();
        String intervalTime = "1m";
        PromApiQueryDao dao = new PromApiQueryDao();
        HashSet<String> timeSet = new HashSet<String>();
        HashMap resultMap = new HashMap(16);
        ArrayList<String> legends = new ArrayList<String>(10);
        HashMap<String, List<Object>> yData = new HashMap<String, List<Object>>(16);
        String singleVal = "";
        HashMap<String, String> legendMap = new HashMap<String, String>(3);
        for (MetricsCondition metric : metrics) {
            boolean isRange;
            void var22_20;
            String metricId = metric.getId();
            String valueType = metric.getValueType();
            String unitStr = metric.getTargetUnit();
            Map<String, String> map = metric.getParams();
            if (map == null) {
                HashMap hashMap = new HashMap(6);
            }
            Map<String, String> nonEmptyValMap = var22_20.entrySet().stream().filter(entry -> StringUtils.isNotEmpty((String)((String)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<String> nonEmptyKeys = new ArrayList<String>(nonEmptyValMap.size());
            if (StringUtils.isNotEmpty((String)metric.getGroup())) {
                String[] arr = metric.getGroup().split(",");
                nonEmptyKeys.addAll(Arrays.asList(arr));
            }
            if (!(isRange = ValueTypeEnum.RANGE.valueType.equalsIgnoreCase(valueType))) {
                intervalTime = PromqlHelper.getInterval(start, end, PromTimeUnit.MINUTES);
            }
            PromqlArgsMedia media = new PromqlArgsMedia();
            media.setMetrics(metric.getMetric());
            media.setGroup(metric.getGroup());
            media.setLabels(metric.getParams());
            media.setTopN(metric.getTop());
            try {
                PromResponse response;
                String funcExp = PromJsonParseHelper.getExpression(metric.getFunc());
                if (StringUtils.isNotEmpty((String)metric.getTargetUnit())) {
                    UnitEntity unit = DictionaryParseHelper.getUnitEntity(metric.getSourceUnit());
                    media.setUnitExp(unit.getTransExpExp(metric.getTargetUnit()));
                }
                media.setInterval(intervalTime);
                boolean isCustomQuery = "2".equals(metric.getQueryType());
                String promql = isCustomQuery ? metric.getQuery() : PromqlHelper.formatPromQL(funcExp, media);
                PromApiArgs args = new PromApiArgs();
                args.setQuery(promql);
                args.setStep(step);
                args.setInterval(intervalTime);
                args.setTime(String.valueOf(end));
                args.setStart(String.valueOf(start));
                args.setEnd(String.valueOf(end));
                args.setToken(tkCondition.getToken());
                PromResponse promResponse = response = isRange ? dao.queryRange(args) : dao.querySingle(args);
                if ("success".equalsIgnoreCase(response.getStatus())) {
                    List<PromResult> results = response.getData().getResult();
                    for (PromResult result : results) {
                        Map<String, String> labels = result.getMetric();
                        if (labels == null || labels.isEmpty()) {
                            labels = nonEmptyValMap;
                        }
                        if (!nonEmptyKeys.isEmpty()) {
                            labels = labels.entrySet().stream().filter(entry -> nonEmptyKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        }
                        String legend = PromMetricQueryService.jointLegend(labels, metric.getMetric(), unitStr);
                        legendMap.put(legend, metricId);
                        legends.add(legend);
                        String[][] values = result.getValues();
                        String[] value = result.getValue();
                        HashMap<String, String> valueMap = new HashMap<String, String>(16);
                        if (isRange) {
                            for (String[] timeArray : values) {
                                timeSet.add(timeArray[0]);
                                valueMap.put(timeArray[0], PromMetricQueryService.format(timeArray[1]));
                            }
                        } else {
                            timeSet.add(value[0]);
                            valueMap.put(value[0], PromMetricQueryService.format(value[1]));
                            singleVal = PromMetricQueryService.format(value[1]);
                        }
                        resultMap.put(legend, valueMap);
                    }
                    continue;
                }
                logger.warn("PromMetricQueryService#query no data back.", (Object)response.getError());
            }
            catch (Exception e) {
                logger.error("PromMetricQueryService#query error.", (Throwable)e);
            }
        }
        ArrayList<String> xData = new ArrayList<String>(timeSet.size());
        xData.addAll(timeSet);
        Collections.sort(xData);
        ArrayList<String> formatXData = new ArrayList<String>(xData.size());
        String pattern = "YYYY-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        xData.forEach(s -> formatXData.add(sdf.format(new Date(Long.parseLong(s) * 1000L))));
        for (Map.Entry entry2 : resultMap.entrySet()) {
            ArrayList yMetric = new ArrayList(xData.size());
            Map values = (Map)entry2.getValue();
            for (String time : xData) {
                yMetric.add(values.get(time));
            }
            yData.put((String)entry2.getKey(), yMetric);
        }
        BaseChartData chartData = new BaseChartData();
        chartData.setLegend(legends);
        chartData.setxData(formatXData);
        chartData.setyData(yData);
        chartData.setTextValue(singleVal);
        chartData.setLegendMap(legendMap);
        return chartData;
    }

    public static String format(String val) {
        if (StringUtils.isEmpty((String)val) || "NaN".equals(val)) {
            return "0";
        }
        if (PromMetricQueryService.isDecimal(val)) {
            double number = Double.parseDouble(val);
            String formatted = String.format("%.2f", number);
            return formatted;
        }
        return val;
    }

    private static boolean isDecimal(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^-?\\d+\\.\\d+$");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    private static String jointLegend(Map<String, String> labels, String metric, String unit) {
        if (StringUtils.isEmpty((String)metric)) {
            if (labels == null || labels.isEmpty()) {
                return "";
            }
            return labels.size() == 1 ? labels.values().iterator().next() : labels.toString();
        }
        String unitStr = StringUtils.isEmpty((String)unit) ? "" : String.format("(%s)", unit);
        MetricSpiServiceLoaderImpl loader = new MetricSpiServiceLoaderImpl();
        ArrayList allMetrics = new ArrayList(16);
        List<UnifiedMetrics> all = loader.loadMetaReader().provide();
        all.forEach(u -> allMetrics.addAll(u.getMetrics()));
        Map<String, SpecificSourceMetrics> metricMap = allMetrics.stream().collect(Collectors.toMap(MetricDictionary::getItem, SpecificSourceMetrics2 -> SpecificSourceMetrics2));
        SpecificSourceMetrics sourceMetrics = metricMap.get(metric);
        if (sourceMetrics == null) {
            return metric + unitStr;
        }
        String metricName = sourceMetrics.getName();
        List<MetricParam> params = sourceMetrics.getParams();
        StringBuilder builder = new StringBuilder(metricName);
        builder.append(unitStr);
        if (labels == null || labels.isEmpty() || params == null || params.size() == 0) {
            return builder.toString();
        }
        Map<String, String> paramMap = params.stream().collect(Collectors.toMap(MetricParam::getName, MetricParam::getAlias));
        if (!paramMap.isEmpty()) {
            builder.append("{");
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                builder.append(paramMap.get(key)).append("=").append(val);
            }
            builder.append("}");
        }
        return builder.toString();
    }
}

