/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.service.EyeServerService;
import kd.bos.instance.Instance;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.SystemProperties;
import kd.bos.util.WebPortUtil;

public class EyeConfig {
    private static EyeNodeInfo nodeInfo;

    public static String getEyePort() {
        return SystemProperties.get((String)"EYE_HTTP_PORT");
    }

    public static EyeNodeInfo getNodeInfo() {
        if (nodeInfo == null) {
            EyeNodeInfo info = new EyeNodeInfo();
            info.setClusterName(Instance.getClusterName());
            String appName = Instance.getAppName();
            info.setAppName(appName);
            if (EyeConfig.isGateway()) {
                info.setGateWay(true);
                if ("web".equals(appName)) {
                    info.setShowAppName("web(gateway)");
                } else {
                    info.setShowAppName(appName + "(gateway)");
                }
            }
            StringBuilder configAppName = new StringBuilder();
            String[] configAppNames = Instance.getConfigAppName();
            for (int i = 0; i < configAppNames.length; ++i) {
                configAppName.append(configAppNames[i]).append(',');
            }
            info.setConfigAppName(configAppName.toString());
            info.setInstanceId(Instance.getInstanceId());
            info.setAppIds(Instance.getAppIds());
            String ip = NetAddressUtils.getLocalIpAddress();
            String monitorPort = EyeConfig.getEyePort();
            info.setIp(ip);
            info.setMonitorPort(monitorPort);
            info.setHostIp(System.getProperty("MONITOR_HTTP_HOST_IP"));
            info.setHostMonitorPort(System.getProperty("MONITOR_HTTP_HOST_PORT"));
            try {
                info.setHostName(NetAddressUtils.getLocalHostName());
            }
            catch (Exception e) {
                info.setHostName("localhost");
            }
            String port = WebPortUtil.getWebPort(null);
            if (port != null) {
                info.setWebPort(port);
            }
            if ((port = System.getProperty("SERVICE_PORT")) != null) {
                info.setMservicePort(port);
                String s = System.getProperty("dubbo.registry.register");
                if (s != null) {
                    info.setDubboRegister(Boolean.parseBoolean(s));
                }
                if ((s = System.getProperty("mq.consumer.register")) != null) {
                    info.setMqConsumerRegister(Boolean.parseBoolean(s));
                }
            }
            info.setRpcPort(MonitorConfig.getRpcPort());
            nodeInfo = info;
        }
        return nodeInfo;
    }

    private static boolean isGateway() {
        String TRUE = "true";
        String WEBSTR = "web";
        String appName = SystemProperties.getWithEnv((String)"appName");
        String configAppName = SystemProperties.getWithEnv((String)"configAppName");
        String webmserviceinone = SystemProperties.getWithEnv((String)"webmserviceinone");
        String isMserviceNode = SystemProperties.getWithEnv((String)"isMserviceNode");
        boolean isWebNode = WEBSTR.equals(appName) ? true : (TRUE.equals(webmserviceinone) ? false : (TRUE.equals(isMserviceNode) ? false : (configAppName != null && configAppName.indexOf("mservice") >= 0 ? false : configAppName != null && configAppName.indexOf(WEBSTR) >= 0)));
        return isWebNode;
    }

    public static List<EyeNodeInfo> getSortedNodeList() {
        ArrayList<EyeNodeInfo> list = EyeServerService.getAllEyeNodes();
        try {
            Comparator<EyeNodeInfo> byAppName = Comparator.comparing(EyeNodeInfo::getAppName);
            Comparator<EyeNodeInfo> byStartTime = Comparator.comparing(EyeNodeInfo::getStartTimestamp);
            list.sort(byAppName.thenComparing(byStartTime));
        }
        catch (Exception er) {
            throw new RuntimeException("Get monitor node error", er);
        }
        return list;
    }
}

