/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.config.broadcast;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.eye.config.broadcast.EyeConfigBroadcastService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;

public class EyeConfigBroadcastHelper {
    private static final Log log = LogFactory.getLog(EyeConfigBroadcastHelper.class);
    private static final ThreadPool pool = ThreadPools.newCachedThreadPool((String)"EyeConfigBroadcast-thread", (int)0, (int)1);
    private static final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue(65535);

    public static void broadCast(String path, String key, String value) {
        EyeConfigBroadcastHelper.broadCast(EyeConfigBroadcastService.class.getName(), "receiveConfigChange", path, key, value);
    }

    public static void broadCast(String className, String methodName, String path, String key, String value) {
        pool.execute(() -> {
            EyeConfigBroadcastHelper.getOrCreateRequestContext();
            List serviceInfos = ServiceInfoFactory.get().getServiceList();
            for (ServiceInfo serviceInfo : serviceInfos) {
                if (Instance.getInstanceId().equals(serviceInfo.getInstanceId())) continue;
                Runnable runner = () -> {
                    EyeConfigBroadcastHelper.getOrCreateRequestContext();
                    for (int i = 0; i < 5; ++i) {
                        try {
                            EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)className, (String)methodName, (Object[])new Object[]{path, key, value});
                            break;
                        }
                        catch (Error | Exception e) {
                            LockSupport.parkNanos(1000000000L + 2L * (long)i * 1000000000L);
                            continue;
                        }
                    }
                };
                try {
                    EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)className, (String)methodName, (Object[])new Object[]{path, key, value});
                }
                catch (Exception e) {
                    queue.add(runner);
                    log.warn("EyeConfigBroadcastHelper broadCast failed,ip:" + serviceInfo.getIp() + " ,key:" + key + ",value:" + value, (Throwable)e);
                }
            }
        });
    }

    private static void getOrCreateRequestContext() {
        RequestContext requestContext = RequestContext.getOrCreate();
        if (requestContext.getTraceId() == null) {
            requestContext.setTraceId(TraceIdUtil.createTraceIdString());
        }
        RequestContextThreadBinder.bind((RequestContext)requestContext);
    }

    static {
        Thread t = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Runnable runnable;
                        if ((runnable = queue.take()) == null) {
                            continue;
                        }
                        runnable.run();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }, "EyeConfigBroadcastHelper-thread");
        t.setDaemon(true);
        t.start();
    }
}

