/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.config.custom;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.eye.config.custom.ConfigEntity;
import kd.bos.eye.config.custom.ConfigInfo;
import kd.bos.eye.config.custom.DefaultConfig;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ConfigDbHelper {
    private static final Log logger = LogFactory.getLog(ConfigDbHelper.class);
    private static final String QUERY_SQL = "SELECT FID,FCLUSTERNAME,FKEY,FVALUE,FMODULE,FVERSION,FISSHOW,FDESCRIPTION,TO_CHAR(fupdatetime,'YYYY-MM-DD HH24:MI:SS') as fupdatetime FROM T_MONITOR_CONFIG WHERE FCLUSTERNAME = ?";
    private static final String QUERY_VALUE = "SELECT FVALUE FROM T_MONITOR_CONFIG WHERE FCLUSTERNAME = ? and FKEY = ?";
    private static final String QUERY_ALL_CONFIG = "SELECT FID,FCLUSTERNAME,FKEY,FVALUE,FMODULE,FVERSION,FDESCRIPTION FROM T_MONITOR_CONFIG WHERE FCLUSTERNAME = ? and FKEY = ?";
    private static final String DELETE_SQL = "DELETE FROM T_MONITOR_CONFIG WHERE FID = ?";
    private static final String INSERT_SQL = "INSERT INTO T_MONITOR_CONFIG(FID,FCLUSTERNAME,FKEY,FVALUE,FMODULE,FVERSION,FISSHOW,FDESCRIPTION,FUPDATETIME) values(?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_SQL = "UPDATE T_MONITOR_CONFIG SET FVALUE=?,FMODULE=?,FVERSION=?,FDESCRIPTION=?,FUPDATETIME=? WHERE FID=?";
    private static final String UPDATE_SQL_WITH_MODULE_KEY = "UPDATE T_MONITOR_CONFIG SET FVALUE=?,FUPDATETIME=? WHERE FCLUSTERNAME = ? and FMODULE=? and FKEY = ?";

    public static synchronized String getValueByKey(String key) {
        return ConfigDbHelper.getValueByKeyFromDB(key);
    }

    public static String getValueByKey(String key, String defaultValue) {
        String value = ConfigDbHelper.getValueByKey(key);
        return StringUtils.isEmpty((String)value) ? defaultValue : value;
    }

    public static ConfigEntity getConfigEntityByKey(String key) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(Instance.getClusterName());
        values.add(key);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(QUERY_ALL_CONFIG, values));
        try {
            List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (!results.isEmpty()) {
                Result result = (Result)results.get(0);
                ConfigEntity configEntity = new ConfigEntity();
                configEntity.setId(result.getString("fid"));
                configEntity.setClusterName(Instance.getClusterName());
                configEntity.setKey(result.getString("fkey"));
                if ("monitor.pmm.password".equals(result.getString("fkey"))) {
                    configEntity.setValue("******");
                } else {
                    configEntity.setValue(result.getString("fvalue"));
                }
                configEntity.setModule(result.getString("fmodule"));
                configEntity.setVersion(Integer.parseInt(result.getString("fversion")));
                configEntity.setDescription(result.getString("fdescription"));
                return configEntity;
            }
        }
        catch (Exception e) {
            logger.error("GetConfigEntityByKey is error. ", (Throwable)e);
        }
        return null;
    }

    public static String getValueByKeyFromDB(String key) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(Instance.getClusterName());
        values.add(key);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(QUERY_VALUE, values));
        String value = null;
        try {
            List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (!results.isEmpty()) {
                value = ((Result)results.get(0)).getString("fvalue");
            }
        }
        catch (Exception e) {
            logger.error("Getting monitor unified config value by key is error. ", (Throwable)e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initConfigToDb() {
        if (DBHelper.dbIsConfigured()) {
            DLock dLock = DLock.create((String)ConfigDbHelper.getPath());
            try {
                if (!dLock.tryLock()) {
                    return;
                }
                try (TXHandle ignored = TX.required();){
                    ConfigDbHelper.updateHistoryData();
                    Map<String, ConfigEntity> dbConfigs = ConfigDbHelper.configEntityListToMap(ConfigDbHelper.getAllShowConfigs());
                    Map<String, ConfigEntity> defaultConfigs = ConfigDbHelper.defaultConfigInfoListToMap();
                    Map<String, List<ConfigEntity>> resultMap = ConfigDbHelper.needToChangeConfig(dbConfigs, defaultConfigs);
                    ConfigDbHelper.deleteConfigFromDb(resultMap.get("needToDelete"));
                    ConfigDbHelper.addConfigsToDb(resultMap.get("needToAdd"));
                    ConfigDbHelper.updateConfigsToDb(resultMap.get("needToUpdate"));
                    logger.info("init configs to DB with thread-" + Thread.currentThread(), resultMap);
                }
                catch (Exception e) {
                    logger.error("init monitor table config failed.", (Throwable)e);
                }
            }
            finally {
                dLock.unlock();
            }
        }
    }

    private static void updateHistoryData() {
        try {
            DBRequest dbRequest = new DBRequest();
            ArrayList<Object> paramList = new ArrayList<Object>(2);
            paramList.add(Instance.getClusterName());
            paramList.add(LocalDateTime.now());
            String updateSql = "UPDATE T_MONITOR_CONFIG SET FCLUSTERNAME=?,FUPDATETIME=? WHERE FCLUSTERNAME= ' '";
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
            MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
        }
        catch (Exception e) {
            logger.warn("updateHistoryData exception", (Throwable)e);
        }
    }

    public static void updateConfigsToDb(List<ConfigEntity> configEntityList) {
        try {
            ArrayList<DBRequest> requests = new ArrayList<DBRequest>(configEntityList.size());
            for (ConfigEntity configEntity : configEntityList) {
                ArrayList<Object> paramList = new ArrayList<Object>(5);
                paramList.add(configEntity.getValue());
                paramList.add(configEntity.getModule());
                paramList.add(configEntity.getVersion());
                paramList.add(configEntity.getDescription());
                paramList.add(LocalDateTime.now());
                paramList.add(configEntity.getId());
                DBRequest dbRequest = new DBRequest();
                dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(UPDATE_SQL, paramList));
                requests.add(dbRequest);
            }
            MetadataFactory.getStatement().executeUpdateBatch(requests);
        }
        catch (Exception e) {
            logger.error("Updating monitor's configs to DB is error. ", (Throwable)e);
            throw e;
        }
    }

    public static synchronized boolean updateConfigToDb(ConfigEntity configEntity) {
        try {
            ArrayList<Object> paramList = new ArrayList<Object>(5);
            paramList.add(configEntity.getValue());
            paramList.add(configEntity.getModule());
            paramList.add(configEntity.getVersion());
            paramList.add(configEntity.getDescription());
            paramList.add(LocalDateTime.now());
            paramList.add(configEntity.getId());
            DBRequest dbRequest = new DBRequest();
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(UPDATE_SQL, paramList));
            int count = MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("Updating monitor's config to DB is error. ", (Throwable)e);
            return false;
        }
    }

    public static synchronized boolean updateConfigToDbByModuleAndKey(ConfigEntity configEntity) {
        try {
            ArrayList<Object> paramList = new ArrayList<Object>(5);
            paramList.add(configEntity.getValue());
            paramList.add(LocalDateTime.now());
            paramList.add(configEntity.getClusterName());
            paramList.add(configEntity.getModule());
            paramList.add(configEntity.getKey());
            DBRequest dbRequest = new DBRequest();
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(UPDATE_SQL_WITH_MODULE_KEY, paramList));
            int count = MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("Updating monitor's config to DB is error. ", (Throwable)e);
            return false;
        }
    }

    public static void deleteConfigFromDb(List<ConfigEntity> configEntityList) {
        try {
            for (ConfigEntity configEntity : configEntityList) {
                ArrayList<String> paramList = new ArrayList<String>(1);
                paramList.add(configEntity.getId());
                DBRequest dbRequest = new DBRequest();
                dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(DELETE_SQL, paramList));
                MetadataFactory.getStatement().executeDelete((Request)dbRequest);
            }
        }
        catch (Exception e) {
            logger.error("Deleting monitor's useless configs from DB is error. ", (Throwable)e);
            throw e;
        }
    }

    public static void addConfigsToDb(List<ConfigEntity> configEntityList) {
        try {
            ArrayList<DBRequest> requests = new ArrayList<DBRequest>(configEntityList.size());
            for (ConfigEntity configEntity : configEntityList) {
                if (ConfigDbHelper.getValueByKeyFromDB(configEntity.getKey()) != null) continue;
                ArrayList<Object> paramList = new ArrayList<Object>(6);
                paramList.add(configEntity.getId());
                paramList.add(configEntity.getClusterName());
                paramList.add(configEntity.getKey());
                paramList.add(configEntity.getValue());
                paramList.add(configEntity.getModule());
                paramList.add(configEntity.getVersion());
                paramList.add(configEntity.getIsShow());
                paramList.add(configEntity.getDescription());
                paramList.add(LocalDateTime.now());
                DBRequest dbRequest = new DBRequest();
                dbRequest.setInsertRequest(new DBRequest.InsertRequest(INSERT_SQL, paramList));
                requests.add(dbRequest);
            }
            MetadataFactory.getStatement().executeInsertBatch(requests);
        }
        catch (Exception e) {
            logger.error("Saving monitor's configs to DB is error. ", (Throwable)e);
            throw e;
        }
    }

    public static List<ConfigEntity> getLatestModifyConfig(int minute) {
        return ConfigDbHelper.getConfigsByMultiParam(null, null, null, minute);
    }

    public static List<ConfigEntity> getAllConfigs() {
        return ConfigDbHelper.getConfigsByMultiParam(null, null, null);
    }

    public static List<ConfigEntity> getConfigsByModule(String module) {
        return ConfigDbHelper.getConfigsByMultiParam(null, module, null);
    }

    public static List<ConfigEntity> getAllNotShowConfigs() {
        return ConfigDbHelper.getConfigsByIsShow(1);
    }

    public static List<ConfigEntity> getAllShowConfigs() {
        return ConfigDbHelper.getConfigsByIsShow(0);
    }

    private static List<ConfigEntity> getConfigsByIsShow(int isShow) {
        return ConfigDbHelper.getConfigsByMultiParam(null, null, isShow);
    }

    public static List<ConfigEntity> getConfigsByKey(String key, String module) {
        return ConfigDbHelper.getConfigsByMultiParam(key, module, 0);
    }

    private static List<ConfigEntity> getConfigsByMultiParam(String key, String module, Integer isShow) {
        return ConfigDbHelper.getConfigsByMultiParam(key, module, isShow, null);
    }

    private static List<ConfigEntity> getConfigsByMultiParam(String key, String module, Integer isShow, Integer minute) {
        List<ConfigEntity> configEntities;
        StringBuilder queryStringBuilder = new StringBuilder(QUERY_SQL);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(Instance.getClusterName());
        if (StringUtils.isNotEmpty((String)key)) {
            queryStringBuilder.append(" AND FKEY LIKE ?");
            values.add("%" + key + "%");
        }
        if (StringUtils.isNotEmpty((String)module)) {
            queryStringBuilder.append(" AND FMODULE = ?");
            values.add(module);
        }
        if (isShow != null) {
            queryStringBuilder.append(" AND FISSHOW = ?");
            values.add(isShow);
        }
        if (minute != null) {
            queryStringBuilder.append("AND FUPDATETIME > ?");
            values.add(LocalDateTime.now().minus(minute.intValue(), ChronoUnit.MINUTES));
        }
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(queryStringBuilder.toString(), values));
        try {
            List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            configEntities = new ArrayList(results.size());
            for (Result result : results) {
                ConfigEntity configEntity = new ConfigEntity();
                configEntity.setId(result.getString("fid"));
                configEntity.setClusterName(Instance.getClusterName());
                configEntity.setKey(result.getString("fkey"));
                if ("monitor.pmm.password".equals(result.getString("fkey"))) {
                    configEntity.setValue("******");
                } else {
                    configEntity.setValue(result.getString("fvalue"));
                }
                configEntity.setModule(result.getString("fmodule"));
                configEntity.setVersion(Integer.parseInt(result.getString("fversion")));
                configEntity.setDescription(result.getString("fdescription"));
                if (StringUtils.isNotEmpty((String)result.getString("fupdatetime"))) {
                    configEntity.setUpdateTime(LocalDateTime.parse(result.getString("fupdatetime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                }
                configEntities.add(configEntity);
            }
        }
        catch (Exception e) {
            configEntities = Collections.emptyList();
            logger.error("Getting monitor unified configs by key is error. ", (Throwable)e);
        }
        return configEntities;
    }

    private static Map<String, ConfigEntity> defaultConfigInfoListToMap() {
        HashMap<String, ConfigEntity> configEntityMap = new HashMap<String, ConfigEntity>(DefaultConfig.DEFAULT_CONFIG_LIST.size());
        if (DefaultConfig.DEFAULT_CONFIG_LIST.isEmpty()) {
            return configEntityMap;
        }
        for (ConfigInfo configInfo : DefaultConfig.DEFAULT_CONFIG_LIST) {
            configEntityMap.put(configInfo.getKey(), new ConfigEntity(String.valueOf(DB.genLongId((String)"T_MONITOR_CONFIG")), configInfo.getClusterName(), configInfo.getKey(), configInfo.getValue(), configInfo.getModule().getNumber(), configInfo.getVersion(), configInfo.getIsShow(), configInfo.getDescription(), configInfo.getUpdateTime()));
        }
        return configEntityMap;
    }

    private static Map<String, ConfigEntity> configEntityListToMap(List<ConfigEntity> configEntityList) {
        HashMap<String, ConfigEntity> configEntityMap = new HashMap<String, ConfigEntity>(configEntityList.size());
        if (configEntityList.isEmpty()) {
            return configEntityMap;
        }
        for (ConfigEntity configEntity : configEntityList) {
            configEntityMap.put(configEntity.getKey(), configEntity);
        }
        return configEntityMap;
    }

    private static Map<String, List<ConfigEntity>> needToChangeConfig(Map<String, ConfigEntity> dbConfigs, Map<String, ConfigEntity> defaultConfigs) {
        ArrayList<ConfigEntity> needToAddList = new ArrayList<ConfigEntity>();
        ArrayList<ConfigEntity> needToUpdateList = new ArrayList<ConfigEntity>();
        ArrayList<ConfigEntity> needToDeleteList = new ArrayList<ConfigEntity>();
        for (Map.Entry<String, ConfigEntity> configEntityEntry : dbConfigs.entrySet()) {
            if (defaultConfigs.containsKey(configEntityEntry.getKey())) continue;
            needToDeleteList.add(configEntityEntry.getValue());
        }
        for (Map.Entry<String, ConfigEntity> configEntityEntry : defaultConfigs.entrySet()) {
            if (!dbConfigs.containsKey(configEntityEntry.getKey())) {
                needToAddList.add(configEntityEntry.getValue());
                continue;
            }
            if (configEntityEntry.getValue().getVersion() <= dbConfigs.get(configEntityEntry.getKey()).getVersion()) continue;
            ConfigEntity newConfigEntity = configEntityEntry.getValue();
            newConfigEntity.setId(dbConfigs.get(configEntityEntry.getKey()).getId());
            needToUpdateList.add(newConfigEntity);
        }
        HashMap<String, List<ConfigEntity>> resultMap = new HashMap<String, List<ConfigEntity>>(2);
        resultMap.put("needToAdd", needToAddList);
        resultMap.put("needToUpdate", needToUpdateList);
        resultMap.put("needToDelete", needToDeleteList);
        return resultMap;
    }

    private static String getPath() {
        return "/dlock/monitor/initConfig/initMonitorConfig";
    }

    static {
        ConfigDbHelper.updateHistoryData();
    }
}

