/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.config.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.mservice.monitor.lang.LangRes;

public enum ConfigModule {
    OP_CONFIG("opConfig", "\u64cd\u4f5c\u65e5\u5fd7"),
    THREAD_DUMP("threadDump", "\u7ebf\u7a0b\u5806\u6808\u76d1\u63a7"),
    ALARM_CONFIG("alarmConfig", "\u544a\u8b66\u7ba1\u7406"),
    HEALTH_INDICATOR_CONFIG("HealthIndicator", "\u5065\u5eb7\u6307\u6807\u7ba1\u7406"),
    TOPOLOGY_CONFIG("topoAnalysis", "\u62d3\u6251\u7a7f\u900f\u5206\u6790"),
    P_THREAD_POOL_CONFIG("priorityThreadPool", "\u4f18\u5148\u7ea7\u7ebf\u7a0b\u6c60"),
    DASHBOARD_CONFIG("dashboardConfig", "\u5927\u76d8\u7ba1\u7406"),
    THIRD_MONITOR_CONFIG("thirdAppConfig", "\u7b2c\u4e09\u65b9\u5e94\u7528");

    private final String number;
    private final String description;

    private ConfigModule(String number, String description) {
        this.number = number;
        this.description = description;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<Map<String, String>> configModulesToMap() {
        ConfigModule[] configModules = ConfigModule.values();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(configModules.length);
        for (ConfigModule configModule : configModules) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("number", configModule.getNumber());
            map.put("description", LangRes.get((String)("ConfigModule" + configModule.getNumber()), (String)configModule.getDescription(), (Object[])new Object[0]));
            result.add(map);
        }
        return result;
    }

    public static String getValueByKey(String module) {
        for (ConfigModule configModule : ConfigModule.values()) {
            if (!configModule.getNumber().equals(module)) continue;
            return configModule.getDescription();
        }
        return null;
    }
}

