/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.config.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.eye.config.service.DbExecuteService;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.config.service.db.DbEyeConfigService;
import kd.bos.eye.config.service.zookeeper.ZookeeperEyeConfigService;
import kd.bos.instance.Instance;

public class EyeConfigServiceFactory {
    private static final Map<String, EyeConfigService> EyeConfigServicePool = new ConcurrentHashMap<String, EyeConfigService>(2);

    public static EyeConfigService getEyeConfigService(String path) {
        return EyeConfigServiceFactory.getEyeConfigService(path, null, null);
    }

    public static EyeConfigService getEyeConfigService(String path, DbExecuteService loadDBDataCall, EyeConfigChangeListener eyeConfigChangeListener) {
        return EyeConfigServiceFactory.getEyeConfigService(null, path, loadDBDataCall, eyeConfigChangeListener);
    }

    public static EyeConfigService getEyeConfigService(String region, String path, DbExecuteService loadDBDataCall, EyeConfigChangeListener eyeConfigChangeListener) {
        String configType = System.getProperty("eye.config.type", "db");
        if (!path.contains(Instance.getClusterName())) {
            path = Instance.getClusterName() + path;
        }
        String finalPath = path;
        return EyeConfigServicePool.computeIfAbsent(finalPath, k -> {
            if ("zookeeper".equals(configType)) {
                return new ZookeeperEyeConfigService(region, finalPath, loadDBDataCall, eyeConfigChangeListener);
            }
            return new DbEyeConfigService(region, finalPath, loadDBDataCall, eyeConfigChangeListener);
        });
    }
}

