/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.config.service.db;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kd.bos.armor.core.concurrent.NamedThreadFactory;
import kd.bos.eye.config.broadcast.EyeConfigBroadcastHelper;
import kd.bos.eye.config.service.AbstractEyeConfigService;
import kd.bos.eye.config.service.DbExecuteService;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.government.Constant;
import kd.bos.government.metadata.db.DBHelper;

public class DbEyeConfigService
extends AbstractEyeConfigService {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2, (ThreadFactory)new NamedThreadFactory("monitor-db-config-update", true));
    private final String region;
    private final String path;
    private final DbExecuteService loadDBDataCall;

    public DbEyeConfigService(String region, String path, DbExecuteService loadDBDataCall, EyeConfigChangeListener eyeConfigChangeListener) {
        this.region = region;
        this.path = path;
        this.loadDBDataCall = loadDBDataCall;
        this.getEyeConfigChanger().addListener(eyeConfigChangeListener);
        this.init();
    }

    private void init() {
        this.initScheduledTask();
        this.loadInitialConfigFromDB();
    }

    private void initScheduledTask() {
        scheduler.scheduleWithFixedDelay(() -> {
            if (Boolean.getBoolean("eye.config.db.schedule.disable")) {
                return;
            }
            if (!DBHelper.dbIsConfigured()) {
                return;
            }
            try {
                Map<String, String> map = this.loadDBDataCall.queryData("schedulePullDataFromDB");
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        this.getEyeConfigChanger().updateValue(entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 60L, Constant.MONITOR_CONFIG_SCHEDULE_EXECUTE_SECONDS, TimeUnit.SECONDS);
    }

    private void loadInitialConfigFromDB() {
        Map<String, String> map;
        if (DBHelper.dbIsConfigured() && (map = this.loadDBDataCall.queryData("initDataFromDB")) != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.getEyeConfigChanger().updateValue(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void saveConfig(String str, String value) {
        this.getEyeConfigChanger().updateValue(str, value);
        EyeConfigBroadcastHelper.broadCast(this.path, str, value);
    }

    @Override
    public void close() {
    }
}

