/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.proxy;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.config.EyeConfig;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeHttpClients;

public class EyeIerpProxyHandler
extends AbstractHttpHandler {
    private static final String PLACEHOLDER = "/cyh/";
    private static final int readtimeout = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        this.handle0(exchange);
    }

    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(PLACEHOLDER);
        EyeNodeInfo info = EyeConfig.getNodeInfo();
        reqPath = "http://" + info.getIp() + ":" + info.getHostMonitorPort() + "/" + reqPath.substring(pos + PLACEHOLDER.length());
        try {
            HashMap<String, String> proxyHeader = new HashMap<String, String>();
            proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
            String response = EyeHttpClients.get(reqPath, proxyHeader, 5000, readtimeout * 1000);
            response = this.cleanXSSResponse(response);
            this.writeJson(response, pExchange);
        }
        catch (Exception e) {
            String msg = this.cleanXSSResponse(e.getMessage());
            this.writeHtml(msg, pExchange);
        }
        pExchange.close();
    }
}

