/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.proxy;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.ApiRequest;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;

public class EyeJmxProxyHandler
extends EyeProxyHandler {
    private static final Log log = LogFactory.getLog(EyeJmxProxyHandler.class);

    public EyeJmxProxyHandler(boolean appendProxyUrl) {
        super(appendProxyUrl);
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        try {
            ApiRequest request = ExchangeVueUtils.parsePostJson(exchange, JmxProxyRequest.class);
            try {
                this.process((JmxProxyRequest)request, exchange);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Throwable)e);
        }
        out.flush();
        this.writeHtml(sw.toString(), exchange);
    }

    protected void process(JmxProxyRequest request, HttpExchange exchange) throws Exception {
        JmxProxyRequest.RequestInfo[] reqsInfo = request.getReqsInfo();
        ConcurrentHashMap respMap = new ConcurrentHashMap(8);
        if (reqsInfo != null) {
            int threadNum = reqsInfo.length;
            CountDownLatch countDownLatch = new CountDownLatch(threadNum);
            for (JmxProxyRequest.RequestInfo reqInfo : reqsInfo) {
                ThreadPools.executeOnce((String)"jmxRequest", () -> {
                    String resp = this.sendReq(reqInfo);
                    if (null == resp) {
                        log.warn("jmx request to " + reqInfo.getUrl() + " fail!");
                    } else {
                        respMap.put(reqInfo.getUrl(), resp);
                    }
                    countDownLatch.countDown();
                });
            }
            boolean await = countDownLatch.await(30L, TimeUnit.SECONDS);
            if (!await) {
                log.info("jmx request await timeout!");
            }
        }
        String str = JSONUtils.toString(respMap);
        this.writeJson(str, exchange);
    }

    private String sendReq(JmxProxyRequest.RequestInfo requestInfo) {
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        try {
            String property = System.getProperty("monitor.realtime.timeout", "50000");
            int timeout = Integer.parseInt(property);
            String param = JSONUtils.toString((Object)requestInfo.getReqMetas());
            String response = EyeHttpClients.postjson(requestInfo.getUrl(), proxyHeader, param, timeout, timeout);
            response = this.cleanXSSResponse(response);
            return response;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class JmxProxyRequest
    extends ApiRequest {
        private RequestInfo[] reqsInfo;

        private JmxProxyRequest() {
        }

        public RequestInfo[] getReqsInfo() {
            return this.reqsInfo;
        }

        public void setReqsInfo(RequestInfo[] reqsInfo) {
            this.reqsInfo = reqsInfo;
        }

        private static class RequestInfo {
            private String url;
            private ReqMeta[] reqMetas;

            private RequestInfo() {
            }

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public ReqMeta[] getReqMetas() {
                return this.reqMetas;
            }

            public void setReqMetas(ReqMeta[] reqMetas) {
                this.reqMetas = reqMetas;
            }

            private static class ReqMeta {
                private String type;
                private String mbean;
                private String attribute;
                private String path;

                private ReqMeta() {
                }

                public String getType() {
                    return this.type;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public String getMbean() {
                    return this.mbean;
                }

                public void setMbean(String mbean) {
                    this.mbean = mbean;
                }

                public String getAttribute() {
                    return this.attribute;
                }

                public void setAttribute(String attribute) {
                    this.attribute = attribute;
                }

                public String getPath() {
                    return this.path;
                }

                public void setPath(String path) {
                    this.path = path;
                }
            }
        }
    }
}

