/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.proxy;

import com.google.common.io.CharStreams;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.eye.util.EyeUrlUtils;
import kd.bos.instance.Instance;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.ZkManagerService;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.StringUtils;

public class EyeProxyHandler
extends AbstractHttpHandler {
    public static final String PROXY_HEADER_KEY = Instance.getClusterName() + "MSPTrOoNxEy";
    public static final String PROXY_HEADER_VALUE = Instance.getClusterName() + "NSaAtRaAsShUaNNY";
    public static final String KEY = "proxyurl";
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    protected boolean appendProxyUrl;
    protected boolean isHtmlResp = false;

    public EyeProxyHandler(boolean appendProxyUrl) {
        this.appendProxyUrl = appendProxyUrl;
    }

    public EyeProxyHandler(boolean appendProxyUrl, boolean isHtmlResp) {
        this(appendProxyUrl);
        this.isHtmlResp = isHtmlResp;
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        try (StringWriter sw = new StringWriter();
             PrintWriter out = new PrintWriter(sw);){
            Map<String, String> params = this.getParams(exchange, true);
            String context = EyeUrlUtils.getHomeUrl(exchange, null);
            try {
                this.process(context, params, exchange);
                this.parseParamsForOpLog(exchange, params);
            }
            catch (Exception e) {
                this.parseParamsForOpLogWithError(exchange, params, e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            out.flush();
            this.writeHtml(sw.toString(), exchange);
        }
    }

    protected void process(String context, Map<String, String> params, HttpExchange exchange) throws Exception {
        Object response;
        Object response2;
        String url = params.get("url");
        if (!EyeAuther.checkPermission(exchange, url)) {
            ApiResponse response3 = new ApiResponse();
            response3.setCode(-1);
            response3.setData(null);
            response3.setMsg("No permission");
            String responseStr = JSONUtils.toString(response3);
            this.writeJson(responseStr, exchange);
            return;
        }
        if (!this.checkUrl(url, exchange)) {
            return;
        }
        if (this.appendProxyUrl) {
            url = url.contains("?") ? url + "&proxyurl=" + context + "proxy" : url + "?proxyurl=" + context + "proxy";
        }
        String method = exchange.getRequestMethod();
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        String errorMsg = "";
        int readTimeout = url.contains("pauseService") ? 5000 : READ_TIMEOUT * 1000;
        Headers headers = exchange.getRequestHeaders();
        HashMap map = new HashMap();
        for (Map.Entry entry : headers.entrySet()) {
            List lv = (List)entry.getValue();
            if (lv == null) continue;
            map.put(entry.getKey(), lv.get(0));
        }
        proxyHeader.put("Cookie", (String)map.get("Cookie"));
        try {
            if ("GET".equalsIgnoreCase(method)) {
                response2 = EyeHttpClients.get(url, proxyHeader, 5000, readTimeout);
                if (this.isHtmlResp) {
                    this.writeHtml((String)response2, exchange);
                } else {
                    this.writeJson((String)response2, exchange);
                }
            } else {
                InputStream in = exchange.getRequestBody();
                String text = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
                response = EyeHttpClients.postjson(url, proxyHeader, text, 5000, readTimeout);
                response = this.cleanXSSResponse((String)response);
                this.writeJson((String)response, exchange);
            }
        }
        catch (IOException e1) {
            if (url.contains("pauseService")) {
                try {
                    URL urlObj = new URL(url);
                    ZkManagerService.doUnRegisterRpc();
                    ZkManagerService.doUnRegisterMonitor((String)urlObj.getHost());
                    response = new ApiResponse();
                    ((ApiResponse)response).setData("The target server is not responding,and forcePaused success");
                    this.writeJson(JSONUtils.toString((Object)response), exchange);
                    return;
                }
                catch (Exception e2) {
                    errorMsg = errorMsg + "force Pause server exception:" + e2.getMessage();
                }
            } else {
                errorMsg = errorMsg + "server exception:" + ExceptionHandler.getExceptionStackTrace(e1);
            }
        }
        catch (Exception e) {
            errorMsg = errorMsg + ExceptionHandler.getExceptionStackTrace(e);
        }
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            response2 = new ApiResponse();
            ((ApiResponse)response2).setCode(1);
            ((ApiResponse)response2).setData(null);
            ((ApiResponse)response2).setMsg(errorMsg);
            this.writeJson(JSONUtils.toString((Object)response2), exchange);
        }
    }

    private boolean checkUrl(String url, HttpExchange exchange) throws IOException {
        boolean result = false;
        if (url == null) {
            return false;
        }
        String ip = null;
        try {
            int strStartIndex = url.indexOf("http://");
            int strEndIndex = url.indexOf("/monitor/goldeye");
            if (strStartIndex < 0 || strEndIndex < 0) {
                return false;
            }
            String destIpPort = url.substring(7, strEndIndex);
            int v6i = destIpPort.lastIndexOf("]");
            if (destIpPort.startsWith("[") && v6i > 0) {
                ip = destIpPort.substring(0, destIpPort.lastIndexOf("]") + 1);
            } else {
                String[] destIpPortArr = destIpPort.split(":");
                ip = destIpPortArr[0];
            }
            List serviceInfoList = ServiceInfoFactory.get().getServiceList();
            for (ServiceInfo serviceInfo : serviceInfoList) {
                if (!serviceInfo.getIp().equals(ip) && !serviceInfo.getHostIp().equals(ip)) continue;
                result = true;
                break;
            }
        }
        catch (Exception e) {
            SafeLogUtils.error(EyeProxyHandler.class, (String)"checkUrl exception", (Throwable)e);
            result = false;
        }
        if (!result) {
            ApiResponse response = new ApiResponse();
            response.setCode(-1);
            response.setData(null);
            response.setMsg(LangRes.get((String)"EyeProxyHandler_0", (String)"\u5f53\u524dIP[{0}]\u5df2\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u6ce8\u518c\u4e2d\u5fc3\u91cd\u8bd5", (Object[])new Object[]{ip}));
            String responseStr = JSONUtils.toString(response);
            this.writeJson(responseStr, exchange);
        }
        return result;
    }

    private void parseParamsForOpLog(HttpExchange exchange, Map<String, String> params) {
        String url = params.get("url");
        if (url == null) {
            return;
        }
        String[] urlSegments = url.split("/");
        String ip = "";
        ip = NetAddressUtils.isPreferIPv6() ? urlSegments[2].substring(0, urlSegments[2].lastIndexOf(":")) : urlSegments[2].split(":")[0];
        if (urlSegments.length < 6) {
            return;
        }
        String action = urlSegments[5];
        if (action.contains("threaddump")) {
            // empty if block
        }
        if (action.contains("metric")) {
            // empty if block
        }
        if (action.contains("datasource")) {
            // empty if block
        }
        if (action.contains("meminfo")) {
            // empty if block
        }
        if (action.contains("topCommand")) {
            // empty if block
        }
        if (action.contains("temptable")) {
            // empty if block
        }
        if (action.contains("algoXNodeCheck")) {
            // empty if block
        }
    }

    private void parseParamsForOpLogWithError(HttpExchange exchange, Map<String, String> params, Exception e) {
        String url = params.get("url");
        if (url == null) {
            return;
        }
        String[] urlSegments = url.split("/");
        String ip = urlSegments[2].split(":")[0];
        String action = urlSegments[5];
        if (action.contains("threaddump")) {
            // empty if block
        }
        if (action.contains("metric")) {
            // empty if block
        }
        if (action.contains("mqconsumermanage")) {
            // empty if block
        }
        if (action.contains("datasource")) {
            // empty if block
        }
        if (action.contains("meminfo")) {
            // empty if block
        }
        if (action.contains("topCommand")) {
            // empty if block
        }
        if (action.contains("temptable")) {
            // empty if block
        }
        if (action.contains("algoXNodeCheck")) {
            // empty if block
        }
    }
}

