/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.proxy;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;

public class EyeProxyHandler2
extends AbstractHttpHandler {
    private static final String PLACEHOLDER = "/abc/";
    private static final int readtimeout = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));

    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(PLACEHOLDER);
        reqPath = "http://" + reqPath.substring(pos + PLACEHOLDER.length());
        try {
            if (!this.isAccessUrl(reqPath)) {
                throw new RuntimeException("proxy target ip is forbidden.");
            }
            HashMap<String, String> proxyHeader = new HashMap<String, String>();
            proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
            String response = EyeHttpClients.get(reqPath, proxyHeader, 5000, readtimeout * 1000);
            response = this.cleanXSSResponse(response);
            this.writeJson(response, pExchange);
        }
        catch (Exception e) {
            String msg = this.cleanXSSResponse(e.getMessage());
            this.writeHtml(msg, pExchange);
        }
        pExchange.close();
    }

    private boolean isAccessUrl(String url) {
        List serviceList = ServiceInfoFactory.get().getServiceList();
        boolean isAccess = false;
        for (ServiceInfo info : serviceList) {
            if (!url.contains(info.getIp())) continue;
            isAccess = true;
            break;
        }
        return isAccess;
    }
}

