/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.config.client.zk.ZookeeperConfiguration;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.government.GovZKFactory;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class EyeZkFactory {
    private static final Log log = LogFactory.getLog(EyeZkFactory.class);
    public static final String SLASH_STR = "/";

    public static CuratorFramework getZKClient() {
        return ZKFactory.getZKClient((String)EyeZkFactory.getZKUrl());
    }

    public static String getZKUrl() {
        return GovZKFactory.getZKUrl();
    }

    public static String getZKUrl(String region) {
        if (StringUtils.isEmpty((String)region)) {
            return EyeZkFactory.getZKUrl();
        }
        String configUrl = SystemProperties.getWithEnv((String)region);
        if (configUrl == null) {
            configUrl = SystemProperties.getWithEnv((String)"configUrl");
        }
        return configUrl;
    }

    public static void saveZK(String childrenPath, String value) {
        try {
            String path = EyeZkFactory.getZKPath(childrenPath);
            CuratorFramework client = EyeZkFactory.getZKClient();
            Stat exists = (Stat)client.checkExists().forPath(path);
            if (exists == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(path, value.getBytes(StandardCharsets.UTF_8));
            } else {
                client.setData().forPath(path, value.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "saveZK error!", (Throwable)e);
        }
    }

    public static String getValue(String childrenPath) {
        try {
            String path = EyeZkFactory.getZKPath(childrenPath);
            CuratorFramework client = EyeZkFactory.getZKClient();
            Stat exists = (Stat)client.checkExists().forPath(path);
            if (exists == null) {
                return null;
            }
            return new String((byte[])client.getData().forPath(path), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "EyeZkFactory getValue error!", (Throwable)e);
        }
    }

    private static String getZKPath(String childrenPath) {
        StringBuilder pathSB = new StringBuilder();
        String rootPath = ZKFactory.getZkRootPath((String)EyeZkFactory.getZKUrl());
        pathSB.append(rootPath);
        if (!childrenPath.startsWith(SLASH_STR) && !rootPath.endsWith(SLASH_STR)) {
            pathSB.append(SLASH_STR);
        }
        pathSB.append(childrenPath);
        String path = pathSB.toString();
        return path;
    }

    public static void addListener(String childrenPath, ConfigurationChangeListener configurationChangeListener) {
        ZookeeperConfiguration zkconfig = new ZookeeperConfiguration(EyeZkFactory.getZKUrl(), EyeZkFactory.getZKPath(childrenPath));
        zkconfig.addConfigurationChangeListener(configurationChangeListener);
    }

    public static boolean isModifyZKUrl(String region, String currentUrl) {
        String govZKUrlKey = StringUtils.isEmpty((String)region) ? "gov.zk.url" : region;
        try {
            DBRequest dbRequest = new DBRequest();
            String querySql = "select fgovkey,fgovvalue from t_monitor_govern_config  where fclustername = ? and fgovkey = ?";
            ArrayList queryList = new ArrayList(2);
            Collections.addAll(queryList, Instance.getClusterName(), govZKUrlKey);
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
            List rows = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (rows.size() == 0) {
                String insertSql = "insert into t_monitor_govern_config values(?,?,?,?,?)";
                ArrayList insertList = new ArrayList(5);
                Collections.addAll(insertList, ID.genLongId(), Instance.getClusterName(), govZKUrlKey, currentUrl, LocalDateTime.now());
                dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
                MetadataFactory.getStatement().executeInsert((Request)dbRequest);
                return true;
            }
            String oldGovValue = ((Result)rows.get(0)).getString("fgovvalue");
            if (currentUrl.equals(oldGovValue)) {
                return false;
            }
            log.info("Eye\u914d\u7f6e\u7684zkUrl\u5730\u5740\u6709\u53d8\u5316...");
            String updateSql = "update t_monitor_govern_config set fgovvalue= ?,fupdatetime = ? where fclustername = ? and fgovkey = ?";
            ArrayList updateList = new ArrayList(4);
            Collections.addAll(updateList, currentUrl, LocalDate.now(), Instance.getClusterName(), govZKUrlKey);
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
            MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            return true;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return false;
        }
    }
}

