/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.eye.auth.SessionStore;
import kd.bos.session.RSAUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class MonitorLoginUtils {
    private static final String RSA_SUFFIX = "_rsa_key_value";
    private static final int KEY_TIME_OUT = 1800;
    private static final int PUBLIC_KEY_POSITION = 0;
    private static final int PRIVATE_KEY_POSITION = 1;

    public static String getBase64PublicKeyByUserName(String userName) {
        String publicKey;
        String cacheKey;
        DistributeSessionableCache cache = SessionStore.get().getCache();
        String keyPairString = (String)cache.get(cacheKey = userName + RSA_SUFFIX, (Object)userName);
        if (StringUtils.isEmpty((String)keyPairString)) {
            KeyPair keyPair = RSAUtils.generateKeyPair();
            String privateKey = RSAUtils.generateBase64Key((byte[])keyPair.getPrivate().getEncoded());
            publicKey = RSAUtils.generateBase64Key((byte[])keyPair.getPublic().getEncoded());
            cache.put(cacheKey, (Object)userName, (Object)(publicKey + "," + privateKey));
            cache.expireAfter(cacheKey, 1800);
        } else {
            publicKey = MonitorLoginUtils.getPublicKeyFromString(keyPairString);
            cache.put(cacheKey, (Object)userName, (Object)keyPairString);
            cache.expireAfter(cacheKey, 1800);
        }
        return publicKey;
    }

    public static String getDecryptPassword(String userName, String userPassword) {
        DistributeSessionableCache cache = SessionStore.get().getCache();
        String cacheKey = userName + RSA_SUFFIX;
        String keyPairString = (String)cache.get(cacheKey, (Object)userName);
        String privateKey = MonitorLoginUtils.getPrivateKeyFromString(keyPairString);
        return new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.decodeBase64((String)privateKey)), (byte[])Base64.decodeBase64((byte[])userPassword.getBytes(StandardCharsets.UTF_8))));
    }

    private static String getKeyFromString(String keyPairString, int position) {
        String[] keyPairArray;
        String publicKey = null;
        if (StringUtils.isNotEmpty((String)keyPairString) && (keyPairArray = keyPairString.split(",")).length == 2) {
            publicKey = keyPairArray[position];
        }
        return publicKey;
    }

    private static String getPublicKeyFromString(String keyPairString) {
        return MonitorLoginUtils.getKeyFromString(keyPairString, 0);
    }

    private static String getPrivateKeyFromString(String keyPairString) {
        return MonitorLoginUtils.getKeyFromString(keyPairString, 1);
    }

    public static String encryptPSWWihtSHA256(String password) {
        String encryptedPassword;
        byte[] btKey = new byte[password.getBytes(StandardCharsets.UTF_8).length];
        System.arraycopy(password.getBytes(StandardCharsets.UTF_8), 0, btKey, 0, password.getBytes(StandardCharsets.UTF_8).length);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(btKey);
            byte[] btDigest = md.digest();
            encryptedPassword = MonitorLoginUtils.toHex(btDigest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encryptedPassword;
    }

    private static String toHex(byte[] digests) {
        StringBuilder digestHex = new StringBuilder();
        for (byte digest : digests) {
            digestHex.append(String.format("%02x", digest & 0xFF));
        }
        return digestHex.toString();
    }
}

