/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kd.bos.util.StringUtils;

public class PBKDF2Util {
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final String PBKDF2_PRE = "PBK";
    public static final String NEW_USER_SUFFIX = "_NEW";
    public static final int SALT_BYTE_SIZE = 16;
    public static final int HASH_BIT_SIZE = 512;
    public static final int PBKDF2_ITERATIONS = 10000;

    public static boolean authenticate(String attemptedPassword, String encryptedPassword, String salt) {
        String iteration = PBKDF2Util.getPbkdf2Iterations(encryptedPassword);
        if (iteration == null || iteration.trim().length() == 0) {
            iteration = System.getProperty("monitor.pbkdf2.iterations", "10000");
        }
        String originalPwd = PBKDF2Util.splitDbPassword(encryptedPassword);
        String encryptedAttemptedPassword = PBKDF2Util.getEncryptedPassword(attemptedPassword, salt, iteration);
        if (encryptedAttemptedPassword.equals(originalPwd)) {
            return true;
        }
        String originalSalt = originalPwd.substring(0, 32);
        encryptedAttemptedPassword = originalSalt + PBKDF2Util.getEncryptedPassword(attemptedPassword, originalSalt, iteration);
        return encryptedAttemptedPassword.equals(originalPwd);
    }

    public static String getEncryptedPassword(String password, String salt) {
        String encryptPassword;
        try {
            String iterationsConfig = System.getProperty("monitor.pbkdf2.iterations");
            int iterations = StringUtils.isEmpty((String)iterationsConfig) ? 10000 : Integer.parseInt(iterationsConfig);
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), iterations, 512);
            SecretKeyFactory f = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            encryptPassword = PBKDF2Util.toHex(f.generateSecret(spec).getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encryptPassword;
    }

    public static String getEncryptedPassword(String password, String salt, String iterations) {
        String encryptPassword;
        try {
            String iterationsConfig = System.getProperty("monitor.pbkdf2.iterations");
            int iteration = StringUtils.isEmpty((String)iterationsConfig) ? 10000 : Integer.parseInt(iterationsConfig);
            iteration = StringUtils.isEmpty((String)iterations) ? iteration : Integer.parseInt(iterations);
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), iteration, 512);
            SecretKeyFactory f = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            encryptPassword = PBKDF2Util.toHex(f.generateSecret(spec).getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encryptPassword;
    }

    public static String generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return PBKDF2Util.toHex(salt);
    }

    public static String createDbPassword(String password) {
        String dbPassword;
        String iterationsConfig = System.getProperty("monitor.pbkdf2.iterations");
        String iteration = StringUtils.isEmpty((String)iterationsConfig) ? "10000" : iterationsConfig;
        try {
            String salt = PBKDF2Util.generateSalt();
            StringBuilder stringBuilder = new StringBuilder(PBKDF2_PRE);
            stringBuilder.append(iteration).append("_").append(salt).append(PBKDF2Util.getEncryptedPassword(password, salt));
            dbPassword = stringBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return dbPassword;
    }

    public static boolean isEncryptByPbkdf2(String dbPassword) {
        if (!StringUtils.isBlank((String)dbPassword)) {
            return dbPassword.startsWith(PBKDF2_PRE);
        }
        return false;
    }

    public static String splitDbPassword(String dbPassword) {
        String[] array = dbPassword.split("_");
        String password = array.length > 1 ? array[1] : array[0];
        return password;
    }

    public static String getPbkdf2Iterations(String dbPassword) {
        String[] arrays = dbPassword.split("_");
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(arrays[0]);
        String iterations = matcher.replaceAll("").trim();
        return iterations;
    }

    private static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }
}

