/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.auth.authorization;

import com.auth0.jwt.algorithms.Algorithm;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.mservice.auth.api.AuthContext;
import kd.bos.mservice.auth.api.AuthorizationService;
import kd.bos.mservice.auth.api.UserTokenAuthorization;
import kd.bos.mservice.auth.context.JWTAuthContext;
import kd.bos.mservice.auth.exception.AuthErrorCode;
import kd.bos.mservice.auth.exception.AuthException;
import kd.bos.mservice.auth.factory.JWTAlgorithmFactory;
import kd.bos.mservice.auth.util.AuthUtils;
import kd.bos.mservice.auth.util.JWTUtils;
import kd.bos.mservice.sdk.extension.SdkExtensionFactory;
import org.jetbrains.annotations.NotNull;

public class JWTAuthorizationServiceImpl
implements AuthorizationService {
    private static final SdkExtensionFactory<UserTokenAuthorization> userTokenAuthorizationSdkExtensionFactory = SdkExtensionFactory.getExtensionFacotry(UserTokenAuthorization.class);

    public boolean authorize(@NotNull AuthContext authContext) {
        String jwtCode = ((JWTAuthContext)authContext).getJwtToken();
        Algorithm algorithm = JWTAlgorithmFactory.getAlgorithm();
        Map claims = JWTUtils.verifyJWT((Algorithm)algorithm, (String)jwtCode);
        if (authContext.isEnableUserTokenAuth() || !AuthUtils.isTianShuService()) {
            this.checkUserToken(claims);
        } else {
            this.checkAccountInfo(claims);
        }
        return true;
    }

    private void checkUserToken(Map<String, String> claims) {
        String authToken = claims.get("userAuthToken");
        String appNumber = claims.get("sourceAppNumber");
        String authType = System.getProperty(appNumber + ".usertokenauthtype", appNumber);
        boolean existExctension = userTokenAuthorizationSdkExtensionFactory.existsExtension(authType);
        if (!existExctension) {
            throw new AuthException(AuthErrorCode.UNAUTHORIZED, new Object[]{BosRes.get((String)"bos-mservice-auth", (String)"authCheck6", (String)("\u6ca1\u6709\u5e94\u7528\u5bf9\u5e94\u7684\u7528\u6237\u9a8c\u8bc1\u5668\uff0c\u5e94\u7528\uff1a" + appNumber), (Object[])new Object[0])});
        }
        ((UserTokenAuthorization)userTokenAuthorizationSdkExtensionFactory.getExtension(authType)).doAuth(authToken);
    }

    private void checkAccountInfo(Map<String, String> claims) {
        String accountId = claims.get("accountId");
        String tenantId = claims.get("tenantId");
        try {
            AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        }
        catch (Exception e) {
            throw new AuthException((Throwable)e, AuthErrorCode.UNAUTHORIZED, new Object[]{BosRes.get((String)"bos-mservice-auth", (String)"authCheck4", (String)"\u5fae\u670d\u52a1\u9274\u6743\u4e0d\u901a\u8fc7\uff0c\u4e0d\u6b63\u786e\u7684\u79df\u6237\u4fe1\u606f\u3002", (Object[])new Object[0])});
        }
    }
}

