/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.auth.filter;

import kd.bos.bundle.BosRes;
import kd.bos.extension.ExtensionFactory;
import kd.bos.mservice.auth.api.AuthContext;
import kd.bos.mservice.auth.api.AuthorizationService;
import kd.bos.mservice.auth.api.Filter;
import kd.bos.mservice.auth.api.FilterChain;
import kd.bos.mservice.auth.constant.AuthType;
import kd.bos.mservice.auth.exception.AuthErrorCode;
import kd.bos.mservice.auth.exception.AuthException;
import kd.bos.mservice.sdk.extension.Activate;
import kd.bos.util.StringUtils;

@Activate(value={"${mservice.auth.enable}", "${mservice.auth.check.filter.enable}"}, order=-900000)
public class AuthCheckFilterImpl
implements Filter {
    public void doFilter(AuthContext authContext, FilterChain filterChain) {
        if (authContext == null) {
            throw new AuthException(AuthErrorCode.DATA_INVALID, new Object[]{BosRes.get((String)"bos-mservice-auth", (String)"authCheck3", (String)"\u5fae\u670d\u52a1\u9274\u6743\u4e0d\u901a\u8fc7\uff0c\u7f3a\u5c11\u9a8c\u6743\u4fe1\u606f\u3002", (Object[])new Object[0])});
        }
        String authType = this.getAuthType(authContext);
        ExtensionFactory extensionFactory = ExtensionFactory.getExtensionFacotry(AuthorizationService.class);
        if (extensionFactory.existsExtension(authType)) {
            try {
                AuthorizationService authorizationService = (AuthorizationService)extensionFactory.getExtension(authType);
                authorizationService.authorize(authContext);
            }
            catch (Exception e) {
                throw new AuthException((Throwable)e, AuthErrorCode.UNAUTHORIZED, new Object[]{BosRes.get((String)"bos-mservice-auth", (String)"authCheck2", (String)"\u5fae\u670d\u52a1\u9274\u6743\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\u3002", (Object[])new Object[0])});
            }
        } else {
            throw new AuthException(AuthErrorCode.DATA_INVALID, new Object[]{BosRes.get((String)"bos-mservice-auth", (String)"authCheck1", (String)"\u5fae\u670d\u52a1\u9274\u6743\u4e0d\u901a\u8fc7\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u7684\u8ba4\u8bc1\u65b9\u5f0f\u3002", (Object[])new Object[0])});
        }
        filterChain.doFilter(authContext);
    }

    private String getAuthType(AuthContext authContext) {
        String defaultAuthType = AuthType.getDefaultAuthType();
        return StringUtils.isNotEmpty((String)authContext.getAuthType()) ? authContext.getAuthType() : defaultAuthType;
    }
}

