/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.spi.define;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.mservice.spi.define.JavaType;

public class MServiceDefineMeta {
    private String serviceName;
    private String group;
    private String serviceInterface;
    private String serviceImplClass;
    private String pkg;
    private final Set<String> transProtocolTypes = new TreeSet<String>();
    private final Set<String> dataCodecs = new TreeSet<String>();
    private String[] appIds;
    private String serviceDesc;
    private boolean isRegisterOrginalInteface = false;
    private volatile transient boolean hasSortMethodState = false;
    private final List<MethodDefine> methods = new ArrayList<MethodDefine>(2);

    public static MServiceDefineMeta of(String serviceName, String group, String serviceInterface, String serviceImplClass, String[] transProtocolTypes, String[] dataCodecs, String[] appId, String serviceDesc) {
        Method[] methods;
        Class<?> mserviceDefineClass = null;
        try {
            Class.forName(serviceInterface);
            mserviceDefineClass = Class.forName(serviceImplClass);
        }
        catch (Exception e) {
            return null;
        }
        MServiceDefineMeta mServiceDefineMeta = new MServiceDefineMeta();
        mServiceDefineMeta.setServiceGroupAndName(group, serviceName);
        mServiceDefineMeta.setServiceInterface(serviceInterface);
        mServiceDefineMeta.setServiceImplClass(serviceImplClass);
        for (String tempTransType : transProtocolTypes) {
            mServiceDefineMeta.addTransProtocolTypes(tempTransType);
        }
        for (String tempDataCodec : dataCodecs) {
            mServiceDefineMeta.addDataCodecs(tempDataCodec);
        }
        mServiceDefineMeta.setAppIds(appId);
        mServiceDefineMeta.setServiceDesc(serviceDesc);
        for (Method tempMethod : methods = mserviceDefineClass.getDeclaredMethods()) {
            Parameter[] annotatedTypes;
            if (!Modifier.isPublic(tempMethod.getModifiers())) continue;
            MethodDefine methodDefine = new MethodDefine();
            mServiceDefineMeta.addMethod(methodDefine);
            methodDefine.setServiceMethodName(tempMethod.getName());
            methodDefine.setServiceMethodReturnObjectType(tempMethod.getGenericReturnType().getTypeName());
            for (Parameter tempParam : annotatedTypes = tempMethod.getParameters()) {
                ParamDefine paramDefine = new ParamDefine();
                paramDefine.setName(tempParam.getName());
                paramDefine.withType(JavaType.getType(tempParam.getParameterizedType().getTypeName()));
                methodDefine.addServiceMethodParam(paramDefine);
            }
        }
        return mServiceDefineMeta;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceGroupAndName(String group, String serviceName) {
        this.group = group;
        this.serviceName = group != null && group.length() > 0 && !"_sys".equals(group) ? group + "." + serviceName : serviceName;
    }

    public String getPkg() {
        return this.pkg;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
        String getpkg = this.getPackage(serviceInterface);
        if (getpkg != null) {
            this.pkg = getpkg;
        }
    }

    public String getServiceImplClass() {
        return this.serviceImplClass;
    }

    public void setServiceImplClass(String serviceImplClass) {
        this.serviceImplClass = serviceImplClass;
        if (this.pkg == null) {
            this.pkg = this.getPackage(serviceImplClass);
        }
    }

    private String getPackage(String classOrInterface) {
        if (classOrInterface == null || classOrInterface.length() == 0) {
            return null;
        }
        int endIndex = classOrInterface.lastIndexOf(46);
        if (endIndex <= 0) {
            return null;
        }
        return classOrInterface.substring(0, endIndex);
    }

    public Set<String> getTransProtocolTypes() {
        return this.transProtocolTypes;
    }

    public void addTransProtocolTypes(String transProtocolType) {
        this.transProtocolTypes.add(transProtocolType);
    }

    public Set<String> getDataCodecs() {
        return this.dataCodecs;
    }

    public void addDataCodecs(String dataCodec) {
        this.dataCodecs.add(dataCodec);
    }

    public String[] getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String[] appIds) {
        this.appIds = appIds;
    }

    public String getServiceDesc() {
        return this.serviceDesc;
    }

    public void setServiceDesc(String serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    public List<MethodDefine> getMethods() {
        if (!this.hasSortMethodState) {
            this.methods.sort((o1, o2) -> {
                String max2;
                String max1 = o1.getServiceMethodName();
                if (!max1.equals(max2 = o2.getServiceMethodName())) {
                    return max1.compareTo(max2);
                }
                List<ParamDefine> pls1 = o1.getServiceMethodParams();
                List<ParamDefine> pls2 = o2.getServiceMethodParams();
                int psizeCompare = pls1.size() - pls2.size();
                if (psizeCompare != 0) {
                    return psizeCompare;
                }
                for (int index = 0; index < pls1.size(); ++index) {
                    ParamDefine pd1 = pls1.get(index);
                    ParamDefine pd2 = pls2.get(index);
                    if (pd1.typeStr == null) {
                        return 1;
                    }
                    if (pd2.typeStr == null) {
                        return -1;
                    }
                    if (pd1.typeStr.equals(pd2.typeStr)) continue;
                    return pd1.typeStr.compareTo(pd2.typeStr);
                }
                return -1;
            });
            this.hasSortMethodState = true;
        }
        return this.methods;
    }

    public void addMethod(MethodDefine method) {
        this.hasSortMethodState = false;
        this.methods.add(method);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isRegisterOrginalInteface() {
        return this.isRegisterOrginalInteface;
    }

    public void setRegisterOrginalInteface(boolean isRegisterOrginalInteface) {
        this.isRegisterOrginalInteface = isRegisterOrginalInteface;
    }

    public static class ParamDefine
    implements Serializable {
        private String name;
        private String typeStr;
        private String simpleTypeStr;
        private int level;
        private int arrayLevel = 0;
        private List<ParamDefine> childParamDefines = new ArrayList<ParamDefine>();
        private boolean required;
        private String describe;
        private Object example;
        private boolean isMulValue = false;
        private boolean isArray = false;
        private boolean isMap = false;
        private boolean isPrimitive = false;

        public ParamDefine() {
        }

        public ParamDefine(String name, String typeStr) {
            this.name = name;
            this.typeStr = typeStr;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getArrayLevel() {
            return this.arrayLevel;
        }

        public void setArrayLevel(int arrayLevel) {
            this.arrayLevel = arrayLevel;
        }

        public boolean isMulValue() {
            return this.isMulValue;
        }

        public void setMulValue(boolean mulValue) {
            this.isMulValue = mulValue;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public void setArray(boolean array) {
            this.isArray = array;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public void setMap(boolean map) {
            this.isMap = map;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTypeStr() {
            return this.typeStr;
        }

        public void setTypeStr(String typeStr) {
            this.typeStr = typeStr;
        }

        public String getSimpleTypeStr() {
            return this.simpleTypeStr;
        }

        public void setSimpleTypeStr(String simpleTypeStr) {
            this.simpleTypeStr = simpleTypeStr;
        }

        public List<ParamDefine> getChildParamDefines() {
            return this.childParamDefines;
        }

        public void setChildParamDefines(List<ParamDefine> paramDefines) {
            this.childParamDefines = paramDefines;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public String getDescribe() {
            return this.describe;
        }

        public void setDescribe(String describe) {
            this.describe = describe;
        }

        public Object getExample() {
            return this.example;
        }

        public void setExample(Object example) {
            this.example = example;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        public void setPrimitive(boolean primitive) {
            this.isPrimitive = primitive;
        }

        public JavaType type() {
            if (this.typeStr == null) {
                return null;
            }
            return JavaType.getType(this.typeStr);
        }

        public void withType(JavaType type) {
            this.typeStr = type.name();
        }
    }

    public static class MethodDefine {
        private String serviceMethodName;
        private String serviceMethodPath;
        private List<ParamDefine> serviceMethodParams = new ArrayList<ParamDefine>(2);
        private String serviceMethodReturnObjectType;
        private ParamDefine serviceMethodReturnParamDefine;
        private String serviceMethodDesc;

        public String getServiceMethodName() {
            return this.serviceMethodName;
        }

        public void setServiceMethodName(String serviceMethodName) {
            this.serviceMethodName = serviceMethodName;
        }

        public void addServiceMethodParam(ParamDefine serviceMethodParam) {
            this.serviceMethodParams.add(serviceMethodParam);
        }

        public List<ParamDefine> getServiceMethodParams() {
            return this.serviceMethodParams;
        }

        public void setServiceMethodParams(List<ParamDefine> serviceMethodParam) {
            this.serviceMethodParams = serviceMethodParam;
        }

        public String getServiceMethodReturnObjectType() {
            return this.serviceMethodReturnObjectType;
        }

        public void setServiceMethodReturnObjectType(String serviceMethodReturnObjectType) {
            this.serviceMethodReturnObjectType = serviceMethodReturnObjectType;
        }

        public ParamDefine getServiceMethodReturnParamDefine() {
            return this.serviceMethodReturnParamDefine;
        }

        public void setServiceMethodReturnParamDefine(ParamDefine serviceMethodReturnParamDefine) {
            this.serviceMethodReturnParamDefine = serviceMethodReturnParamDefine;
        }

        public String getServiceMethodDesc() {
            return this.serviceMethodDesc;
        }

        public void setServiceMethodDesc(String serviceMethodDesc) {
            this.serviceMethodDesc = serviceMethodDesc;
        }

        public String getServiceMethodPath() {
            return this.serviceMethodPath;
        }

        public void setServiceMethodPath(String serviceMethodPath) {
            this.serviceMethodPath = serviceMethodPath;
        }
    }
}

